/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.i2p.data.RouterIdentity;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.FIFOBandwidthLimiter;
import net.i2p.util.Log;

public class BandwidthLimitedInputStream
extends FilterInputStream {
    private Log _log;
    private RouterIdentity _peer;
    private String _peerSource;
    private RouterContext _context;
    private boolean _pullFromOutbound;
    private FIFOBandwidthLimiter.Request _currentRequest;

    public BandwidthLimitedInputStream(RouterContext context, InputStream source, RouterIdentity peer) {
        this(context, source, peer, false);
    }

    public BandwidthLimitedInputStream(RouterContext context, InputStream source, RouterIdentity peer, boolean pullFromOutbound) {
        super(source);
        this._context = context;
        this._peer = peer;
        if (peer != null) {
            this._peerSource = peer.getHash().toBase64();
        }
        this._pullFromOutbound = pullFromOutbound;
        this._log = context.logManager().getLog(BandwidthLimitedInputStream.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        this._currentRequest = this._pullFromOutbound ? this._context.bandwidthLimiter().requestOutbound(1, this._peerSource) : this._context.bandwidthLimiter().requestInbound(1, this._peerSource);
        this._currentRequest.waitForNextAllocation();
        BandwidthLimitedInputStream bandwidthLimitedInputStream = this;
        synchronized (bandwidthLimitedInputStream) {
            this._currentRequest = null;
        }
        return this.in.read();
    }

    public int read(byte[] dest) throws IOException {
        return this.read(dest, 0, dest.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] dest, int off, int len) throws IOException {
        int read = this.in.read(dest, off, len);
        if (read == -1) {
            return -1;
        }
        this._currentRequest = this._pullFromOutbound ? this._context.bandwidthLimiter().requestOutbound(read, this._peerSource) : this._context.bandwidthLimiter().requestInbound(read, this._peerSource);
        while (this._currentRequest.getPendingInboundRequested() > 0 || this._currentRequest.getPendingOutboundRequested() > 0) {
            this._currentRequest.waitForNextAllocation();
            if (!this._currentRequest.getAborted()) continue;
            if (!this._log.shouldLog(30)) break;
            this._log.warn("Request aborted while trying to read " + len + " (actually read " + read + ")");
            break;
        }
        BandwidthLimitedInputStream bandwidthLimitedInputStream = this;
        synchronized (bandwidthLimitedInputStream) {
            this._currentRequest = null;
        }
        return read;
    }

    public long skip(long numBytes) throws IOException {
        long skip = this.in.skip(numBytes);
        this._currentRequest = this._pullFromOutbound ? this._context.bandwidthLimiter().requestOutbound((int)skip, this._peerSource) : this._context.bandwidthLimiter().requestInbound((int)skip, this._peerSource);
        while (this._currentRequest.getPendingInboundRequested() > 0 || this._currentRequest.getPendingOutboundRequested() > 0) {
            this._currentRequest.waitForNextAllocation();
            if (!this._currentRequest.getAborted()) continue;
            if (!this._log.shouldLog(30)) break;
            this._log.warn("Request aborted while trying to skip " + numBytes);
            break;
        }
        return skip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        BandwidthLimitedInputStream bandwidthLimitedInputStream = this;
        synchronized (bandwidthLimitedInputStream) {
            if (this._currentRequest != null) {
                this._currentRequest.abort();
            }
        }
        super.close();
    }
}

