/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.startup;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Properties;
import net.i2p.data.DataHelper;

public class WorkingDir {
    private static final String PROP_BASE_DIR = "i2p.dir.base";
    private static final String PROP_WORKING_DIR = "i2p.dir.config";
    private static final String WORKING_DIR_DEFAULT_WINDOWS = "I2P";
    private static final String WORKING_DIR_DEFAULT = ".i2p";
    private static final String MIGRATE_BASE = "addressbook,eepsite,blocklist.txt,hosts.txt,i2psnark.config,i2ptunnel.config,jetty-i2psnark.xml,logger.config,router.config,systray.config";

    public static String getWorkingDir(Properties envProps, boolean migrateOldConfig) {
        File oldDirf;
        File test;
        String dir = null;
        if (envProps != null) {
            dir = envProps.getProperty(PROP_WORKING_DIR);
        }
        if (dir == null) {
            dir = System.getProperty(PROP_WORKING_DIR);
        }
        boolean isWindows = System.getProperty("os.name").startsWith("Win");
        File dirf = null;
        if (dir != null) {
            dirf = new File(dir);
        } else {
            String home = System.getProperty("user.home");
            if (isWindows) {
                String appdata = System.getenv("APPDATA");
                if (appdata != null) {
                    home = appdata;
                }
                dirf = new File(home, WORKING_DIR_DEFAULT_WINDOWS);
            } else {
                dirf = new File(home, WORKING_DIR_DEFAULT);
            }
        }
        String cwd = null;
        if (envProps != null) {
            cwd = envProps.getProperty(PROP_BASE_DIR);
        }
        if (cwd == null && (cwd = System.getProperty(PROP_BASE_DIR)) == null) {
            cwd = System.getProperty("user.dir");
        }
        if (!(test = new File(oldDirf = new File(cwd), "hosts.txt")).exists()) {
            System.err.println("ERROR - Cannot find I2P installation in " + cwd + " - Will probably be just a router with no apps or console at all!");
            return cwd;
        }
        try {
            if (oldDirf.getCanonicalPath().equals(dirf.getCanonicalPath())) {
                return cwd;
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        String rv = dirf.getAbsolutePath();
        if (dirf.exists()) {
            if (dirf.isDirectory()) {
                return rv;
            }
            System.err.println("Wanted to use " + rv + " for a working directory but it is not a directory");
            return cwd;
        }
        test = new File(oldDirf, "router.keys");
        boolean oldInstall = test.exists();
        if (!oldInstall) {
            test = new File(oldDirf, "logs");
            oldInstall = test.exists();
        }
        if (oldInstall && !migrateOldConfig) {
            return cwd;
        }
        boolean migrateOldData = false;
        if (!dirf.mkdir()) {
            System.err.println("Wanted to use " + rv + " for a working directory but could not create it");
            return cwd;
        }
        if (migrateOldData) {
            System.err.println("Migrating data files to new user directory " + rv);
        } else {
            System.err.println("Setting up new user directory " + rv);
        }
        boolean success = WorkingDir.migrate(MIGRATE_BASE, oldDirf, dirf);
        success &= WorkingDir.migrateJettyXml(oldDirf, dirf);
        success &= WorkingDir.migrateClientsConfig(oldDirf, dirf);
        if (success &= WorkingDir.copy(new File(oldDirf, "docs/news.xml"), new File(dirf, "docs"))) {
            System.err.println("Successfully copied data files to new user directory " + rv);
            return rv;
        }
        System.err.println("FAILED copy of some or all data files to new directory " + rv);
        System.err.println("Check logs for details");
        System.err.println("Continung to use data files in old directory " + cwd);
        return cwd;
    }

    private static boolean migrate(String list, File olddir, File todir) {
        boolean rv = true;
        String[] files = list.split(",");
        for (int i = 0; i < files.length; ++i) {
            File from = new File(olddir, files[i]);
            if (WorkingDir.copy(from, todir)) continue;
            System.err.println("Error copying " + from.getAbsolutePath());
            rv = false;
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean migrateClientsConfig(File olddir, File todir) {
        File oldFile = new File(olddir, "clients.config");
        File newFile = new File(todir, "clients.config");
        FileInputStream in = null;
        PrintWriter out = null;
        try {
            in = new FileInputStream(oldFile);
            out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(newFile), "UTF-8")));
            out.println("# Modified by I2P User dir migration script");
            String s = null;
            while ((s = DataHelper.readLine((InputStream)in)) != null) {
                if (s.endsWith("=\"eepsite/jetty.xml\"")) {
                    s = s.replace("=\"eepsite/jetty.xml\"", "=\"" + todir.getAbsolutePath() + File.separatorChar + "eepsite" + File.separatorChar + "jetty.xml\"");
                }
                out.println(s);
            }
            System.err.println("Copied clients.config with modifications");
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            if (in != null) {
                System.err.println("FAILED copy clients.config");
                boolean bl = false;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean migrateJettyXml(File olddir, File todir) {
        File eepsite1 = new File(olddir, "eepsite");
        File oldFile = new File(eepsite1, "jetty.xml");
        File eepsite2 = new File(todir, "eepsite");
        File newFile = new File(eepsite2, "jetty.xml");
        FileInputStream in = null;
        PrintWriter out = null;
        try {
            in = new FileInputStream(oldFile);
            out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(newFile), "UTF-8")));
            String s = null;
            while ((s = DataHelper.readLine((InputStream)in)) != null) {
                if (s.indexOf("./eepsite/") >= 0) {
                    s = s.replace("./eepsite/", todir.getAbsolutePath() + File.separatorChar + "eepsite" + File.separatorChar);
                }
                out.println(s);
            }
            out.println("<!-- Modified by I2P User dir migration script -->");
            System.err.println("Copied jetty.xml with modifications");
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            if (in != null) {
                System.err.println("FAILED copy jetty.xml");
                boolean bl = false;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public static final boolean copy(File src, File targetDir) {
        if (!src.exists()) {
            return true;
        }
        if (!targetDir.exists()) {
            if (!targetDir.mkdir()) {
                System.err.println("FAILED copy " + src.getPath());
                return false;
            }
            System.err.println("Created " + targetDir.getPath());
        }
        File targetFile = new File(targetDir, src.getName());
        if (!src.isDirectory()) {
            return WorkingDir.copyFile(src, targetFile);
        }
        File[] children = src.listFiles();
        if (children == null) {
            System.err.println("FAILED copy " + src.getPath());
            return false;
        }
        if (!targetFile.exists()) {
            if (!targetFile.mkdir()) {
                System.err.println("FAILED copy " + src.getPath());
                return false;
            }
            System.err.println("Created " + targetFile.getPath());
        }
        boolean rv = true;
        for (int i = 0; i < children.length; ++i) {
            rv &= WorkingDir.copy(children[i], targetFile);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File src, File dst) {
        if (!src.exists()) {
            return false;
        }
        boolean rv = true;
        byte[] buf = new byte[4096];
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(src);
            out = new FileOutputStream(dst);
            int read = 0;
            while ((read = in.read(buf)) != -1) {
                out.write(buf, 0, read);
            }
            System.err.println("Copied " + src.getPath());
        }
        catch (IOException ioe) {
            System.err.println("FAILED copy " + src.getPath());
            rv = false;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ioe) {}
            }
        }
        if (rv) {
            dst.setLastModified(src.lastModified());
        }
        return rv;
    }
}

