/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.startup;

import java.io.File;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;

public class ReadConfigJob
extends JobImpl {
    private static final long DELAY = 30000L;
    private long _lastRead = -1L;

    public ReadConfigJob(RouterContext ctx) {
        super(ctx);
    }

    public String getName() {
        return "Read Router Configuration";
    }

    public void runJob() {
        if (this.shouldReread()) {
            this.getContext().router().readConfig();
            this._lastRead = this.getContext().clock().now();
        }
        this.getTiming().setStartAfter(this.getContext().clock().now() + 30000L);
        this.getContext().jobQueue().addJob(this);
    }

    private boolean shouldReread() {
        File configFile = new File(this.getContext().router().getConfigFilename());
        if (!configFile.exists()) {
            return false;
        }
        return configFile.lastModified() > this._lastRead;
    }
}

