/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.startup;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.startup.ClientAppConfig;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

public class LoadClientAppsJob
extends JobImpl {
    private Log _log;
    private static boolean _loaded = false;

    public LoadClientAppsJob(RouterContext ctx) {
        super(ctx);
        this._log = ctx.logManager().getLog(LoadClientAppsJob.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runJob() {
        Class<LoadClientAppsJob> clazz = LoadClientAppsJob.class;
        synchronized (LoadClientAppsJob.class) {
            if (_loaded) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            _loaded = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            List apps = ClientAppConfig.getClientApps(this.getContext());
            if (apps.size() <= 0) {
                this._log.error("Warning - No client apps or router console configured - we are just a router");
                System.err.println("Warning - No client apps or router console configured - we are just a router");
                return;
            }
            for (int i = 0; i < apps.size(); ++i) {
                ClientAppConfig app = (ClientAppConfig)apps.get(i);
                if (app.disabled) continue;
                String[] argVal = LoadClientAppsJob.parseArgs(app.args);
                if (app.delay == 0L) {
                    LoadClientAppsJob.runClient(app.className, app.clientName, argVal, this._log);
                    continue;
                }
                this.getContext().jobQueue().addJob(new DelayedRunClient(this.getContext(), app.className, app.clientName, argVal, app.delay));
            }
            return;
        }
    }

    public static String[] parseArgs(String args) {
        ArrayList<String> argList = new ArrayList<String>(4);
        if (args != null) {
            String str;
            char[] data = args.toCharArray();
            StringBuilder buf = new StringBuilder(32);
            boolean isQuoted = false;
            block4: for (int i = 0; i < data.length; ++i) {
                switch (data[i]) {
                    case '\"': 
                    case '\'': {
                        String str2;
                        if (isQuoted) {
                            str2 = buf.toString().trim();
                            if (str2.length() > 0) {
                                argList.add(str2);
                            }
                            buf = new StringBuilder(32);
                            continue block4;
                        }
                        isQuoted = true;
                        continue block4;
                    }
                    case '\t': 
                    case ' ': {
                        if (isQuoted) {
                            buf.append(data[i]);
                            continue block4;
                        }
                        String str2 = buf.toString().trim();
                        if (str2.length() > 0) {
                            argList.add(str2);
                        }
                        buf = new StringBuilder(32);
                        continue block4;
                    }
                    default: {
                        buf.append(data[i]);
                    }
                }
            }
            if (buf.length() > 0 && (str = buf.toString().trim()).length() > 0) {
                argList.add(str);
            }
        }
        String[] rv = new String[argList.size()];
        for (int i = 0; i < argList.size(); ++i) {
            rv[i] = (String)argList.get(i);
        }
        return rv;
    }

    public static void runClient(String className, String clientName, String[] args, Log log) {
        log.info("Loading up the client application " + clientName + ": " + className + " " + args);
        I2PThread t = new I2PThread((Runnable)new RunApp(className, clientName, args, log));
        if (clientName == null) {
            clientName = className + " client";
        }
        t.setName(clientName);
        t.setDaemon(true);
        t.start();
    }

    public String getName() {
        return "Load up any client applications";
    }

    public static void main(String[] args) {
        LoadClientAppsJob.test(null);
        LoadClientAppsJob.test("hi how are you?");
        LoadClientAppsJob.test("hi how are you? ");
        LoadClientAppsJob.test(" hi how are you? ");
        LoadClientAppsJob.test(" hi how are \"y\"ou? ");
        LoadClientAppsJob.test("-nogui -e \"config localhost 17654\" -e \"httpclient 4544\"");
        LoadClientAppsJob.test("-nogui -e 'config localhost 17654' -e 'httpclient 4544'");
    }

    private static void test(String args) {
        String[] parsed = LoadClientAppsJob.parseArgs(args);
        System.out.print("Parsed [" + args + "] into " + parsed.length + " elements: ");
        for (int i = 0; i < parsed.length; ++i) {
            System.out.print("[" + parsed[i] + "] ");
        }
        System.out.println();
    }

    private static final class RunApp
    implements Runnable {
        private String _className;
        private String _appName;
        private String[] _args;
        private Log _log;

        public RunApp(String className, String appName, String[] args, Log log) {
            this._className = className;
            this._appName = appName;
            this._args = args == null ? new String[0] : args;
            this._log = log;
        }

        public void run() {
            try {
                Class<?> cls = Class.forName(this._className);
                Method method = cls.getMethod("main", String[].class);
                method.invoke(cls, new Object[]{this._args});
            }
            catch (Throwable t) {
                this._log.log(50, "Error starting up the client class " + this._className, t);
            }
            this._log.info("Done running client application " + this._appName);
        }
    }

    private class DelayedRunClient
    extends JobImpl {
        private String _className;
        private String _clientName;
        private String[] _args;

        public DelayedRunClient(RouterContext enclosingContext, String className, String clientName, String[] args, long delay) {
            super(enclosingContext);
            this._className = className;
            this._clientName = clientName;
            this._args = args;
            this.getTiming().setStartAfter(LoadClientAppsJob.this.getContext().clock().now() + delay);
        }

        public String getName() {
            return "Delayed client job";
        }

        public void runJob() {
            LoadClientAppsJob.runClient(this._className, this._clientName, this._args, LoadClientAppsJob.this._log);
        }
    }
}

