/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.peermanager;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.router.RouterContext;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.util.Log;

class ProfilePersistenceHelper {
    private Log _log;
    private RouterContext _context;
    public static final String PROP_PEER_PROFILE_DIR = "router.profileDir";
    public static final String DEFAULT_PEER_PROFILE_DIR = "peerProfiles";
    private static final String NL = System.getProperty("line.separator");
    public static final long EXPIRE_AGE = 259200000L;
    private File _profileDir = null;
    private Hash _us;

    public ProfilePersistenceHelper(RouterContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(ProfilePersistenceHelper.class);
        File profileDir = this.getProfileDir();
        this._us = null;
        if (!profileDir.exists()) {
            profileDir.mkdirs();
            this._log.info("Profile directory " + profileDir.getAbsolutePath() + " created");
        }
    }

    public void setUs(Hash routerIdentHash) {
        this._us = routerIdentHash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeProfile(PeerProfile profile) {
        if (this.isExpired(profile.getLastSendSuccessful())) {
            return;
        }
        File f = this.pickFile(profile);
        long before = this._context.clock().now();
        OutputStream fos = null;
        try {
            fos = new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(f)));
            this.writeProfile(profile, fos);
        }
        catch (IOException ioe) {
            this._log.error("Error writing profile to " + f);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioe) {}
            }
        }
        long delay = this._context.clock().now() - before;
        if (this._log.shouldLog(10)) {
            this._log.debug("Writing the profile to " + f.getName() + " took " + delay + "ms");
        }
    }

    public void writeProfile(PeerProfile profile, OutputStream out) throws IOException {
        String groups = null;
        if (this._context.profileOrganizer().isFailing(profile.getPeer())) {
            groups = "failing";
        } else if (!this._context.profileOrganizer().isHighCapacity(profile.getPeer())) {
            groups = "not failing";
        } else {
            groups = this._context.profileOrganizer().isFast(profile.getPeer()) ? "fast and high capacity" : "high capacity";
            if (this._context.profileOrganizer().isWellIntegrated(profile.getPeer())) {
                groups = groups + ", well integrated";
            }
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append("########################################################################").append(NL);
        buf.append("# profile for ").append(profile.getPeer().toBase64()).append(NL);
        if (this._us != null) {
            buf.append("# as calculated by ").append(this._us.toBase64()).append(NL);
        }
        buf.append("#").append(NL);
        buf.append("# capacity: ").append(profile.getCapacityValue()).append(NL);
        buf.append("# integration: ").append(profile.getIntegrationValue()).append(NL);
        buf.append("# speedValue: ").append(profile.getSpeedValue()).append(NL);
        buf.append("#").append(NL);
        buf.append("# Groups: ").append(groups).append(NL);
        buf.append("########################################################################").append(NL);
        buf.append("##").append(NL);
        buf.append("# Capacity bonus: used to affect the capacity score after all other calculations are done").append(NL);
        buf.append("capacityBonus=").append(profile.getCapacityBonus()).append(NL);
        buf.append("# Integration bonus: used to affect the integration score after all other calculations are done").append(NL);
        buf.append("integrationBonus=").append(profile.getIntegrationBonus()).append(NL);
        buf.append("# Speed bonus: used to affect the speed score after all other calculations are done").append(NL);
        buf.append("speedBonus=").append(profile.getSpeedBonus()).append(NL);
        buf.append(NL).append(NL);
        buf.append("# Last heard about: when did we last get a reference to this peer?  (milliseconds since the epoch)").append(NL);
        buf.append("lastHeardAbout=").append(profile.getLastHeardAbout()).append(NL);
        buf.append("# First heard about: when did we first get a reference to this peer?  (milliseconds since the epoch)").append(NL);
        buf.append("firstHeardAbout=").append(profile.getFirstHeardAbout()).append(NL);
        buf.append("# Last sent to successfully: when did we last send the peer a message successfully?  (milliseconds from the epoch)").append(NL);
        buf.append("lastSentToSuccessfully=").append(profile.getLastSendSuccessful()).append(NL);
        buf.append("# Last failed send: when did we last fail to send a message to the peer?  (milliseconds from the epoch)").append(NL);
        buf.append("lastFailedSend=").append(profile.getLastSendFailed()).append(NL);
        buf.append("# Last heard from: when did we last get a message from the peer?  (milliseconds from the epoch)").append(NL);
        buf.append("lastHeardFrom=").append(profile.getLastHeardFrom()).append(NL);
        buf.append("# moving average as to how fast the peer replies").append(NL);
        buf.append("tunnelTestTimeAverage=").append(profile.getTunnelTestTimeAverage()).append(NL);
        buf.append("tunnelPeakThroughput=").append(profile.getPeakThroughputKBps()).append(NL);
        buf.append("tunnelPeakTunnelThroughput=").append(profile.getPeakTunnelThroughputKBps()).append(NL);
        buf.append("tunnelPeakTunnel1mThroughput=").append(profile.getPeakTunnel1mThroughputKBps()).append(NL);
        buf.append(NL);
        out.write(buf.toString().getBytes());
        profile.getTunnelHistory().store(out);
        profile.getDBHistory().store(out);
        if (profile.getIsExpanded()) {
            profile.getDbIntroduction().store(out, "dbIntroduction");
            profile.getDbResponseTime().store(out, "dbResponseTime");
            profile.getReceiveSize().store(out, "receiveSize");
            profile.getSendSuccessSize().store(out, "sendSuccessSize");
            profile.getTunnelCreateResponseTime().store(out, "tunnelCreateResponseTime");
            profile.getTunnelTestResponseTime().store(out, "tunnelTestResponseTime");
        }
    }

    public Set readProfiles() {
        long start = this._context.clock().now();
        Set files = this.selectFiles();
        HashSet<PeerProfile> profiles = new HashSet<PeerProfile>(files.size());
        for (File f : files) {
            PeerProfile profile = this.readProfile(f);
            if (profile == null) continue;
            profiles.add(profile);
        }
        long duration = this._context.clock().now() - start;
        if (this._log.shouldLog(10)) {
            this._log.debug("Loading " + profiles.size() + " took " + duration + "ms");
        }
        return profiles;
    }

    private Set selectFiles() {
        File[] files = this.getProfileDir().listFiles(new FilenameFilter(){

            public boolean accept(File dir, String filename) {
                return filename.startsWith("profile-") && filename.endsWith(".dat");
            }
        });
        HashSet<File> rv = new HashSet<File>(files.length);
        for (int i = 0; i < files.length; ++i) {
            rv.add(files[i]);
        }
        return rv;
    }

    private boolean isExpired(long lastSentToSuccessfully) {
        long timeSince = this._context.clock().now() - lastSentToSuccessfully;
        return timeSince > 259200000L;
    }

    public PeerProfile readProfile(File file) {
        Hash peer = this.getHash(file.getName());
        try {
            if (peer == null) {
                this._log.error("The file " + file.getName() + " is not a valid hash");
                return null;
            }
            PeerProfile profile = new PeerProfile(this._context, peer);
            Properties props = new Properties();
            this.loadProps(props, file);
            long lastSentToSuccessfully = ProfilePersistenceHelper.getLong(props, "lastSentToSuccessfully");
            if (this.isExpired(lastSentToSuccessfully)) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Dropping old profile for " + file.getName() + ", since we haven't heard from them in a long time");
                }
                file.delete();
                return null;
            }
            profile.setCapacityBonus(ProfilePersistenceHelper.getLong(props, "capacityBonus"));
            profile.setIntegrationBonus(ProfilePersistenceHelper.getLong(props, "integrationBonus"));
            profile.setSpeedBonus(ProfilePersistenceHelper.getLong(props, "speedBonus"));
            profile.setLastHeardAbout(ProfilePersistenceHelper.getLong(props, "lastHeardAbout"));
            profile.setFirstHeardAbout(ProfilePersistenceHelper.getLong(props, "firstHeardAbout"));
            profile.setLastSendSuccessful(ProfilePersistenceHelper.getLong(props, "lastSentToSuccessfully"));
            profile.setLastSendFailed(ProfilePersistenceHelper.getLong(props, "lastFailedSend"));
            profile.setLastHeardFrom(ProfilePersistenceHelper.getLong(props, "lastHeardFrom"));
            profile.setTunnelTestTimeAverage(ProfilePersistenceHelper.getDouble(props, "tunnelTestTimeAverage"));
            profile.setPeakThroughputKBps(ProfilePersistenceHelper.getDouble(props, "tunnelPeakThroughput"));
            profile.setPeakTunnelThroughputKBps(ProfilePersistenceHelper.getDouble(props, "tunnelPeakTunnelThroughput"));
            profile.setPeakTunnel1mThroughputKBps(ProfilePersistenceHelper.getDouble(props, "tunnelPeakTunnel1mThroughput"));
            profile.getTunnelHistory().load(props);
            profile.getDBHistory().load(props);
            profile.getDbIntroduction().load(props, "dbIntroduction", true);
            profile.getDbResponseTime().load(props, "dbResponseTime", true);
            profile.getReceiveSize().load(props, "receiveSize", true);
            profile.getSendSuccessSize().load(props, "sendSuccessSize", true);
            profile.getTunnelCreateResponseTime().load(props, "tunnelCreateResponseTime", true);
            profile.getTunnelTestResponseTime().load(props, "tunnelTestResponseTime", true);
            if (this._log.shouldLog(10)) {
                this._log.debug("Loaded the profile for " + peer.toBase64() + " from " + file.getName());
            }
            return profile;
        }
        catch (IllegalArgumentException iae) {
            this._log.error("Error loading profile from " + file.getName(), (Throwable)iae);
            file.delete();
            return null;
        }
    }

    private static final long getLong(Properties props, String key) {
        String val = props.getProperty(key);
        if (val != null) {
            try {
                return Long.parseLong(val);
            }
            catch (NumberFormatException nfe) {
                return 0L;
            }
        }
        return 0L;
    }

    private static final double getDouble(Properties props, String key) {
        String val = props.getProperty(key);
        if (val != null) {
            try {
                return Double.parseDouble(val);
            }
            catch (NumberFormatException nfe) {
                return 0.0;
            }
        }
        return 0.0;
    }

    private void loadProps(Properties props, File file) {
        block6: {
            try {
                FileInputStream fin = new FileInputStream(file);
                int c = fin.read();
                fin.close();
                fin = new FileInputStream(file);
                if (c == 35) {
                    if (this._log.shouldLog(20)) {
                        this._log.info("Loading uncompressed profile data from " + file.getName());
                    }
                    DataHelper.loadProps((Properties)props, (InputStream)fin);
                } else {
                    if (this._log.shouldLog(20)) {
                        this._log.info("Loading compressed profile data from " + file.getName());
                    }
                    DataHelper.loadProps((Properties)props, (InputStream)new GZIPInputStream(fin));
                }
            }
            catch (IOException ioe) {
                if (!this._log.shouldLog(30)) break block6;
                this._log.warn("Error loading properties from " + file.getName(), (Throwable)ioe);
            }
        }
    }

    private Hash getHash(String name) {
        String key = name.substring("profile-".length());
        key = key.substring(0, key.length() - ".dat".length());
        Hash h = new Hash();
        try {
            h.fromBase64(key);
            return h;
        }
        catch (DataFormatException dfe) {
            this._log.warn("Invalid base64 [" + key + "]", (Throwable)dfe);
            return null;
        }
    }

    private File pickFile(PeerProfile profile) {
        return new File(this.getProfileDir(), "profile-" + profile.getPeer().toBase64() + ".dat");
    }

    private File getProfileDir() {
        if (this._profileDir == null) {
            String dir = this._context.getProperty(PROP_PEER_PROFILE_DIR, DEFAULT_PEER_PROFILE_DIR);
            this._profileDir = new File(this._context.getRouterDir(), dir);
        }
        return this._profileDir;
    }

    public static void main(String[] args) {
        System.out.println("Generating 1000 profiles");
        File dir = new File("profiles");
        dir.mkdirs();
        byte[] data = new byte[32];
        Random rnd = new Random();
        for (int i = 0; i < 1000; ++i) {
            rnd.nextBytes(data);
            Hash peer = new Hash(data);
            try {
                File f = new File(dir, "profile-" + peer.toBase64() + ".dat");
                f.createNewFile();
                System.out.println("Created " + peer.toBase64());
                continue;
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        System.out.println("1000 peers created in " + dir.getAbsolutePath());
    }
}

