/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.reseed;

import java.io.File;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.reseed.Reseeder;
import net.i2p.util.Log;

public class ReseedChecker {
    private static final int MINIMUM = 15;

    public static void checkReseed(RouterContext context, int count) {
        if (count >= 15) {
            return;
        }
        File noReseedFile = new File(new File(System.getProperty("user.home")), ".i2pnoreseed");
        File noReseedFileAlt1 = new File(new File(System.getProperty("user.home")), "noreseed.i2p");
        File noReseedFileAlt2 = new File(context.getConfigDir(), ".i2pnoreseed");
        File noReseedFileAlt3 = new File(context.getConfigDir(), "noreseed.i2p");
        if (!(noReseedFile.exists() || noReseedFileAlt1.exists() || noReseedFileAlt2.exists() || noReseedFileAlt3.exists())) {
            Log _log = context.logManager().getLog(ReseedChecker.class);
            if (count <= 1) {
                _log.error("Downloading peer router information for a new I2P installation");
            } else {
                _log.error("Very few routerInfo files remaining - reseeding now");
            }
            Reseeder reseeder = new Reseeder(context);
            reseeder.requestReseed();
        }
    }
}

