/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructure;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.RouterInfo;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.DataStore;
import net.i2p.util.Log;

class TransientDataStore
implements DataStore {
    private Log _log;
    private Map<Hash, DataStructure> _data;
    protected RouterContext _context;
    private static final long MAX_FUTURE_PUBLISH_DATE = 300000L;
    private static final long MAX_FUTURE_EXPIRATION_DATE = 1200000L;

    public TransientDataStore(RouterContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(TransientDataStore.class);
        this._data = new ConcurrentHashMap<Hash, DataStructure>(1024);
        if (this._log.shouldLog(20)) {
            this._log.info("Data Store initialized");
        }
    }

    public boolean isInitialized() {
        return true;
    }

    public void stop() {
        this._data.clear();
    }

    public void restart() {
        this.stop();
    }

    public void rescan() {
    }

    public Set getKeys() {
        return new HashSet<Hash>(this._data.keySet());
    }

    public DataStructure get(Hash key, boolean persist) {
        throw new IllegalArgumentException("no");
    }

    public DataStructure get(Hash key) {
        return this._data.get(key);
    }

    public boolean isKnown(Hash key) {
        return this._data.containsKey(key);
    }

    public int countLeaseSets() {
        int count = 0;
        for (DataStructure d : this._data.values()) {
            if (!(d instanceof LeaseSet)) continue;
            ++count;
        }
        return count;
    }

    public void put(Hash key, DataStructure data, boolean persist) {
        throw new IllegalArgumentException("no");
    }

    public void put(Hash key, DataStructure data) {
        if (data == null) {
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Storing key " + key);
        }
        DataStructure old = null;
        old = this._data.put(key, data);
        if (data instanceof RouterInfo) {
            this._context.profileManager().heardAbout(key);
            RouterInfo ri = (RouterInfo)data;
            if (old != null) {
                RouterInfo ori = (RouterInfo)old;
                if (ri.getPublished() < ori.getPublished()) {
                    if (this._log.shouldLog(20)) {
                        this._log.info("Almost clobbered an old router! " + key + ": [old published on " + new Date(ori.getPublished()) + " new on " + new Date(ri.getPublished()) + "]");
                    }
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Number of router options for " + key + ": " + ri.getOptions().size() + " (old one had: " + ori.getOptions().size() + ")", (Throwable)new Exception("Updated routerInfo"));
                    }
                    this._data.put(key, old);
                } else if (ri.getPublished() > this._context.clock().now() + 300000L) {
                    if (this._log.shouldLog(20)) {
                        this._log.info("Hmm, someone tried to give us something with the publication date really far in the future (" + new Date(ri.getPublished()) + "), dropping it");
                    }
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Number of router options for " + key + ": " + ri.getOptions().size() + " (old one had: " + ori.getOptions().size() + ")", (Throwable)new Exception("Updated routerInfo"));
                    }
                    this._data.put(key, old);
                } else {
                    if (this._log.shouldLog(20)) {
                        this._log.info("Updated the old router for " + key + ": [old published on " + new Date(ori.getPublished()) + " new on " + new Date(ri.getPublished()) + "]");
                    }
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Number of router options for " + key + ": " + ri.getOptions().size() + " (old one had: " + ori.getOptions().size() + ")", (Throwable)new Exception("Updated routerInfo"));
                    }
                }
            } else {
                if (this._log.shouldLog(20)) {
                    this._log.info("Brand new router for " + key + ": published on " + new Date(ri.getPublished()));
                }
                if (this._log.shouldLog(10)) {
                    this._log.debug("Number of router options for " + key + ": " + ri.getOptions().size(), (Throwable)new Exception("Updated routerInfo"));
                }
            }
        } else if (data instanceof LeaseSet) {
            LeaseSet ls = (LeaseSet)data;
            if (old != null) {
                LeaseSet ols = (LeaseSet)old;
                if (ls.getEarliestLeaseDate() < ols.getEarliestLeaseDate()) {
                    if (this._log.shouldLog(20)) {
                        this._log.info("Almost clobbered an old leaseSet! " + key + ": [old published on " + new Date(ols.getEarliestLeaseDate()) + " new on " + new Date(ls.getEarliestLeaseDate()) + "]");
                    }
                    this._data.put(key, old);
                } else if (ls.getEarliestLeaseDate() > this._context.clock().now() + 1200000L) {
                    if (this._log.shouldLog(20)) {
                        this._log.info("Hmm, someone tried to give us something with the expiration date really far in the future (" + new Date(ls.getEarliestLeaseDate()) + "), dropping it");
                    }
                    this._data.put(key, old);
                }
            }
        }
    }

    public int hashCode() {
        return DataHelper.hashCode(this._data);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TransientDataStore ds = (TransientDataStore)obj;
        return DataHelper.eq(ds._data, this._data);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Transient DataStore: ").append(this._data.size()).append("\nKeys: ");
        for (Map.Entry<Hash, DataStructure> e : this._data.entrySet()) {
            Hash key = e.getKey();
            DataStructure dp = e.getValue();
            buf.append("\n\t*Key:   ").append(key.toString()).append("\n\tContent: ").append(dp.toString());
        }
        buf.append("\n");
        return buf.toString();
    }

    public DataStructure remove(Hash key, boolean persist) {
        throw new IllegalArgumentException("no");
    }

    public DataStructure remove(Hash key) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Removing key " + key.toBase64());
        }
        return this._data.remove(key);
    }
}

