/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.RouterInfo;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.KBucketSet;
import net.i2p.router.networkdb.kademlia.SelectionCollector;
import net.i2p.util.Log;

public class PeerSelector {
    protected Log _log;
    protected RouterContext _context;

    public PeerSelector(RouterContext ctx) {
        this._context = ctx;
        this._log = this._context.logManager().getLog(this.getClass());
    }

    public List selectMostReliablePeers(Hash key, int numClosest, Set alreadyChecked, KBucketSet kbuckets) {
        List nearest = this.selectNearestExplicit(key, numClosest, alreadyChecked, kbuckets);
        return nearest;
    }

    public List selectNearestExplicit(Hash key, int maxNumRouters, Set peersToIgnore, KBucketSet kbuckets) {
        return this.selectNearestExplicitThin(key, maxNumRouters, peersToIgnore, kbuckets);
    }

    public List selectNearestExplicitThin(Hash key, int maxNumRouters, Set peersToIgnore, KBucketSet kbuckets) {
        if (peersToIgnore == null) {
            peersToIgnore = new HashSet<Hash>(1);
        }
        peersToIgnore.add(this._context.routerHash());
        MatchSelectionCollector matches = new MatchSelectionCollector(key, peersToIgnore);
        kbuckets.getAll(matches);
        List rv = matches.get(maxNumRouters);
        if (this._log.shouldLog(10)) {
            this._log.debug("Searching for " + maxNumRouters + " peers close to " + key + ": " + rv + " (not including " + peersToIgnore + ") [allHashes.size = " + matches.size() + "]");
        }
        return rv;
    }

    private void removeFailingPeers(Set peerHashes) {
        ArrayList<Hash> failing = null;
        for (Hash cur : peerHashes) {
            if (this._context.profileOrganizer().isFailing(cur)) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Peer " + cur.toBase64() + " is failing, don't include them in the peer selection");
                }
                if (failing == null) {
                    failing = new ArrayList<Hash>(4);
                }
                failing.add(cur);
                continue;
            }
            if (!this._context.profileOrganizer().peerSendsBadReplies(cur)) continue;
            this._log.warn("Peer " + cur.toBase64() + " sends us bad replies (but we still query them)");
        }
        if (failing != null) {
            peerHashes.removeAll(failing);
        }
    }

    public static BigInteger getDistance(Hash targetKey, Hash routerInQuestion) {
        byte[] diff = DataHelper.xor((byte[])routerInQuestion.getData(), (byte[])targetKey.getData());
        return new BigInteger(1, diff);
    }

    public List selectNearest(Hash key, int maxNumRouters, Set peersToIgnore, KBucketSet kbuckets) {
        return this.selectNearestExplicit(key, maxNumRouters, peersToIgnore, kbuckets);
    }

    private class MatchSelectionCollector
    implements SelectionCollector {
        private TreeMap _sorted;
        private Hash _key;
        private Set _toIgnore;
        private int _matches;

        public MatchSelectionCollector(Hash key, Set toIgnore) {
            this._key = key;
            this._sorted = new TreeMap();
            this._toIgnore = toIgnore;
            this._matches = 0;
        }

        public void add(Hash entry) {
            if (PeerSelector.this._context.profileOrganizer().isFailing(entry)) {
                return;
            }
            if (this._toIgnore.contains(entry)) {
                return;
            }
            RouterInfo info = PeerSelector.this._context.netDb().lookupRouterInfoLocally(entry);
            if (info == null) {
                return;
            }
            if (info.getIdentity().isHidden()) {
                return;
            }
            BigInteger diff = PeerSelector.getDistance(this._key, entry);
            this._sorted.put(diff, entry);
            ++this._matches;
        }

        public List get(int howMany) {
            ArrayList rv = new ArrayList(howMany);
            for (int i = 0; i < howMany && this._sorted.size() > 0; ++i) {
                rv.add(this._sorted.remove(this._sorted.firstKey()));
            }
            return rv;
        }

        public int size() {
            return this._matches;
        }
    }
}

