/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructure;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.Lease;
import net.i2p.data.LeaseSet;
import net.i2p.data.RouterAddress;
import net.i2p.data.RouterInfo;
import net.i2p.router.Job;
import net.i2p.router.NetworkDatabaseFacade;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelPoolSettings;
import net.i2p.router.networkdb.DatabaseLookupMessageHandler;
import net.i2p.router.networkdb.DatabaseStoreMessageHandler;
import net.i2p.router.networkdb.PublishLocalRouterInfoJob;
import net.i2p.router.networkdb.kademlia.DataStore;
import net.i2p.router.networkdb.kademlia.ExpireLeasesJob;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.HarvesterJob;
import net.i2p.router.networkdb.kademlia.KBucketSet;
import net.i2p.router.networkdb.kademlia.PeerSelector;
import net.i2p.router.networkdb.kademlia.PersistentDataStore;
import net.i2p.router.networkdb.kademlia.RepublishLeaseSetJob;
import net.i2p.router.networkdb.kademlia.SearchJob;
import net.i2p.router.networkdb.kademlia.SelectionCollector;
import net.i2p.router.networkdb.kademlia.StartExplorersJob;
import net.i2p.router.networkdb.kademlia.StoreJob;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.util.Log;
import net.i2p.util.ObjectCounter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KademliaNetworkDatabaseFacade
extends NetworkDatabaseFacade {
    protected Log _log;
    private KBucketSet _kb;
    private DataStore _ds;
    private String _dbDir;
    private final Set<Hash> _exploreKeys = new HashSet<Hash>(64);
    private boolean _initialized;
    private long _started;
    private StartExplorersJob _exploreJob;
    private HarvesterJob _harvestJob;
    private long _lastExploreNew;
    protected PeerSelector _peerSelector;
    protected RouterContext _context;
    private final Map<Hash, RepublishLeaseSetJob> _publishingLeaseSets;
    private final Map<Hash, SearchJob> _activeRequests;
    protected static final long DONT_FAIL_PERIOD = 600000L;
    private boolean _quiet = false;
    public static final String PROP_ENFORCE_NETID = "router.networkDatabase.enforceNetId";
    private static final boolean DEFAULT_ENFORCE_NETID = false;
    private boolean _enforceNetId = false;
    public static final String PROP_DB_DIR = "router.networkDatabase.dbDir";
    public static final String DEFAULT_DB_DIR = "netDb";
    protected static final int MIN_REMAINING_ROUTERS = 25;
    private static final long ROUTER_INFO_EXPIRATION = 259200000L;
    private static final long ROUTER_INFO_EXPIRATION_MIN = 10800000L;
    private static final long ROUTER_INFO_EXPIRATION_SHORT = 5400000L;
    private static final long ROUTER_INFO_EXPIRATION_FLOODFILL = 3600000L;
    private static final long EXPLORE_JOB_DELAY = 600000L;
    private static final long PUBLISH_JOB_DELAY = 300000L;
    private static final long PUBLISH_DELAY = 3000L;
    static final long MAX_LEASE_FUTURE = 1200000L;
    private static final int MIN_PER_PEER_TIMEOUT = 5000;
    private static final int MAX_PER_PEER_TIMEOUT = 10000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void searchComplete(Hash key) {
        if (this._log.shouldLog(10)) {
            this._log.debug("search Complete: " + key);
        }
        SearchJob removed = null;
        Map<Hash, SearchJob> map = this._activeRequests;
        synchronized (map) {
            removed = this._activeRequests.remove(key);
        }
    }

    public KademliaNetworkDatabaseFacade(RouterContext context) {
        this._context = context;
        this._log = this._context.logManager().getLog(this.getClass());
        this._initialized = false;
        this._peerSelector = this.createPeerSelector();
        this._publishingLeaseSets = new HashMap<Hash, RepublishLeaseSetJob>(8);
        this._lastExploreNew = 0L;
        this._activeRequests = new HashMap<Hash, SearchJob>(8);
        this._enforceNetId = false;
        context.statManager().createRateStat("netDb.lookupLeaseSetDeferred", "how many lookups are deferred for a single leaseSet lookup?", "NetworkDatabase", new long[]{60000L, 300000L});
        context.statManager().createRateStat("netDb.exploreKeySet", "how many keys are queued for exploration?", "NetworkDatabase", new long[]{600000L});
    }

    @Override
    public boolean isInitialized() {
        return this._initialized && this._ds != null && this._ds.isInitialized();
    }

    protected PeerSelector createPeerSelector() {
        return new PeerSelector(this._context);
    }

    public PeerSelector getPeerSelector() {
        return this._peerSelector;
    }

    KBucketSet getKBuckets() {
        return this._kb;
    }

    DataStore getDataStore() {
        return this._ds;
    }

    long getLastExploreNewDate() {
        return this._lastExploreNew;
    }

    void setLastExploreNewDate(long when) {
        this._lastExploreNew = when;
        if (this._exploreJob != null) {
            this._exploreJob.updateExploreSchedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Hash> getExploreKeys() {
        if (!this._initialized) {
            return null;
        }
        Set<Hash> set = this._exploreKeys;
        synchronized (set) {
            return new HashSet<Hash>(this._exploreKeys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromExploreKeys(Set toRemove) {
        if (!this._initialized) {
            return;
        }
        Set<Hash> set = this._exploreKeys;
        synchronized (set) {
            this._exploreKeys.removeAll(toRemove);
            this._context.statManager().addRateData("netDb.exploreKeySet", (long)this._exploreKeys.size(), 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueForExploration(Set keys) {
        if (!this._initialized) {
            return;
        }
        Set<Hash> set = this._exploreKeys;
        synchronized (set) {
            this._exploreKeys.addAll(keys);
            this._context.statManager().addRateData("netDb.exploreKeySet", (long)this._exploreKeys.size(), 0L);
        }
    }

    @Override
    public void shutdown() {
        this._initialized = false;
        this._kb = null;
        if (this._ds != null) {
            this._ds.stop();
        }
        this._ds = null;
        this._exploreKeys.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restart() {
        String enforce;
        this._dbDir = this._context.router().getConfigSetting(PROP_DB_DIR);
        if (this._dbDir == null) {
            this._log.info("No DB dir specified [router.networkDatabase.dbDir], using [netDb]");
            this._dbDir = DEFAULT_DB_DIR;
        }
        this._enforceNetId = (enforce = this._context.getProperty(PROP_ENFORCE_NETID)) != null ? Boolean.valueOf(enforce) : false;
        this._ds.restart();
        Set<Hash> set = this._exploreKeys;
        synchronized (set) {
            this._exploreKeys.clear();
        }
        this._initialized = true;
        RouterInfo ri = this._context.router().getRouterInfo();
        this.publish(ri);
    }

    @Override
    public void rescan() {
        if (this.isInitialized()) {
            this._ds.rescan();
        }
    }

    String getDbDir() {
        return this._dbDir;
    }

    @Override
    public void startup() {
        String enforce;
        this._log.info("Starting up the kademlia network database");
        RouterInfo ri = this._context.router().getRouterInfo();
        String dbDir = this._context.router().getConfigSetting(PROP_DB_DIR);
        if (dbDir == null) {
            this._log.info("No DB dir specified [router.networkDatabase.dbDir], using [netDb]");
            dbDir = DEFAULT_DB_DIR;
        }
        this._enforceNetId = (enforce = this._context.getProperty(PROP_ENFORCE_NETID)) != null ? Boolean.valueOf(enforce) : false;
        this._kb = new KBucketSet(this._context, ri.getIdentity().getHash());
        this._ds = new PersistentDataStore(this._context, dbDir, this);
        this._dbDir = dbDir;
        this.createHandlers();
        this._initialized = true;
        this._started = System.currentTimeMillis();
        this._context.jobQueue().addJob(new ExpireLeasesJob(this._context, this));
        if (!this._quiet) {
            if (this._exploreJob == null) {
                this._exploreJob = new StartExplorersJob(this._context, this);
            }
            this._exploreJob.getTiming().setStartAfter(this._context.clock().now() + 600000L);
            this._context.jobQueue().addJob(this._exploreJob);
            if (this._harvestJob == null && "true".equals(this._context.getProperty("netDb.shouldHarvest"))) {
                this._harvestJob = new HarvesterJob(this._context, this);
            }
            this._context.jobQueue().addJob(this._harvestJob);
        } else {
            this._log.warn("Operating in quiet mode - not exploring or pushing data proactively, simply reactively");
            this._log.warn("This should NOT be used in production");
        }
        PublishLocalRouterInfoJob plrij = new PublishLocalRouterInfoJob(this._context);
        plrij.getTiming().setStartAfter(this._context.clock().now() + 300000L);
        this._context.jobQueue().addJob(plrij);
        try {
            this.publish(ri);
        }
        catch (IllegalArgumentException iae) {
            this._context.router().rebuildRouterInfo(true);
        }
    }

    protected void createHandlers() {
        this._context.inNetMessagePool().registerHandlerJobBuilder(2, new DatabaseLookupMessageHandler(this._context));
        this._context.inNetMessagePool().registerHandlerJobBuilder(1, new DatabaseStoreMessageHandler(this._context));
    }

    @Override
    public Set<RouterInfo> findNearestRouters(Hash key, int maxNumRouters, Set peersToIgnore) {
        if (!this._initialized) {
            return null;
        }
        return this.getRouters(this._peerSelector.selectNearest(key, maxNumRouters, peersToIgnore, this._kb));
    }

    private Set<RouterInfo> getRouters(Collection hashes) {
        if (!this._initialized) {
            return null;
        }
        HashSet<RouterInfo> rv = new HashSet<RouterInfo>(hashes.size());
        for (Hash rhash : hashes) {
            DataStructure ds = this._ds.get(rhash);
            if (ds == null) {
                if (!this._log.shouldLog(20)) continue;
                this._log.info("Selected hash " + rhash.toBase64() + " is not stored locally");
                continue;
            }
            if (!(ds instanceof RouterInfo)) continue;
            rv.add((RouterInfo)ds);
        }
        return rv;
    }

    @Override
    public Set<Hash> getAllRouters() {
        if (!this._initialized) {
            return new HashSet<Hash>(0);
        }
        Set keys = this._ds.getKeys();
        HashSet<Hash> rv = new HashSet<Hash>(keys.size());
        if (this._log.shouldLog(10)) {
            this._log.debug("getAllRouters(): # keys in the datastore: " + keys.size());
        }
        for (Hash key : keys) {
            DataStructure ds = this._ds.get(key);
            if (ds == null) {
                if (!this._log.shouldLog(20)) continue;
                this._log.info("Selected hash " + key.toBase64() + " is not stored locally");
                continue;
            }
            if (!(ds instanceof RouterInfo)) continue;
            if (this._log.shouldLog(10)) {
                this._log.debug("getAllRouters(): key is router: " + key.toBase64());
            }
            rv.add(key);
        }
        return rv;
    }

    @Override
    public int getKnownRouters() {
        if (this._kb == null) {
            return 0;
        }
        CountRouters count = new CountRouters();
        this._kb.getAll(count);
        return count.size();
    }

    @Override
    public int getKnownLeaseSets() {
        if (this._ds == null) {
            return 0;
        }
        return this._ds.countLeaseSets();
    }

    protected int getKBucketSetSize() {
        if (this._kb == null) {
            return 0;
        }
        return this._kb.size();
    }

    @Override
    public void lookupLeaseSet(Hash key, Job onFindJob, Job onFailedLookupJob, long timeoutMs) {
        if (!this._initialized) {
            return;
        }
        LeaseSet ls = this.lookupLeaseSetLocally(key);
        if (ls != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("leaseSet found locally, firing " + onFindJob);
            }
            if (onFindJob != null) {
                this._context.jobQueue().addJob(onFindJob);
            }
        } else {
            if (this._log.shouldLog(10)) {
                this._log.debug("leaseSet not found locally, running search");
            }
            this.search(key, onFindJob, onFailedLookupJob, timeoutMs, true);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("after lookupLeaseSet");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LeaseSet lookupLeaseSetLocally(Hash key) {
        if (!this._initialized) {
            return null;
        }
        if (this._ds.isKnown(key)) {
            DataStructure ds = this._ds.get(key);
            if (ds instanceof LeaseSet) {
                LeaseSet ls = (LeaseSet)ds;
                if (ls.isCurrent(60000L)) {
                    return ls;
                }
                this.fail(key);
                Set<Hash> set = this._exploreKeys;
                synchronized (set) {
                    this._exploreKeys.add(key);
                }
                return null;
            }
            return null;
        }
        return null;
    }

    @Override
    public void lookupRouterInfo(Hash key, Job onFindJob, Job onFailedLookupJob, long timeoutMs) {
        if (!this._initialized) {
            return;
        }
        RouterInfo ri = this.lookupRouterInfoLocally(key);
        if (ri != null) {
            if (onFindJob != null) {
                this._context.jobQueue().addJob(onFindJob);
            }
        } else {
            this.search(key, onFindJob, onFailedLookupJob, timeoutMs, false);
        }
    }

    @Override
    public RouterInfo lookupRouterInfoLocally(Hash key) {
        if (!this._initialized) {
            return null;
        }
        DataStructure ds = this._ds.get(key);
        if (ds != null) {
            if (ds instanceof RouterInfo) {
                boolean valid = true;
                try {
                    valid = null == this.validate(key, (RouterInfo)ds);
                }
                catch (IllegalArgumentException iae) {
                    valid = false;
                }
                if (!valid) {
                    this.fail(key);
                    return null;
                }
                return (RouterInfo)ds;
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LeaseSet localLeaseSet) {
        int code;
        if (!this._initialized) {
            return;
        }
        Hash h = localLeaseSet.getDestination().calculateHash();
        try {
            this.store(h, localLeaseSet);
        }
        catch (IllegalArgumentException iae) {
            this._log.error("wtf, locally published leaseSet is not valid?", (Throwable)iae);
            return;
        }
        if (!this._context.clientManager().shouldPublishLeaseSet(h)) {
            return;
        }
        if (this._context.router().gracefulShutdownInProgress() && ((code = this._context.router().scheduledGracefulExitCode()) == 2 || code == 3)) {
            return;
        }
        RepublishLeaseSetJob j = null;
        Map<Hash, RepublishLeaseSetJob> map = this._publishingLeaseSets;
        synchronized (map) {
            j = this._publishingLeaseSets.get(h);
            if (j == null) {
                j = new RepublishLeaseSetJob(this._context, this, h);
                this._publishingLeaseSets.put(h, j);
            }
        }
        long nextTime = Math.max(j.lastPublished() + j.REPUBLISH_LEASESET_TIMEOUT, this._context.clock().now() + 3000L);
        j.getTiming().setStartAfter(nextTime);
        this._context.jobQueue().addJob(j);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopPublishing(Hash target) {
        Map<Hash, RepublishLeaseSetJob> map = this._publishingLeaseSets;
        synchronized (map) {
            this._publishingLeaseSets.remove(target);
        }
    }

    @Override
    public void publish(RouterInfo localRouterInfo) throws IllegalArgumentException {
        if (!this._initialized) {
            return;
        }
        if (this._context.router().gracefulShutdownInProgress()) {
            return;
        }
        if (this._context.router().isHidden()) {
            return;
        }
        Hash h = localRouterInfo.getIdentity().getHash();
        this.store(h, localRouterInfo);
    }

    String validate(Hash key, LeaseSet leaseSet) {
        if (!key.equals((Object)leaseSet.getDestination().calculateHash())) {
            if (this._log.shouldLog(40)) {
                this._log.error("Invalid store attempt! key does not match leaseSet.destination!  key = " + key + ", leaseSet = " + leaseSet);
            }
            return "Key does not match leaseSet.destination - " + key.toBase64();
        }
        if (!leaseSet.verifySignature()) {
            if (this._log.shouldLog(40)) {
                this._log.error("Invalid leaseSet signature!  leaseSet = " + leaseSet);
            }
            return "Invalid leaseSet signature on " + leaseSet.getDestination().calculateHash().toBase64();
        }
        if (leaseSet.getEarliestLeaseDate() <= this._context.clock().now() - 120000L) {
            long age = this._context.clock().now() - leaseSet.getEarliestLeaseDate();
            if (this._log.shouldLog(30)) {
                this._log.warn("Old leaseSet!  not storing it: " + leaseSet.getDestination().calculateHash().toBase64() + " expires on " + new Date(leaseSet.getEarliestLeaseDate()), (Throwable)new Exception("Rejecting store"));
            }
            return "Expired leaseSet for " + leaseSet.getDestination().calculateHash().toBase64() + " expired " + DataHelper.formatDuration((long)age) + " ago";
        }
        if (leaseSet.getEarliestLeaseDate() > this._context.clock().now() + 60000L + 1200000L) {
            long age = leaseSet.getEarliestLeaseDate() - this._context.clock().now();
            if (this._log.shouldLog(40)) {
                this._log.error("LeaseSet to expire too far in the future: " + leaseSet.getDestination().calculateHash().toBase64() + " expires on " + new Date(leaseSet.getEarliestLeaseDate()), (Throwable)new Exception("Rejecting store"));
            }
            return "Future expiring leaseSet for " + leaseSet.getDestination().calculateHash().toBase64() + " expiring in " + DataHelper.formatDuration((long)age);
        }
        return null;
    }

    @Override
    public LeaseSet store(Hash key, LeaseSet leaseSet) throws IllegalArgumentException {
        if (!this._initialized) {
            return null;
        }
        LeaseSet rv = (LeaseSet)this._ds.get(key);
        if (rv != null && rv.equals((Object)leaseSet)) {
            return rv;
        }
        String err = this.validate(key, leaseSet);
        if (err != null) {
            throw new IllegalArgumentException("Invalid store attempt - " + err);
        }
        this._ds.put(key, (DataStructure)leaseSet);
        if (rv != null) {
            block0: for (int i = 0; i < rv.getLeaseCount(); ++i) {
                Lease old = rv.getLease(i);
                for (int j = 0; j < leaseSet.getLeaseCount(); ++j) {
                    Lease cur = leaseSet.getLease(j);
                    if (cur.getTunnelId().getTunnelId() != old.getTunnelId().getTunnelId()) continue;
                    cur.setNumFailure(old.getNumFailure());
                    cur.setNumSuccess(old.getNumSuccess());
                    continue block0;
                }
            }
        }
        return rv;
    }

    String validate(Hash key, RouterInfo routerInfo) throws IllegalArgumentException {
        long now = this._context.clock().now();
        boolean upLongEnough = this._context.router().getUptime() > 3600000L;
        long adjustedExpiration = FloodfillNetworkDatabaseFacade.floodfillEnabled(this._context) ? 3600000L : Math.min(259200000L, 10800000L + 37260000000L / (long)(this._kb.size() + 1));
        if (!key.equals((Object)routerInfo.getIdentity().getHash())) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Invalid store attempt! key does not match routerInfo.identity!  key = " + key + ", router = " + routerInfo);
            }
            return "Key does not match routerInfo.identity - " + key.toBase64();
        }
        if (!routerInfo.isValid()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Invalid routerInfo signature!  forged router structure!  router = " + routerInfo);
            }
            return "Invalid routerInfo signature on " + key.toBase64();
        }
        if (upLongEnough && !routerInfo.isCurrent(adjustedExpiration)) {
            if (routerInfo.getNetworkId() != 2) {
                this._context.shitlist().shitlistRouter(key, "Peer is not in our network");
                return "Peer is not in our network (" + routerInfo.getNetworkId() + ", wants " + 2 + "): " + routerInfo.calculateHash().toBase64();
            }
            long age = this._context.clock().now() - routerInfo.getPublished();
            int existing = this._kb.size();
            if (existing >= 25) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Not storing expired router for " + key.toBase64(), (Throwable)new Exception("Rejecting store"));
                }
                return "Peer " + key.toBase64() + " expired " + DataHelper.formatDuration((long)age) + " ago";
            }
            if (this._log.shouldLog(30)) {
                this._log.warn("Even though the peer is old, we have only " + existing + " peers left (curPeer: " + key.toBase64() + " published on " + new Date(routerInfo.getPublished()));
            }
        } else {
            if (routerInfo.getPublished() > now + 120000L) {
                long age = routerInfo.getPublished() - this._context.clock().now();
                if (this._log.shouldLog(20)) {
                    this._log.info("Peer " + key.toBase64() + " published their routerInfo in the future?! [" + new Date(routerInfo.getPublished()) + "]", (Throwable)new Exception("Rejecting store"));
                }
                return "Peer " + key.toBase64() + " published " + DataHelper.formatDuration((long)age) + " in the future?!";
            }
            if (this._enforceNetId && routerInfo.getNetworkId() != 2) {
                String rv = "Peer " + key.toBase64() + " is from another network, not accepting it (id=" + routerInfo.getNetworkId() + ", want " + 2 + ")";
                return rv;
            }
            if (upLongEnough && routerInfo.getPublished() < now - 172800000L) {
                long age = this._context.clock().now() - routerInfo.getPublished();
                return "Peer " + key.toBase64() + " published " + DataHelper.formatDuration((long)age) + " ago";
            }
            if (upLongEnough && !routerInfo.isCurrent(5400000L)) {
                Properties props;
                if (routerInfo.getAddresses().size() <= 0) {
                    return "Peer " + key.toBase64() + " published > 90m ago with no addresses";
                }
                RouterAddress ra = routerInfo.getTargetAddress("SSU");
                if (ra != null && (props = ra.getOptions()) != null && props.getProperty("ihost0") != null) {
                    return "Peer " + key.toBase64() + " published > 90m ago with SSU Introducers";
                }
            }
        }
        return null;
    }

    @Override
    public RouterInfo store(Hash key, RouterInfo routerInfo) throws IllegalArgumentException {
        return this.store(key, routerInfo, true);
    }

    public RouterInfo store(Hash key, RouterInfo routerInfo, boolean persist) throws IllegalArgumentException {
        if (!this._initialized) {
            return null;
        }
        RouterInfo rv = (RouterInfo)this._ds.get(key, persist);
        if (rv != null && rv.equals((Object)routerInfo)) {
            return rv;
        }
        String err = this.validate(key, routerInfo);
        if (err != null) {
            throw new IllegalArgumentException("Invalid store attempt - " + err);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("RouterInfo " + key.toBase64() + " is stored with " + routerInfo.getOptions().size() + " options on " + new Date(routerInfo.getPublished()));
        }
        this._context.peerManager().setCapabilities(key, routerInfo.getCapabilities());
        this._ds.put(key, (DataStructure)routerInfo, persist);
        if (rv == null) {
            this._kb.add(key);
        }
        return rv;
    }

    @Override
    public void fail(Hash dbEntry) {
        if (!this._initialized) {
            return;
        }
        boolean isRouterInfo = false;
        DataStructure o = this._ds.get(dbEntry);
        if (o instanceof RouterInfo) {
            isRouterInfo = true;
        }
        if (isRouterInfo) {
            this.lookupBeforeDropping(dbEntry, (RouterInfo)o);
            return;
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Dropping a lease: " + dbEntry);
        }
        if (o == null) {
            this._kb.remove(dbEntry);
            this._context.peerManager().removeCapabilities(dbEntry);
        }
        this._ds.remove(dbEntry, isRouterInfo);
    }

    protected void lookupBeforeDropping(Hash peer, RouterInfo info) {
        this.dropAfterLookupFailed(peer, info);
    }

    protected void dropAfterLookupFailed(Hash peer, RouterInfo info) {
        this._context.peerManager().removeCapabilities(peer);
        boolean removed = this._kb.remove(peer);
        if (removed && this._log.shouldLog(20)) {
            this._log.info("Removed kbucket entry for " + peer);
        }
        this._ds.remove(peer);
    }

    @Override
    public void unpublish(LeaseSet localLeaseSet) {
        if (!this._initialized) {
            return;
        }
        Hash h = localLeaseSet.getDestination().calculateHash();
        DataStructure data = this._ds.remove(h);
        if (data == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Unpublished a lease we don't know...: " + localLeaseSet);
            }
        } else if (this._log.shouldLog(20)) {
            this._log.info("Unpublished a lease: " + h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SearchJob search(Hash key, Job onFindJob, Job onFailedLookupJob, long timeoutMs, boolean isLease) {
        if (!this._initialized) {
            return null;
        }
        boolean isNew = true;
        SearchJob searchJob = null;
        Map<Hash, SearchJob> map = this._activeRequests;
        synchronized (map) {
            searchJob = this._activeRequests.get(key);
            if (searchJob == null) {
                searchJob = new SearchJob(this._context, this, key, onFindJob, onFailedLookupJob, timeoutMs, true, isLease);
                this._activeRequests.put(key, searchJob);
            } else {
                isNew = false;
            }
        }
        if (isNew) {
            if (this._log.shouldLog(10)) {
                this._log.debug("this is the first search for that key, fire off the SearchJob");
            }
            this._context.jobQueue().addJob(searchJob);
        } else {
            if (this._log.shouldLog(20)) {
                this._log.info("Deferring search for " + key.toBase64() + " with " + onFindJob);
            }
            int deferred = searchJob.addDeferred(onFindJob, onFailedLookupJob, timeoutMs, isLease);
            this._context.statManager().addRateData("netDb.lookupLeaseSetDeferred", (long)deferred, searchJob.getExpiration() - this._context.clock().now());
        }
        return searchJob;
    }

    private Set getLeases() {
        if (!this._initialized) {
            return null;
        }
        HashSet<DataStructure> leases = new HashSet<DataStructure>();
        Set keys = this.getDataStore().getKeys();
        for (Hash key : keys) {
            DataStructure o = this.getDataStore().get(key);
            if (!(o instanceof LeaseSet)) continue;
            leases.add(o);
        }
        return leases;
    }

    private Set<RouterInfo> getRouters() {
        if (!this._initialized) {
            return null;
        }
        HashSet<RouterInfo> routers = new HashSet<RouterInfo>();
        Set keys = this.getDataStore().getKeys();
        for (Hash key : keys) {
            DataStructure o = this.getDataStore().get(key);
            if (!(o instanceof RouterInfo)) continue;
            routers.add((RouterInfo)o);
        }
        return routers;
    }

    public int getPeerTimeout(Hash peer) {
        PeerProfile prof = this._context.profileOrganizer().getProfile(peer);
        double responseTime = 10000.0;
        if (prof != null) {
            responseTime = prof.getDbResponseTime().getLifetimeAverageValue();
        }
        if (responseTime < 5000.0) {
            responseTime = 5000.0;
        } else if (responseTime > 10000.0) {
            responseTime = 10000.0;
        }
        return 4 * (int)responseTime;
    }

    public void sendStore(Hash key, DataStructure ds, Job onSuccess, Job onFailure, long sendTimeout, Set toIgnore) {
        if (ds == null || key == null) {
            if (onFailure != null) {
                this._context.jobQueue().addJob(onFailure);
            }
            return;
        }
        this._context.jobQueue().addJob(new StoreJob(this._context, this, key, ds, onSuccess, onFailure, sendTimeout, toIgnore));
    }

    @Override
    public void renderRouterInfoHTML(Writer out, String routerPrefix) throws IOException {
        StringBuilder buf = new StringBuilder(4096);
        buf.append("<h2>Network Database RouterInfo Lookup</h2>\n");
        if (".".equals(routerPrefix)) {
            this.renderRouterInfo(buf, this._context.router().getRouterInfo(), true, true);
        } else {
            boolean notFound = true;
            Set<RouterInfo> routers = this.getRouters();
            for (RouterInfo ri : routers) {
                Hash key = ri.getIdentity().getHash();
                if (!key.toBase64().startsWith(routerPrefix)) continue;
                this.renderRouterInfo(buf, ri, false, true);
                notFound = false;
            }
            if (notFound) {
                buf.append("Router ").append(routerPrefix).append(" not found in network database");
            }
        }
        out.write(buf.toString());
        out.flush();
    }

    @Override
    public void renderStatusHTML(Writer out) throws IOException {
        this.renderStatusHTML(out, true);
    }

    @Override
    public void renderLeaseSetHTML(Writer out) throws IOException {
        StringBuilder buf = new StringBuilder(4096);
        buf.append("<h2>Network Database Contents</h2>\n");
        buf.append("<a href=\"netdb.jsp\">View RouterInfo</a>");
        buf.append("<h3>LeaseSets</h3>\n");
        TreeSet leases = new TreeSet(new LeaseSetComparator());
        leases.addAll(this.getLeases());
        long now = this._context.clock().now();
        for (LeaseSet ls : leases) {
            Destination dest = ls.getDestination();
            Hash key = dest.calculateHash();
            buf.append("<b>LeaseSet: ").append(key.toBase64());
            if (this._context.clientManager().isLocal(dest)) {
                buf.append(" (<a href=\"tunnels.jsp#" + key.toBase64().substring(0, 4) + "\">Local</a> ");
                if (!this._context.clientManager().shouldPublishLeaseSet(key)) {
                    buf.append("Unpublished ");
                }
                buf.append("Destination ");
                TunnelPoolSettings in = this._context.tunnelManager().getInboundSettings(key);
                if (in != null && in.getDestinationNickname() != null) {
                    buf.append(in.getDestinationNickname());
                } else {
                    buf.append(dest.toBase64().substring(0, 6));
                }
            } else {
                buf.append(" (Destination ");
                String host = this._context.namingService().reverseLookup(dest);
                if (host != null) {
                    buf.append(host);
                } else {
                    buf.append(dest.toBase64().substring(0, 6));
                }
            }
            buf.append(")</b><br>\n");
            long exp = ls.getEarliestLeaseDate() - now;
            if (exp > 0L) {
                buf.append("Expires in ").append(DataHelper.formatDuration((long)exp)).append("<br>\n");
            } else {
                buf.append("Expired ").append(DataHelper.formatDuration((long)(0L - exp))).append(" ago<br>\n");
            }
            for (int i = 0; i < ls.getLeaseCount(); ++i) {
                buf.append("Lease ").append(i + 1).append(": Gateway ");
                buf.append(this._context.commSystem().renderPeerHTML(ls.getLease(i).getGateway()));
                buf.append(" Tunnel ").append(ls.getLease(i).getTunnelId().getTunnelId()).append("<br>\n");
            }
            buf.append("<hr>\n");
            out.write(buf.toString());
            buf.setLength(0);
        }
        out.write(buf.toString());
        out.flush();
    }

    @Override
    public void renderStatusHTML(Writer out, boolean full) throws IOException {
        int size = this.getKnownRouters() * 512;
        if (full) {
            size *= 4;
        }
        StringBuilder buf = new StringBuilder(size);
        out.write("<h2>Network Database Contents (<a href=\"netdb.jsp?l=1\">View LeaseSets</a>)</h2>\n");
        if (!this._initialized) {
            buf.append("Not initialized\n");
            out.write(buf.toString());
            out.flush();
            return;
        }
        Hash us = this._context.routerHash();
        out.write("<a name=\"routers\" ></a><h3>Routers (<a href=\"netdb.jsp");
        if (full) {
            out.write("#routers\" >view without");
        } else {
            out.write("?f=1#routers\" >view with");
        }
        out.write(" stats</a>)</h3>\n");
        RouterInfo ourInfo = this._context.router().getRouterInfo();
        this.renderRouterInfo(buf, ourInfo, true, true);
        out.write(buf.toString());
        buf.setLength(0);
        ObjectCounter versions = new ObjectCounter();
        ObjectCounter countries = new ObjectCounter();
        TreeSet<RouterInfo> routers = new TreeSet<RouterInfo>(new RouterInfoComparator());
        routers.addAll(this.getRouters());
        for (RouterInfo ri : routers) {
            String country;
            Hash key = ri.getIdentity().getHash();
            boolean isUs = key.equals((Object)us);
            if (isUs) continue;
            this.renderRouterInfo(buf, ri, false, full);
            out.write(buf.toString());
            buf.setLength(0);
            String routerVersion = ri.getOption("router.version");
            if (routerVersion != null) {
                versions.increment((Object)routerVersion);
            }
            if ((country = this._context.commSystem().getCountry(key)) == null) continue;
            countries.increment((Object)country);
        }
        buf.append("<table border=\"0\" cellspacing=\"30\"><tr><td>");
        ArrayList versionList = new ArrayList(versions.objects());
        if (versionList.size() > 0) {
            Collections.sort(versionList, Collections.reverseOrder());
            buf.append("<table>\n");
            buf.append("<tr><th>Version</th><th>Count</th></tr>\n");
            for (String routerVersion : versionList) {
                int num = versions.count((Object)routerVersion);
                buf.append("<tr><td align=\"center\">").append(DataHelper.stripHTML((String)routerVersion));
                buf.append("</td><td align=\"center\">").append(num).append("</td></tr>\n");
            }
            buf.append("</table>\n");
        }
        buf.append("</td><td>");
        out.write(buf.toString());
        buf.setLength(0);
        ArrayList countryList = new ArrayList(countries.objects());
        if (countryList.size() > 0) {
            Collections.sort(countryList);
            buf.append("<table>\n");
            buf.append("<tr><th align=\"left\">Country</th><th>Count</th></tr>\n");
            for (String country : countryList) {
                int num = countries.count((Object)country);
                buf.append("<tr><td><img height=\"11\" width=\"16\" alt=\"").append(country.toUpperCase()).append("\"");
                buf.append(" src=\"/flags.jsp?c=").append(country).append("\"> ");
                buf.append(this._context.commSystem().getCountryName(country));
                buf.append("</td><td align=\"center\">").append(num).append("</td></tr>\n");
            }
            buf.append("</table>\n");
        }
        buf.append("</td></tr></table>");
        out.write(buf.toString());
        out.flush();
    }

    private void renderRouterInfo(StringBuilder buf, RouterInfo info, boolean isUs, boolean full) {
        String hash = info.getIdentity().getHash().toBase64();
        buf.append("<table><tr><th><a name=\"").append(hash.substring(0, 6)).append("\" ></a>");
        if (isUs) {
            buf.append("<a name=\"our-info\" ></a><b>Our info: ").append(hash).append("</b></th></tr><tr><td>\n");
        } else {
            buf.append("<b>Peer info for:</b> ").append(hash).append("\n");
            if (full) {
                buf.append("[<a href=\"netdb.jsp\" >Back</a>]</th></tr><td>\n");
            } else {
                buf.append("[<a href=\"netdb.jsp?r=").append(hash.substring(0, 6)).append("\" >Full entry</a>]</th></tr><td>\n");
            }
        }
        long age = this._context.clock().now() - info.getPublished();
        if (isUs && this._context.router().isHidden()) {
            buf.append("<b>Hidden, Updated:</b> ").append(DataHelper.formatDuration((long)age)).append(" ago<br>\n");
        } else if (age > 0L) {
            buf.append("<b>Published:</b> ").append(DataHelper.formatDuration((long)age)).append(" ago<br>\n");
        } else {
            buf.append("<b>Published:</b> in ").append(DataHelper.formatDuration((long)(0L - age))).append("???<br>\n");
        }
        buf.append("<b>Address(es):</b> ");
        String country = this._context.commSystem().getCountry(info.getIdentity().getHash());
        if (country != null) {
            buf.append("<img height=\"11\" width=\"16\" alt=\"").append(country.toUpperCase()).append("\"");
            buf.append(" src=\"/flags.jsp?c=").append(country).append("\"> ");
        }
        for (RouterAddress routerAddress : info.getAddresses()) {
            buf.append(DataHelper.stripHTML((String)routerAddress.getTransportStyle())).append(": ");
            for (String string : routerAddress.getOptions().keySet()) {
                String val = routerAddress.getOptions().getProperty(string);
                buf.append('[').append(DataHelper.stripHTML((String)string)).append('=').append(DataHelper.stripHTML((String)val)).append("] ");
            }
        }
        buf.append("</td></tr>\n");
        if (full) {
            buf.append("<tr><td>Stats: <br><code>\n");
            for (String string : info.getOptions().keySet()) {
                String val = info.getOption(string);
                buf.append(DataHelper.stripHTML((String)string)).append(" = ").append(DataHelper.stripHTML((String)val)).append("<br>\n");
            }
            buf.append("</code></td></tr>\n");
        }
        buf.append("</td></tr>\n");
    }

    class RouterInfoComparator
    implements Comparator {
        RouterInfoComparator() {
        }

        public int compare(Object l, Object r) {
            return ((RouterInfo)l).getIdentity().getHash().toBase64().compareTo(((RouterInfo)r).getIdentity().getHash().toBase64());
        }
    }

    class LeaseSetComparator
    implements Comparator {
        LeaseSetComparator() {
        }

        public int compare(Object l, Object r) {
            Destination dl = ((LeaseSet)l).getDestination();
            Destination dr = ((LeaseSet)r).getDestination();
            boolean locall = KademliaNetworkDatabaseFacade.this._context.clientManager().isLocal(dl);
            boolean localr = KademliaNetworkDatabaseFacade.this._context.clientManager().isLocal(dr);
            if (locall && !localr) {
                return -1;
            }
            if (localr && !locall) {
                return 1;
            }
            return dl.calculateHash().toBase64().compareTo(dr.calculateHash().toBase64());
        }
    }

    private class CountLeaseSets
    implements SelectionCollector {
        private int _count;

        private CountLeaseSets() {
        }

        public int size() {
            return this._count;
        }

        public void add(Hash entry) {
            if (KademliaNetworkDatabaseFacade.this._ds == null) {
                return;
            }
            DataStructure o = KademliaNetworkDatabaseFacade.this._ds.get(entry);
            if (o instanceof LeaseSet) {
                ++this._count;
            }
        }
    }

    private class CountRouters
    implements SelectionCollector {
        private int _count;

        private CountRouters() {
        }

        public int size() {
            return this._count;
        }

        public void add(Hash entry) {
            if (KademliaNetworkDatabaseFacade.this._ds == null) {
                return;
            }
            DataStructure o = KademliaNetworkDatabaseFacade.this._ds.get(entry);
            if (o instanceof RouterInfo) {
                ++this._count;
            }
        }
    }
}

