/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.Date;
import java.util.Set;
import net.i2p.data.DataStructure;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.RouterIdentity;
import net.i2p.data.RouterInfo;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.DeliveryStatusMessage;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.util.Log;

public class HandleFloodfillDatabaseStoreMessageJob
extends JobImpl {
    private Log _log;
    private DatabaseStoreMessage _message;
    private RouterIdentity _from;
    private Hash _fromHash;
    private FloodfillNetworkDatabaseFacade _facade;
    private static final int ACK_TIMEOUT = 15000;
    private static final int ACK_PRIORITY = 100;

    public HandleFloodfillDatabaseStoreMessageJob(RouterContext ctx, DatabaseStoreMessage receivedMessage, RouterIdentity from, Hash fromHash, FloodfillNetworkDatabaseFacade facade) {
        super(ctx);
        this._log = ctx.logManager().getLog(this.getClass());
        ctx.statManager().createRateStat("netDb.storeHandled", "How many netDb store messages have we handled?", "NetworkDatabase", new long[]{300000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("netDb.storeLeaseSetHandled", "How many leaseSet store messages have we handled?", "NetworkDatabase", new long[]{300000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("netDb.storeRouterInfoHandled", "How many routerInfo store messages have we handled?", "NetworkDatabase", new long[]{300000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("netDb.storeRecvTime", "How long it takes to handle the local store part of a dbStore?", "NetworkDatabase", new long[]{60000L, 600000L});
        ctx.statManager().createRateStat("netDb.storeFloodNew", "How long it takes to flood out a newly received entry?", "NetworkDatabase", new long[]{60000L, 600000L});
        ctx.statManager().createRateStat("netDb.storeFloodOld", "How often we receive an old entry?", "NetworkDatabase", new long[]{60000L, 600000L});
        this._message = receivedMessage;
        this._from = from;
        this._fromHash = fromHash;
        this._facade = facade;
    }

    public void runJob() {
        boolean wasNew;
        String invalidMessage;
        long recvBegin;
        block32: {
            if (this._log.shouldLog(10)) {
                this._log.debug("Handling database store message");
            }
            recvBegin = System.currentTimeMillis();
            invalidMessage = null;
            wasNew = false;
            RouterInfo prevNetDb = null;
            if (this._message.getValueType() == 1) {
                this.getContext().statManager().addRateData("netDb.storeLeaseSetHandled", 1L, 0L);
                try {
                    if (this.getContext().clientManager().isLocal(this._message.getKey())) {
                        throw new IllegalArgumentException("Peer attempted to store local leaseSet: " + this._message.getKey().toBase64().substring(0, 4));
                    }
                    LeaseSet ls = this._message.getLeaseSet();
                    ls.setReceivedAsPublished(true);
                    LeaseSet match = this.getContext().netDb().store(this._message.getKey(), this._message.getLeaseSet());
                    if (match == null || match.getEarliestLeaseDate() < this._message.getLeaseSet().getEarliestLeaseDate()) {
                        wasNew = true;
                        break block32;
                    }
                    wasNew = false;
                    match.setReceivedAsPublished(true);
                }
                catch (IllegalArgumentException iae) {
                    invalidMessage = iae.getMessage();
                }
            } else if (this._message.getValueType() == 0) {
                this.getContext().statManager().addRateData("netDb.storeRouterInfoHandled", 1L, 0L);
                Hash key = this._message.getKey();
                if (this._log.shouldLog(20)) {
                    this._log.info("Handling dbStore of router " + key + " with publishDate of " + new Date(this._message.getRouterInfo().getPublished()));
                }
                try {
                    if (this.getContext().routerHash().equals((Object)key)) {
                        throw new IllegalArgumentException("Peer attempted to store our RouterInfo");
                    }
                    prevNetDb = this.getContext().netDb().store(key, this._message.getRouterInfo());
                    boolean bl = wasNew = null == prevNetDb || prevNetDb.getPublished() < this._message.getRouterInfo().getPublished();
                    if (wasNew) {
                        if (prevNetDb == null) {
                            if (!this.getContext().shitlist().isShitlistedForever(key) && this.getContext().blocklist().isBlocklisted(key) && this._log.shouldLog(30)) {
                                this._log.warn("Blocklisting new peer " + key);
                            }
                        } else {
                            Set oldAddr = prevNetDb.getAddresses();
                            Set newAddr = this._message.getRouterInfo().getAddresses();
                            if (newAddr != null && !((Object)newAddr).equals(oldAddr) && !this.getContext().shitlist().isShitlistedForever(key) && this.getContext().blocklist().isBlocklisted(key) && this._log.shouldLog(30)) {
                                this._log.warn("New address received, Blocklisting old peer " + key);
                            }
                        }
                    }
                    this.getContext().profileManager().heardAbout(key);
                }
                catch (IllegalArgumentException iae) {
                    invalidMessage = iae.getMessage();
                }
            } else if (this._log.shouldLog(40)) {
                this._log.error("Invalid DatabaseStoreMessage data type - " + this._message.getValueType() + ": " + this._message);
            }
        }
        long recvEnd = System.currentTimeMillis();
        this.getContext().statManager().addRateData("netDb.storeRecvTime", recvEnd - recvBegin, 0L);
        if (this._message.getReplyToken() > 0L) {
            this.sendAck();
        }
        long ackEnd = System.currentTimeMillis();
        if (this._from != null) {
            this._fromHash = this._from.getHash();
        }
        if (this._fromHash != null) {
            if (invalidMessage == null) {
                this.getContext().profileManager().dbStoreReceived(this._fromHash, wasNew);
                this.getContext().statManager().addRateData("netDb.storeHandled", ackEnd - recvEnd, 0L);
                if (FloodfillNetworkDatabaseFacade.floodfillEnabled(this.getContext()) && this._message.getReplyToken() > 0L) {
                    if (wasNew) {
                        long floodBegin = System.currentTimeMillis();
                        if (this._message.getValueType() == 1) {
                            this._facade.flood((DataStructure)this._message.getLeaseSet());
                        } else {
                            this._facade.flood((DataStructure)this._message.getRouterInfo());
                        }
                        long floodEnd = System.currentTimeMillis();
                        this.getContext().statManager().addRateData("netDb.storeFloodNew", floodEnd - floodBegin, 0L);
                    } else {
                        this.getContext().statManager().addRateData("netDb.storeFloodOld", 1L, 0L);
                    }
                }
            } else if (this._log.shouldLog(30)) {
                this._log.warn("Peer " + this._fromHash.toBase64() + " sent bad data: " + invalidMessage);
            }
        } else if (invalidMessage != null && this._log.shouldLog(30)) {
            this._log.warn("Unknown peer sent bad data: " + invalidMessage);
        }
    }

    private void sendAck() {
        DeliveryStatusMessage msg = new DeliveryStatusMessage(this.getContext());
        msg.setMessageId(this._message.getReplyToken());
        msg.setArrival(this.getContext().clock().now());
        TunnelInfo outTunnel = this.selectOutboundTunnel();
        if (outTunnel == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("No outbound tunnel could be found");
            }
            return;
        }
        this.getContext().tunnelDispatcher().dispatchOutbound(msg, outTunnel.getSendTunnelId(0), this._message.getReplyTunnel(), this._message.getReplyGateway());
    }

    private TunnelInfo selectOutboundTunnel() {
        return this.getContext().tunnelManager().selectOutboundTunnel();
    }

    public String getName() {
        return "Handle Database Store Message";
    }

    public void dropped() {
        this.getContext().messageHistory().messageProcessingError(this._message.getUniqueId(), this._message.getClass().getName(), "Dropped due to overload");
    }
}

