/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.Set;
import net.i2p.data.DataStructure;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.RouterInfo;
import net.i2p.router.Job;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.FloodfillVerifyStoreJob;
import net.i2p.router.networkdb.kademlia.StoreJob;

class FloodfillStoreJob
extends StoreJob {
    private FloodfillNetworkDatabaseFacade _facade;

    public FloodfillStoreJob(RouterContext context, FloodfillNetworkDatabaseFacade facade, Hash key, DataStructure data, Job onSuccess, Job onFailure, long timeoutMs) {
        this(context, facade, key, data, onSuccess, onFailure, timeoutMs, null);
    }

    public FloodfillStoreJob(RouterContext context, FloodfillNetworkDatabaseFacade facade, Hash key, DataStructure data, Job onSuccess, Job onFailure, long timeoutMs, Set toSkip) {
        super(context, facade, key, data, onSuccess, onFailure, timeoutMs, toSkip);
        this._facade = facade;
    }

    protected int getParallelization() {
        return 1;
    }

    protected int getRedundancy() {
        return 1;
    }

    protected void succeed() {
        super.succeed();
        if (this._state != null) {
            long published = 0L;
            boolean isRouterInfo = false;
            DataStructure data = this._state.getData();
            if (data instanceof RouterInfo) {
                published = ((RouterInfo)data).getPublished();
                isRouterInfo = true;
            } else if (data instanceof LeaseSet) {
                published = ((LeaseSet)data).getEarliestLeaseDate();
            }
            this.getContext().jobQueue().addJob(new FloodfillVerifyStoreJob(this.getContext(), this._state.getTarget(), published, isRouterInfo, this._facade));
        }
    }

    public String getName() {
        return "Floodfill netDb store";
    }
}

