/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import net.i2p.data.Hash;
import net.i2p.data.RouterInfo;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.KBucketSet;
import net.i2p.router.networkdb.kademlia.PeerSelector;
import net.i2p.router.networkdb.kademlia.SearchJob;
import net.i2p.router.networkdb.kademlia.SelectionCollector;
import net.i2p.router.peermanager.PeerProfile;

class FloodfillPeerSelector
extends PeerSelector {
    public FloodfillPeerSelector(RouterContext ctx) {
        super(ctx);
    }

    public List selectMostReliablePeers(Hash key, int maxNumRouters, Set peersToIgnore, KBucketSet kbuckets) {
        return this.selectNearestExplicitThin(key, maxNumRouters, peersToIgnore, kbuckets, true);
    }

    public List selectNearestExplicitThin(Hash key, int maxNumRouters, Set peersToIgnore, KBucketSet kbuckets) {
        return this.selectNearestExplicitThin(key, maxNumRouters, peersToIgnore, kbuckets, false);
    }

    public List selectNearestExplicitThin(Hash key, int maxNumRouters, Set peersToIgnore, KBucketSet kbuckets, boolean preferConnected) {
        if (peersToIgnore == null) {
            peersToIgnore = new HashSet<Hash>(1);
        }
        peersToIgnore.add(this._context.routerHash());
        FloodfillSelectionCollector matches = new FloodfillSelectionCollector(key, peersToIgnore, maxNumRouters);
        if (kbuckets == null) {
            return new ArrayList();
        }
        kbuckets.getAll(matches);
        List rv = matches.get(maxNumRouters, preferConnected);
        if (this._log.shouldLog(10)) {
            this._log.debug("Searching for " + maxNumRouters + " peers close to " + key + ": " + rv + " (not including " + peersToIgnore + ") [allHashes.size = " + matches.size() + "]", (Throwable)new Exception("Search by"));
        }
        return rv;
    }

    public List selectFloodfillParticipants(KBucketSet kbuckets) {
        if (kbuckets == null) {
            return new ArrayList();
        }
        FloodfillSelectionCollector matches = new FloodfillSelectionCollector(null, null, 0);
        kbuckets.getAll(matches);
        return matches.getFloodfillParticipants();
    }

    private class FloodfillSelectionCollector
    implements SelectionCollector {
        private TreeMap _sorted;
        private List _floodfillMatches;
        private Hash _key;
        private Set _toIgnore;
        private int _matches;
        private int _wanted;
        private static final int EXTRA_MATCHES = 100;

        public FloodfillSelectionCollector(Hash key, Set toIgnore, int wanted) {
            this._key = key;
            this._sorted = new TreeMap();
            this._floodfillMatches = new ArrayList(1);
            this._toIgnore = toIgnore;
            this._matches = 0;
            this._wanted = wanted;
        }

        public List getFloodfillParticipants() {
            return this._floodfillMatches;
        }

        public void add(Hash entry) {
            if (this._toIgnore != null && this._toIgnore.contains(entry)) {
                return;
            }
            if (entry.equals((Object)FloodfillPeerSelector.this._context.routerHash())) {
                return;
            }
            if (FloodfillPeerSelector.this._context.shitlist().isShitlistedForever(entry)) {
                return;
            }
            RouterInfo info = FloodfillPeerSelector.this._context.netDb().lookupRouterInfoLocally(entry);
            if (info != null && FloodfillNetworkDatabaseFacade.isFloodfill(info)) {
                this._floodfillMatches.add(entry);
            } else if (!SearchJob.onlyQueryFloodfillPeers(FloodfillPeerSelector.this._context) && this._wanted + 100 > this._matches && this._key != null) {
                BigInteger diff = PeerSelector.getDistance(this._key, entry);
                this._sorted.put(diff, entry);
            } else {
                return;
            }
            ++this._matches;
        }

        public List get(int howMany) {
            return this.get(howMany, false);
        }

        public List get(int howMany, boolean preferConnected) {
            int i;
            Collections.shuffle(this._floodfillMatches, (Random)FloodfillPeerSelector.this._context.random());
            ArrayList<Object> rv = new ArrayList<Object>(howMany);
            ArrayList<Hash> badff = new ArrayList<Hash>(howMany);
            ArrayList<Hash> unconnectedff = new ArrayList<Hash>(howMany);
            int found = 0;
            long now = FloodfillPeerSelector.this._context.clock().now();
            for (i = 0; found < howMany && i < this._floodfillMatches.size(); ++i) {
                Hash entry = (Hash)this._floodfillMatches.get(i);
                RouterInfo info = FloodfillPeerSelector.this._context.netDb().lookupRouterInfoLocally(entry);
                if (info != null && now - info.getPublished() > 10800000L) {
                    badff.add(entry);
                    if (!FloodfillPeerSelector.this._log.shouldLog(10)) continue;
                    FloodfillPeerSelector.this._log.debug("Skipping, published a while ago: " + entry);
                    continue;
                }
                PeerProfile prof = FloodfillPeerSelector.this._context.profileOrganizer().getProfile(entry);
                if (prof != null && now - prof.getLastSendFailed() < 1800000L) {
                    badff.add(entry);
                    if (!FloodfillPeerSelector.this._log.shouldLog(10)) continue;
                    FloodfillPeerSelector.this._log.debug("Skipping, recent failed send: " + entry);
                    continue;
                }
                if (preferConnected && !FloodfillPeerSelector.this._context.commSystem().isEstablished(entry)) {
                    unconnectedff.add(entry);
                    if (!FloodfillPeerSelector.this._log.shouldLog(10)) continue;
                    FloodfillPeerSelector.this._log.debug("Skipping, unconnected: " + entry);
                    continue;
                }
                rv.add(entry);
                ++found;
            }
            for (i = 0; found < howMany && i < unconnectedff.size(); ++found, ++i) {
                rv.add(unconnectedff.get(i));
            }
            for (i = 0; found < howMany && i < badff.size(); ++found, ++i) {
                rv.add(badff.get(i));
            }
            for (i = rv.size(); i < howMany && this._sorted.size() > 0; ++i) {
                rv.add(this._sorted.remove(this._sorted.firstKey()));
            }
            return rv;
        }

        public int size() {
            return this._matches;
        }
    }
}

