/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataStructure;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.RouterInfo;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.router.Job;
import net.i2p.router.JobImpl;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.DataStore;
import net.i2p.router.networkdb.kademlia.FloodOnlySearchJob;
import net.i2p.router.networkdb.kademlia.FloodSearchJob;
import net.i2p.router.networkdb.kademlia.FloodfillDatabaseLookupMessageHandler;
import net.i2p.router.networkdb.kademlia.FloodfillDatabaseStoreMessageHandler;
import net.i2p.router.networkdb.kademlia.FloodfillMonitorJob;
import net.i2p.router.networkdb.kademlia.FloodfillPeerSelector;
import net.i2p.router.networkdb.kademlia.FloodfillStoreJob;
import net.i2p.router.networkdb.kademlia.KademliaNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.PeerSelector;
import net.i2p.router.networkdb.kademlia.SearchJob;

public class FloodfillNetworkDatabaseFacade
extends KademliaNetworkDatabaseFacade {
    public static final char CAPACITY_FLOODFILL = 'f';
    private final Map _activeFloodQueries = new HashMap();
    private boolean _floodfillEnabled = false;
    private static String _alwaysQuery;
    private static final long PUBLISH_TIMEOUT = 30000L;
    private static final int FLOOD_PRIORITY = 200;
    private static final int FLOOD_TIMEOUT = 30000;
    protected static final int MIN_ACTIVE_PEERS = 5;

    public FloodfillNetworkDatabaseFacade(RouterContext context) {
        super(context);
        _alwaysQuery = this._context.getProperty("netDb.alwaysQuery");
        this._context.statManager().createRateStat("netDb.successTime", "How long a successful search takes", "NetworkDatabase", new long[]{3600000L, 86400000L});
        this._context.statManager().createRateStat("netDb.failedTime", "How long a failed search takes", "NetworkDatabase", new long[]{3600000L, 86400000L});
        this._context.statManager().createRateStat("netDb.failedAttemptedPeers", "How many peers we sent a search to when the search fails", "NetworkDatabase", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("netDb.successPeers", "How many peers are contacted in a successful search", "NetworkDatabase", new long[]{3600000L, 86400000L});
        this._context.statManager().createRateStat("netDb.failedPeers", "How many peers fail to respond to a lookup?", "NetworkDatabase", new long[]{3600000L, 86400000L});
        this._context.statManager().createRateStat("netDb.searchCount", "Overall number of searches sent", "NetworkDatabase", new long[]{300000L, 600000L, 3600000L, 10800000L, 86400000L});
        this._context.statManager().createRateStat("netDb.searchMessageCount", "Overall number of mesages for all searches sent", "NetworkDatabase", new long[]{300000L, 600000L, 3600000L, 10800000L, 86400000L});
        this._context.statManager().createRateStat("netDb.searchReplyValidated", "How many search replies we get that we are able to validate (fetch)", "NetworkDatabase", new long[]{300000L, 600000L, 3600000L, 10800000L, 86400000L});
        this._context.statManager().createRateStat("netDb.searchReplyNotValidated", "How many search replies we get that we are NOT able to validate (fetch)", "NetworkDatabase", new long[]{300000L, 600000L, 3600000L, 10800000L, 86400000L});
        this._context.statManager().createRateStat("netDb.searchReplyValidationSkipped", "How many search replies we get from unreliable peers that we skip?", "NetworkDatabase", new long[]{300000L, 600000L, 3600000L, 10800000L, 86400000L});
        this._context.statManager().createRateStat("netDb.republishQuantity", "How many peers do we need to send a found leaseSet to?", "NetworkDatabase", new long[]{600000L, 3600000L, 10800000L, 86400000L});
    }

    public void startup() {
        super.startup();
        this._context.jobQueue().addJob(new FloodfillMonitorJob(this._context, this));
    }

    protected void createHandlers() {
        this._context.inNetMessagePool().registerHandlerJobBuilder(2, new FloodfillDatabaseLookupMessageHandler(this._context));
        this._context.inNetMessagePool().registerHandlerJobBuilder(1, new FloodfillDatabaseStoreMessageHandler(this._context, this));
    }

    public void publish(RouterInfo localRouterInfo) throws IllegalArgumentException {
        if (localRouterInfo == null) {
            throw new IllegalArgumentException("wtf, null localRouterInfo?");
        }
        if (this._context.router().isHidden()) {
            return;
        }
        super.publish(localRouterInfo);
        this.sendStore(localRouterInfo.getIdentity().calculateHash(), (DataStructure)localRouterInfo, null, null, 30000L, null);
    }

    public void sendStore(Hash key, DataStructure ds, Job onSuccess, Job onFailure, long sendTimeout, Set toIgnore) {
        if (this.floodfillEnabled() && ds instanceof RouterInfo) {
            this.flood(ds);
            if (onSuccess != null) {
                this._context.jobQueue().addJob(onSuccess);
            }
        } else {
            this._context.jobQueue().addJob(new FloodfillStoreJob(this._context, this, key, ds, onSuccess, onFailure, sendTimeout, toIgnore));
        }
    }

    public void flood(DataStructure ds) {
        FloodfillPeerSelector sel = (FloodfillPeerSelector)this.getPeerSelector();
        List peers = sel.selectFloodfillParticipants(this.getKBuckets());
        int flooded = 0;
        for (int i = 0; i < peers.size(); ++i) {
            Hash peer = (Hash)peers.get(i);
            RouterInfo target = this.lookupRouterInfoLocally(peer);
            if (target == null || this._context.shitlist().isShitlisted(peer) || peer.equals((Object)this._context.routerHash())) continue;
            DatabaseStoreMessage msg = new DatabaseStoreMessage(this._context);
            if (ds instanceof LeaseSet) {
                msg.setKey(((LeaseSet)ds).getDestination().calculateHash());
                msg.setLeaseSet((LeaseSet)ds);
            } else {
                msg.setKey(((RouterInfo)ds).getIdentity().calculateHash());
                msg.setRouterInfo((RouterInfo)ds);
            }
            msg.setReplyGateway(null);
            msg.setReplyToken(0L);
            msg.setReplyTunnel(null);
            OutNetMessage m = new OutNetMessage(this._context);
            m.setMessage(msg);
            m.setOnFailedReplyJob(null);
            m.setPriority(200);
            m.setTarget(target);
            m.setExpiration(this._context.clock().now() + 30000L);
            this._context.commSystem().processMessage(m);
            ++flooded;
            if (!this._log.shouldLog(20)) continue;
            this._log.info("Flooding the entry for " + msg.getKey().toBase64() + " to " + peer.toBase64());
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Flooded the to " + flooded + " peers");
        }
    }

    protected PeerSelector createPeerSelector() {
        return new FloodfillPeerSelector(this._context);
    }

    public void setFloodfillEnabled(boolean yes) {
        this._floodfillEnabled = yes;
    }

    public boolean floodfillEnabled() {
        return this._floodfillEnabled;
    }

    public static boolean floodfillEnabled(RouterContext ctx) {
        return ((FloodfillNetworkDatabaseFacade)ctx.netDb()).floodfillEnabled();
    }

    public static boolean isFloodfill(RouterInfo peer) {
        String caps;
        if (peer == null) {
            return false;
        }
        if (_alwaysQuery != null) {
            Hash aq = new Hash();
            try {
                aq.fromBase64(_alwaysQuery);
                if (aq.equals((Object)peer.getIdentity().getHash())) {
                    return true;
                }
            }
            catch (DataFormatException dataFormatException) {
                // empty catch block
            }
        }
        return (caps = peer.getCapabilities()) != null && caps.indexOf(102) != -1;
    }

    public List getKnownRouterData() {
        Set keys;
        ArrayList<DataStructure> rv = new ArrayList<DataStructure>();
        DataStore ds = this.getDataStore();
        if (ds != null && (keys = ds.getKeys()) != null) {
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                DataStructure o = this.getDataStore().get((Hash)iter.next());
                if (!(o instanceof RouterInfo)) continue;
                rv.add(o);
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SearchJob search(Hash key, Job onFindJob, Job onFailedLookupJob, long timeoutMs, boolean isLease) {
        if (key == null) {
            throw new IllegalArgumentException("searchin for nothin, eh?");
        }
        boolean isNew = false;
        FloodSearchJob searchJob = null;
        Map map = this._activeFloodQueries;
        synchronized (map) {
            searchJob = (FloodSearchJob)this._activeFloodQueries.get(key);
            if (searchJob == null) {
                searchJob = new FloodOnlySearchJob(this._context, this, key, onFindJob, onFailedLookupJob, (int)timeoutMs, isLease);
                this._activeFloodQueries.put(key, searchJob);
                isNew = true;
            }
        }
        if (isNew) {
            if (this._log.shouldLog(10)) {
                this._log.debug("this is the first search for that key, fire off the FloodSearchJob");
            }
            this._context.jobQueue().addJob(searchJob);
        } else {
            if (this._log.shouldLog(20)) {
                this._log.info("Deferring flood search for " + key.toBase64() + " with " + onFindJob);
            }
            searchJob.addDeferred(onFindJob, onFailedLookupJob, timeoutMs, isLease);
            this._context.statManager().addRateData("netDb.lookupLeaseSetDeferred", 1L, searchJob.getExpiration() - this._context.clock().now());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void searchFull(Hash key, List onFind, List onFailed, long timeoutMs, boolean isLease) {
        SearchJob job;
        List list;
        Map map = this._activeFloodQueries;
        synchronized (map) {
            this._activeFloodQueries.remove(key);
        }
        Job find = null;
        Job fail = null;
        if (onFind != null) {
            list = onFind;
            synchronized (list) {
                if (onFind.size() > 0) {
                    find = (Job)onFind.remove(0);
                }
            }
        }
        if (onFailed != null) {
            list = onFailed;
            synchronized (list) {
                if (onFailed.size() > 0) {
                    fail = (Job)onFailed.remove(0);
                }
            }
        }
        if ((job = super.search(key, find, fail, timeoutMs, isLease)) != null) {
            if (this._log.shouldLog(20)) {
                this._log.info("Floodfill search timed out for " + key.toBase64() + ", falling back on normal search (#" + job.getJobId() + ") with " + timeoutMs + " remaining");
            }
            long expiration = timeoutMs + this._context.clock().now();
            ArrayList removed = null;
            if (onFind != null) {
                List list2 = onFind;
                synchronized (list2) {
                    removed = new ArrayList(onFind);
                    onFind.clear();
                }
                for (int i = 0; i < removed.size(); ++i) {
                    job.addDeferred((Job)removed.get(i), null, expiration, isLease);
                }
                removed = null;
            }
            if (onFailed != null) {
                List i = onFailed;
                synchronized (i) {
                    removed = new ArrayList(onFailed);
                    onFailed.clear();
                }
                for (int i2 = 0; i2 < removed.size(); ++i2) {
                    job.addDeferred(null, (Job)removed.get(i2), expiration, isLease);
                }
                removed = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void complete(Hash key) {
        Map map = this._activeFloodQueries;
        synchronized (map) {
            this._activeFloodQueries.remove(key);
        }
    }

    public List getFloodfillPeers() {
        FloodfillPeerSelector sel = (FloodfillPeerSelector)this.getPeerSelector();
        return sel.selectFloodfillParticipants(this.getKBuckets());
    }

    protected void lookupBeforeDropping(Hash peer, RouterInfo info) {
        if (info.getNetworkId() == 2 && (this.getKBucketSetSize() < 25 || this._context.router().getUptime() < 600000L || this._context.commSystem().countActivePeers() <= 5)) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Not failing " + peer.toBase64() + " as we are just starting up or have problems");
            }
            return;
        }
        if (this._context.jobQueue().getMaxLag() > 500L) {
            super.lookupBeforeDropping(peer, info);
            return;
        }
        this.search(peer, new DropLookupFoundJob(this._context, peer, info), new DropLookupFailedJob(this._context, peer, info), 10000L, false);
    }

    private class DropLookupFoundJob
    extends JobImpl {
        private Hash _peer;
        private RouterInfo _info;

        public DropLookupFoundJob(RouterContext ctx, Hash peer, RouterInfo info) {
            super(ctx);
            this._peer = peer;
            this._info = info;
        }

        public String getName() {
            return "Lookup on failure of netDb peer matched";
        }

        public void runJob() {
            RouterInfo updated = FloodfillNetworkDatabaseFacade.this.lookupRouterInfoLocally(this._peer);
            if (updated == null || updated.getPublished() <= this._info.getPublished()) {
                FloodfillNetworkDatabaseFacade.this.dropAfterLookupFailed(this._peer, this._info);
            }
        }
    }

    private class DropLookupFailedJob
    extends JobImpl {
        private Hash _peer;
        private RouterInfo _info;

        public DropLookupFailedJob(RouterContext ctx, Hash peer, RouterInfo info) {
            super(ctx);
            this._peer = peer;
            this._info = info;
        }

        public String getName() {
            return "Lookup on failure of netDb peer timed out";
        }

        public void runJob() {
            FloodfillNetworkDatabaseFacade.this.dropAfterLookupFailed(this._peer, this._info);
        }
    }
}

