/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.i2p.data.Hash;
import net.i2p.data.i2np.DatabaseLookupMessage;
import net.i2p.router.Job;
import net.i2p.router.MessageSelector;
import net.i2p.router.OutNetMessage;
import net.i2p.router.ReplyJob;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.networkdb.kademlia.FloodOnlyLookupMatchJob;
import net.i2p.router.networkdb.kademlia.FloodOnlyLookupSelector;
import net.i2p.router.networkdb.kademlia.FloodOnlyLookupTimeoutJob;
import net.i2p.router.networkdb.kademlia.FloodSearchJob;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.util.Log;

class FloodOnlySearchJob
extends FloodSearchJob {
    protected Log _log;
    private FloodfillNetworkDatabaseFacade _facade;
    protected Hash _key;
    private final List _onFind;
    private final List _onFailed;
    private long _expiration;
    protected int _timeoutMs;
    private long _origExpiration;
    private boolean _isLease;
    protected volatile int _lookupsRemaining;
    private volatile boolean _dead;
    private long _created;
    private boolean _shouldProcessDSRM;
    private final HashSet _unheardFrom;
    protected final List _out;
    protected MessageSelector _replySelector;
    protected ReplyJob _onReply;
    protected Job _onTimeout;
    private static final int CONCURRENT_SEARCHES = 2;

    public FloodOnlySearchJob(RouterContext ctx, FloodfillNetworkDatabaseFacade facade, Hash key, Job onFind, Job onFailed, int timeoutMs, boolean isLease) {
        super(ctx, facade, key, onFind, onFailed, timeoutMs, isLease);
        this._log = ctx.logManager().getLog(FloodOnlySearchJob.class);
        this._facade = facade;
        this._key = key;
        this._onFind = new ArrayList();
        this._onFind.add(onFind);
        this._onFailed = new ArrayList();
        this._onFailed.add(onFailed);
        this._timeoutMs = Math.min(timeoutMs, 10000);
        this._expiration = (long)this._timeoutMs + ctx.clock().now();
        this._origExpiration = (long)this._timeoutMs + ctx.clock().now();
        this._isLease = isLease;
        this._lookupsRemaining = 0;
        this._dead = false;
        this._out = Collections.synchronizedList(new ArrayList(2));
        this._unheardFrom = new HashSet(2);
        this._replySelector = new FloodOnlyLookupSelector(this.getContext(), this);
        this._onReply = new FloodOnlyLookupMatchJob(this.getContext(), this);
        this._onTimeout = new FloodOnlyLookupTimeoutJob(this.getContext(), this);
        this._created = System.currentTimeMillis();
        this._shouldProcessDSRM = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDeferred(Job onFind, Job onFailed, long timeoutMs, boolean isLease) {
        if (this._dead) {
            this.getContext().jobQueue().addJob(onFailed);
        } else {
            List list;
            if (onFind != null) {
                list = this._onFind;
                synchronized (list) {
                    this._onFind.add(onFind);
                }
            }
            if (onFailed != null) {
                list = this._onFailed;
                synchronized (list) {
                    this._onFailed.add(onFailed);
                }
            }
        }
    }

    public long getExpiration() {
        return this._expiration;
    }

    public long getCreated() {
        return this._created;
    }

    public boolean shouldProcessDSRM() {
        return this._shouldProcessDSRM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runJob() {
        ArrayList<Object> floodfillPeers = this._facade.getFloodfillPeers();
        if (floodfillPeers.size() <= 3) {
            this._shouldProcessDSRM = true;
        }
        if (floodfillPeers.size() <= 0) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Running netDb searches against the floodfill peers, but we don't know any");
            }
            if ((floodfillPeers = new ArrayList<Hash>(this._facade.getAllRouters())).size() <= 0) {
                if (this._log.shouldLog(40)) {
                    this._log.error("We don't know any peers at all");
                }
                this.failed();
                return;
            }
        }
        OutNetMessage out = this.getContext().messageRegistry().registerPending(this._replySelector, this._onReply, this._onTimeout, this._timeoutMs);
        List list = this._out;
        synchronized (list) {
            this._out.add(out);
        }
        if (floodfillPeers.size() > 2) {
            Collections.shuffle(floodfillPeers, (Random)this.getContext().random());
            ArrayList<Hash> ffp = new ArrayList<Hash>(floodfillPeers.size());
            int failcount = 0;
            long before = this.getContext().clock().now() - 1800000L;
            for (int i = 0; i < floodfillPeers.size(); ++i) {
                Hash peer = (Hash)floodfillPeers.get(i);
                PeerProfile profile = this.getContext().profileOrganizer().getProfile(peer);
                if (profile == null || profile.getLastHeardFrom() < before || profile.getIsFailing() || this.getContext().shitlist().isShitlisted(peer) || this.getContext().commSystem().wasUnreachable(peer)) {
                    ++failcount;
                    ffp.add(peer);
                    continue;
                }
                ffp.add(0, peer);
            }
            if (floodfillPeers.size() - failcount <= 2) {
                this._shouldProcessDSRM = true;
            }
            if (this._log.shouldLog(20) && failcount > 0) {
                this._log.info(this.getJobId() + ": " + failcount + " of " + floodfillPeers.size() + " floodfills are not heard from, unprofiled, failing, unreachable or shitlisted");
            }
            floodfillPeers = ffp;
        } else {
            this._shouldProcessDSRM = true;
        }
        int count = 0;
        for (int i = 0; this._lookupsRemaining < 2 && i < floodfillPeers.size(); ++i) {
            Hash peer = (Hash)floodfillPeers.get(i);
            if (peer.equals((Object)this.getContext().routerHash())) continue;
            DatabaseLookupMessage dlm = new DatabaseLookupMessage(this.getContext(), true);
            TunnelInfo replyTunnel = this.getContext().tunnelManager().selectInboundTunnel();
            TunnelInfo outTunnel = this.getContext().tunnelManager().selectOutboundTunnel();
            if (replyTunnel == null || outTunnel == null) {
                this.failed();
                return;
            }
            HashSet hashSet = this._unheardFrom;
            synchronized (hashSet) {
                this._unheardFrom.add(peer);
            }
            dlm.setFrom(replyTunnel.getPeer(0));
            dlm.setMessageExpiration(this.getContext().clock().now() + 10000L);
            dlm.setReplyTunnel(replyTunnel.getReceiveTunnelId(0));
            dlm.setSearchKey(this._key);
            if (this._log.shouldLog(20)) {
                this._log.info(this.getJobId() + ": Floodfill search for " + this._key.toBase64() + " to " + peer.toBase64());
            }
            this.getContext().tunnelDispatcher().dispatchOutbound(dlm, outTunnel.getSendTunnelId(0), peer);
            ++count;
            ++this._lookupsRemaining;
        }
        if (count <= 0) {
            if (this._log.shouldLog(20)) {
                this._log.info(this.getJobId() + ": Floodfill search for " + this._key.toBase64() + " had no peers to send to");
            }
            this.failed();
        }
    }

    public String getName() {
        return "NetDb flood search (phase 1)";
    }

    Hash getKey() {
        return this._key;
    }

    void decrementRemaining() {
        if (this._lookupsRemaining > 0) {
            --this._lookupsRemaining;
        }
    }

    int getLookupsRemaining() {
        return this._lookupsRemaining;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decrementRemaining(Hash peer) {
        this.decrementRemaining();
        HashSet hashSet = this._unheardFrom;
        synchronized (hashSet) {
            this._unheardFrom.remove(peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void failed() {
        FloodOnlySearchJob floodOnlySearchJob = this;
        synchronized (floodOnlySearchJob) {
            if (this._dead) {
                return;
            }
            this._dead = true;
        }
        ArrayList outBuf = null;
        List list = this._out;
        synchronized (list) {
            outBuf = new ArrayList(this._out);
        }
        for (int i = 0; i < outBuf.size(); ++i) {
            OutNetMessage out = (OutNetMessage)outBuf.get(i);
            this.getContext().messageRegistry().unregisterPending(out);
        }
        int timeRemaining = (int)(this._origExpiration - this.getContext().clock().now());
        if (this._log.shouldLog(20)) {
            this._log.info(this.getJobId() + ": Floodfill search for " + this._key.toBase64() + " failed with " + timeRemaining + " remaining after " + (System.currentTimeMillis() - this._created));
        }
        Collection collection = this._unheardFrom;
        synchronized (collection) {
            Iterator iter = this._unheardFrom.iterator();
            while (iter.hasNext()) {
                this.getContext().profileManager().dbLookupFailed((Hash)iter.next());
            }
        }
        this._facade.complete(this._key);
        this.getContext().statManager().addRateData("netDb.failedTime", System.currentTimeMillis() - this._created, System.currentTimeMillis() - this._created);
        collection = this._onFailed;
        synchronized (collection) {
            for (int i = 0; i < this._onFailed.size(); ++i) {
                Job j = (Job)this._onFailed.remove(0);
                this.getContext().jobQueue().addJob(j);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void success() {
        Object object = this;
        synchronized (object) {
            if (this._dead) {
                return;
            }
            this._dead = true;
        }
        if (this._log.shouldLog(20)) {
            this._log.info(this.getJobId() + ": Floodfill search for " + this._key.toBase64() + " successful");
        }
        object = this._unheardFrom;
        synchronized (object) {
            if (this._unheardFrom.size() == 1) {
                Hash peer = (Hash)this._unheardFrom.iterator().next();
                this.getContext().profileManager().dbLookupSuccessful(peer, System.currentTimeMillis() - this._created);
            }
        }
        this._facade.complete(this._key);
        this.getContext().statManager().addRateData("netDb.successTime", System.currentTimeMillis() - this._created, System.currentTimeMillis() - this._created);
        object = this._onFind;
        synchronized (object) {
            while (this._onFind.size() > 0) {
                this.getContext().jobQueue().addJob((Job)this._onFind.remove(0));
            }
        }
    }
}

