/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import net.i2p.data.i2np.DatabaseSearchReplyMessage;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.JobImpl;
import net.i2p.router.ReplyJob;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodOnlySearchJob;
import net.i2p.router.networkdb.kademlia.SingleLookupJob;
import net.i2p.util.Log;

class FloodOnlyLookupMatchJob
extends JobImpl
implements ReplyJob {
    private Log _log;
    private FloodOnlySearchJob _search;
    private DatabaseSearchReplyMessage _dsrm;

    public FloodOnlyLookupMatchJob(RouterContext ctx, FloodOnlySearchJob job) {
        super(ctx);
        this._log = ctx.logManager().getLog(this.getClass());
        this._search = job;
        this._dsrm = null;
    }

    public void runJob() {
        if (this.getContext().netDb().lookupLeaseSetLocally(this._search.getKey()) != null || this.getContext().netDb().lookupRouterInfoLocally(this._search.getKey()) != null) {
            if (this._log.shouldLog(20)) {
                this._log.info(this._search.getJobId() + ": search match and found locally");
            }
            this._search.success();
        } else {
            int remaining = this._search.getLookupsRemaining();
            if (this._log.shouldLog(20)) {
                this._log.info(this._search.getJobId() + ": got a DatabaseSearchReply when we were looking for " + this._search.getKey().toBase64() + ", with " + remaining + " outstanding searches");
            }
            if (this._search.shouldProcessDSRM() && this._dsrm != null) {
                if (this._log.shouldLog(20)) {
                    this._log.info(this._search.getJobId() + ": Processing DatabaseSearchReply");
                }
                this.getContext().jobQueue().addJob(new SingleLookupJob(this.getContext(), this._dsrm));
            }
            this._search.failed();
        }
    }

    public String getName() {
        return "NetDb flood search (phase 1) match";
    }

    public void setMessage(I2NPMessage message) {
        block5: {
            if (message instanceof DatabaseSearchReplyMessage) {
                this._dsrm = (DatabaseSearchReplyMessage)message;
                this._search.failed();
                return;
            }
            try {
                DatabaseStoreMessage dsm = (DatabaseStoreMessage)message;
                if (dsm.getValueType() == 1) {
                    this.getContext().netDb().store(dsm.getKey(), dsm.getLeaseSet());
                } else {
                    this.getContext().netDb().store(dsm.getKey(), dsm.getRouterInfo());
                }
            }
            catch (IllegalArgumentException iae) {
                if (!this._log.shouldLog(30)) break block5;
                this._log.warn(this._search.getJobId() + ": Received an invalid store reply", (Throwable)iae);
            }
        }
    }
}

