/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.Collections;
import java.util.Set;
import net.i2p.data.Hash;
import net.i2p.data.RouterInfo;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.KademliaNetworkDatabaseFacade;
import net.i2p.util.Log;

class ExpireRoutersJob
extends JobImpl {
    private Log _log;
    private KademliaNetworkDatabaseFacade _facade;
    private static final long RERUN_DELAY_MS = 120000L;

    public ExpireRoutersJob(RouterContext ctx, KademliaNetworkDatabaseFacade facade) {
        super(ctx);
        this._log = ctx.logManager().getLog(ExpireRoutersJob.class);
        this._facade = facade;
    }

    public String getName() {
        return "Expire Routers Job";
    }

    public void runJob() {
        Set toExpire = this.selectKeysToExpire();
        this._log.info("Routers to expire (drop and try to refetch): " + toExpire);
        for (Hash key : toExpire) {
            this._facade.fail(key);
        }
        this._facade.queueForExploration(toExpire);
        this.requeue(120000L);
    }

    private Set selectKeysToExpire() {
        for (Hash key : this._facade.getAllRouters()) {
            if (this.getContext().commSystem().isEstablished(key)) continue;
            RouterInfo routerInfo = this._facade.lookupRouterInfoLocally(key);
        }
        return Collections.EMPTY_SET;
    }
}

