/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.message;

import java.util.HashSet;
import java.util.Set;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.Payload;
import net.i2p.data.TunnelId;
import net.i2p.router.ClientMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.message.PayloadGarlicConfig;

class OutboundClientMessageStatus {
    private RouterContext _context;
    private ClientMessage _msg;
    private PayloadGarlicConfig _clove;
    private LeaseSet _leaseSet;
    private final Set _sent;
    private int _numLookups;
    private boolean _success;
    private boolean _failure;
    private long _start;
    private int _previousSent;

    public OutboundClientMessageStatus(RouterContext ctx, ClientMessage msg) {
        this._context = ctx;
        this._msg = msg;
        this._clove = null;
        this._leaseSet = null;
        this._sent = new HashSet(4);
        this._success = false;
        this._failure = false;
        this._numLookups = 0;
        this._previousSent = 0;
        this._start = ctx.clock().now();
    }

    public Payload getPayload() {
        return this._msg.getPayload();
    }

    public PayloadGarlicConfig getClove() {
        return this._clove;
    }

    public void setClove(PayloadGarlicConfig clove) {
        this._clove = clove;
    }

    public ClientMessage getMessage() {
        return this._msg;
    }

    public long getStart() {
        return this._start;
    }

    public int getNumLookups() {
        return this._numLookups;
    }

    public void incrementLookups() {
        ++this._numLookups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAlreadySent() {
        Set set = this._sent;
        synchronized (set) {
            this._previousSent += this._sent.size();
            this._sent.clear();
        }
    }

    public Destination getFrom() {
        return this._msg.getFromDestination();
    }

    public Destination getTo() {
        return this._msg.getDestination();
    }

    public LeaseSet getLeaseSet() {
        return this._leaseSet;
    }

    public void setLeaseSet(LeaseSet ls) {
        this._leaseSet = ls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean alreadySent(Hash gateway, TunnelId tunnelId) {
        Tunnel t = new Tunnel(gateway, tunnelId);
        Set set = this._sent;
        synchronized (set) {
            return this._sent.contains(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sent(Hash gateway, TunnelId tunnelId) {
        Tunnel t = new Tunnel(gateway, tunnelId);
        Set set = this._sent;
        synchronized (set) {
            this._sent.add(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumSent() {
        Set set = this._sent;
        synchronized (set) {
            return this._sent.size() + this._previousSent;
        }
    }

    public boolean getFailure() {
        return this._failure;
    }

    public boolean failed() {
        boolean already = this._failure;
        this._failure = true;
        return already;
    }

    public boolean getSuccess() {
        return this._success;
    }

    public boolean success() {
        boolean already = this._success;
        this._success = true;
        return already;
    }

    private class Tunnel {
        private Hash _gateway;
        private TunnelId _tunnel;

        public Tunnel(Hash tunnelGateway, TunnelId tunnel) {
            this._gateway = tunnelGateway;
            this._tunnel = tunnel;
        }

        public Hash getGateway() {
            return this._gateway;
        }

        public TunnelId getTunnel() {
            return this._tunnel;
        }

        public int hashCode() {
            int rv = 0;
            if (this._gateway != null) {
                rv += this._gateway.hashCode();
            }
            if (this._tunnel != null) {
                rv = (int)((long)rv + 7L * this._tunnel.getTunnelId());
            }
            return rv;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o.getClass() != Tunnel.class) {
                return false;
            }
            Tunnel t = (Tunnel)o;
            return this.getTunnel() == t.getTunnel() && this.getGateway().equals((Object)t.getGateway());
        }
    }
}

