/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.message;

import net.i2p.data.Hash;
import net.i2p.data.RouterIdentity;
import net.i2p.data.i2np.DeliveryInstructions;
import net.i2p.data.i2np.GarlicMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.TunnelGatewayMessage;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.message.GarlicMessageReceiver;
import net.i2p.router.message.SendMessageDirectJob;
import net.i2p.util.Log;

public class HandleGarlicMessageJob
extends JobImpl
implements GarlicMessageReceiver.CloveReceiver {
    private Log _log;
    private GarlicMessage _message;
    private static final int FORWARD_PRIORITY = 50;

    public HandleGarlicMessageJob(RouterContext context, GarlicMessage msg, RouterIdentity from, Hash fromHash) {
        super(context);
        this._log = context.logManager().getLog(HandleGarlicMessageJob.class);
        this.getContext().statManager().createRateStat("crypto.garlic.decryptFail", "How often garlic messages are undecryptable", "Encryption", new long[]{300000L, 3600000L, 86400000L});
        if (this._log.shouldLog(10)) {
            this._log.debug("New handle garlicMessageJob called w/ message from [" + from + "]", (Throwable)new Exception("Debug"));
        }
        this._message = msg;
    }

    public String getName() {
        return "Handle Inbound Garlic Message";
    }

    public void runJob() {
        GarlicMessageReceiver recv = new GarlicMessageReceiver(this.getContext(), this);
        recv.receive(this._message);
    }

    public void handleClove(DeliveryInstructions instructions, I2NPMessage data) {
        switch (instructions.getDeliveryMode()) {
            case 0: {
                if (this._log.shouldLog(10)) {
                    this._log.debug("local delivery instructions for clove: " + data);
                }
                this.getContext().inNetMessagePool().add(data, null, null);
                return;
            }
            case 1: {
                if (this._log.shouldLog(40)) {
                    this._log.error("this message didn't come down a tunnel, not forwarding to a destination: " + (Object)((Object)instructions) + " - " + data);
                }
                return;
            }
            case 2: {
                if (this.getContext().routerHash().equals((Object)instructions.getRouter())) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("router delivery instructions targetting us");
                    }
                    this.getContext().inNetMessagePool().add(data, null, null);
                } else {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("router delivery instructions targetting " + instructions.getRouter().toBase64().substring(0, 4));
                    }
                    SendMessageDirectJob j = new SendMessageDirectJob(this.getContext(), data, instructions.getRouter(), 10000, 100);
                    j.runJob();
                }
                return;
            }
            case 3: {
                TunnelGatewayMessage gw = new TunnelGatewayMessage(this.getContext());
                gw.setMessage(data);
                gw.setTunnelId(instructions.getTunnelId());
                gw.setMessageExpiration(data.getMessageExpiration());
                SendMessageDirectJob job = new SendMessageDirectJob(this.getContext(), gw, instructions.getRouter(), 10000, 100);
                job.runJob();
                return;
            }
        }
        this._log.error("Unknown instruction " + instructions.getDeliveryMode() + ": " + (Object)((Object)instructions));
    }

    public void dropped() {
        this.getContext().messageHistory().messageProcessingError(this._message.getUniqueId(), this._message.getClass().getName(), "Dropped due to overload");
    }
}

