/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.message;

import java.util.Date;
import net.i2p.crypto.SessionKeyManager;
import net.i2p.data.Certificate;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.PrivateKey;
import net.i2p.data.i2np.GarlicClove;
import net.i2p.data.i2np.GarlicMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.message.CloveSet;
import net.i2p.util.Log;

public class GarlicMessageParser {
    private Log _log;
    private RouterContext _context;

    public GarlicMessageParser(RouterContext context) {
        this._context = context;
        this._log = this._context.logManager().getLog(GarlicMessageParser.class);
    }

    public CloveSet getGarlicCloves(GarlicMessage message, PrivateKey encryptionKey, SessionKeyManager skm) {
        byte[] decrData;
        byte[] encData;
        block8: {
            encData = message.getData();
            decrData = null;
            try {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Decrypting with private key " + encryptionKey);
                }
                decrData = this._context.elGamalAESEngine().decrypt(encData, encryptionKey, skm);
            }
            catch (DataFormatException dfe) {
                if (!this._log.shouldLog(30)) break block8;
                this._log.warn("Error decrypting", (Throwable)dfe);
            }
        }
        if (decrData == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Decryption of garlic message failed (data = " + encData + ")", (Throwable)new Exception("Decrypt fail"));
            }
            return null;
        }
        try {
            return this.readCloveSet(decrData);
        }
        catch (DataFormatException dfe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Unable to read cloveSet", (Throwable)dfe);
            }
            return null;
        }
    }

    private CloveSet readCloveSet(byte[] data) throws DataFormatException {
        int offset = 0;
        CloveSet set = new CloveSet();
        int numCloves = (int)DataHelper.fromLong((byte[])data, (int)offset, (int)1);
        ++offset;
        if (this._log.shouldLog(10)) {
            this._log.debug("# cloves to read: " + numCloves);
        }
        for (int i = 0; i < numCloves; ++i) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Reading clove " + i);
            }
            GarlicClove clove = new GarlicClove(this._context);
            offset += clove.readBytes(data, offset);
            set.addClove(clove);
            if (!this._log.shouldLog(30)) continue;
            this._log.debug("After reading clove " + i);
        }
        Certificate cert = new Certificate();
        offset += cert.readBytes(data, offset);
        long msgId = DataHelper.fromLong((byte[])data, (int)offset, (int)4);
        Date expiration = DataHelper.fromDate((byte[])data, (int)(offset += 4));
        offset += 8;
        set.setCertificate(cert);
        set.setMessageId(msgId);
        set.setExpiration(expiration.getTime());
        return set;
    }
}

