/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import net.i2p.crypto.SessionKeyManager;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.PublicKey;
import net.i2p.data.SessionKey;
import net.i2p.data.SessionTag;
import net.i2p.data.i2np.GarlicClove;
import net.i2p.data.i2np.GarlicMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.message.GarlicConfig;
import net.i2p.router.message.PayloadGarlicConfig;
import net.i2p.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GarlicMessageBuilder {
    private static final int DEFAULT_TAGS = 40;
    private static final int LOW_THRESHOLD = 30;

    public static int estimateAvailableTags(RouterContext ctx, PublicKey key, Hash local) {
        SessionKeyManager skm = ctx.clientManager().getClientSessionKeyManager(local);
        if (skm == null) {
            return 0;
        }
        SessionKey curKey = skm.getCurrentKey(key);
        if (curKey == null) {
            return 0;
        }
        return skm.getAvailableTags(key, curKey);
    }

    private static GarlicMessage buildMessage(RouterContext ctx, GarlicConfig config) {
        Log log = ctx.logManager().getLog(GarlicMessageBuilder.class);
        log.error("buildMessage 2 args, using router SKM", (Throwable)new Exception("who did it"));
        return GarlicMessageBuilder.buildMessage(ctx, config, new SessionKey(), new HashSet<SessionTag>(), ctx.sessionKeyManager());
    }

    public static GarlicMessage buildMessage(RouterContext ctx, GarlicConfig config, SessionKey wrappedKey, Set<SessionTag> wrappedTags, SessionKeyManager skm) {
        return GarlicMessageBuilder.buildMessage(ctx, config, wrappedKey, wrappedTags, 40, false, skm);
    }

    private static GarlicMessage buildMessage(RouterContext ctx, GarlicConfig config, SessionKey wrappedKey, Set<SessionTag> wrappedTags, int numTagsToDeliver, boolean forceElGamal, SessionKeyManager skm) {
        Log log = ctx.logManager().getLog(GarlicMessageBuilder.class);
        PublicKey key = config.getRecipientPublicKey();
        if (key == null) {
            if (config.getRecipient() == null) {
                throw new IllegalArgumentException("Null recipient specified");
            }
            if (config.getRecipient().getIdentity() == null) {
                throw new IllegalArgumentException("Null recipient.identity specified");
            }
            if (config.getRecipient().getIdentity().getPublicKey() == null) {
                throw new IllegalArgumentException("Null recipient.identity.publicKey specified");
            }
            key = config.getRecipient().getIdentity().getPublicKey();
        }
        if (log.shouldLog(20)) {
            log.info("Encrypted with public key " + key + " to expire on " + new Date(config.getExpiration()));
        }
        SessionKey curKey = skm.getCurrentKey(key);
        SessionTag curTag = null;
        if (curKey == null) {
            curKey = skm.createSession(key);
        }
        if (!forceElGamal) {
            curTag = skm.consumeNextAvailableTag(key, curKey);
            int availTags = skm.getAvailableTags(key, curKey);
            if (log.shouldLog(10)) {
                log.debug("Available tags for encryption to " + key + ": " + availTags);
            }
            if (availTags < 30) {
                for (int i = 0; i < numTagsToDeliver; ++i) {
                    wrappedTags.add(new SessionTag(true));
                }
                if (log.shouldLog(20)) {
                    log.info("Too few are available (" + availTags + "), so we're including more");
                }
            } else if (skm.getAvailableTimeLeft(key, curKey) < 60000L) {
                for (int i = 0; i < numTagsToDeliver; ++i) {
                    wrappedTags.add(new SessionTag(true));
                }
                if (log.shouldLog(20)) {
                    log.info("Tags are almost expired, adding new ones");
                }
            }
        }
        wrappedKey.setData(curKey.getData());
        return GarlicMessageBuilder.buildMessage(ctx, config, wrappedKey, wrappedTags, key, curKey, curTag);
    }

    public static GarlicMessage buildMessage(RouterContext ctx, GarlicConfig config, SessionKey wrappedKey, Set<SessionTag> wrappedTags, PublicKey target, SessionKey encryptKey, SessionTag encryptTag) {
        Log log = ctx.logManager().getLog(GarlicMessageBuilder.class);
        if (config == null) {
            throw new IllegalArgumentException("Null config specified");
        }
        GarlicMessage msg = new GarlicMessage(ctx);
        GarlicMessageBuilder.noteWrap(ctx, msg, config);
        byte[] cloveSet = GarlicMessageBuilder.buildCloveSet(ctx, config);
        byte[] encData = ctx.elGamalAESEngine().encrypt(cloveSet, target, encryptKey, wrappedTags, encryptTag, 128L);
        msg.setData(encData);
        msg.setMessageExpiration(config.getExpiration());
        long timeFromNow = config.getExpiration() - ctx.clock().now();
        if (timeFromNow < 1000L) {
            if (log.shouldLog(10)) {
                log.debug("Building a message expiring in " + timeFromNow + "ms: " + config, (Throwable)new Exception("created by"));
            }
            return null;
        }
        if (log.shouldLog(10)) {
            log.debug("CloveSet size for message " + msg.getUniqueId() + " is " + cloveSet.length + " and encrypted message data is " + encData.length);
        }
        return msg;
    }

    private static void noteWrap(RouterContext ctx, GarlicMessage wrapper, GarlicConfig contained) {
        for (int i = 0; i < contained.getCloveCount(); ++i) {
            GarlicConfig config = contained.getClove(i);
            if (!(config instanceof PayloadGarlicConfig)) continue;
            I2NPMessage msg = ((PayloadGarlicConfig)config).getPayload();
            String bodyType = msg.getClass().getName();
            ctx.messageHistory().wrap(bodyType, msg.getUniqueId(), GarlicMessage.class.getName(), wrapper.getUniqueId());
        }
    }

    private static byte[] buildCloveSet(RouterContext ctx, GarlicConfig config) {
        ByteArrayOutputStream baos = null;
        Log log = ctx.logManager().getLog(GarlicMessageBuilder.class);
        try {
            if (config instanceof PayloadGarlicConfig) {
                byte[] clove = GarlicMessageBuilder.buildClove(ctx, (PayloadGarlicConfig)config);
                baos = new ByteArrayOutputStream(clove.length + 16);
                DataHelper.writeLong((OutputStream)baos, (int)1, (long)1L);
                baos.write(clove);
            } else {
                int i;
                byte[][] cloves = new byte[config.getCloveCount()][];
                for (int i2 = 0; i2 < config.getCloveCount(); ++i2) {
                    GarlicConfig c = config.getClove(i2);
                    if (c instanceof PayloadGarlicConfig) {
                        log.debug("Subclove IS a payload garlic clove");
                        cloves[i2] = GarlicMessageBuilder.buildClove(ctx, (PayloadGarlicConfig)c);
                    } else {
                        log.debug("Subclove IS NOT a payload garlic clove");
                        cloves[i2] = GarlicMessageBuilder.buildClove(ctx, c);
                    }
                    if (cloves[i2] != null) continue;
                    throw new DataFormatException("Unable to build clove");
                }
                int len = 1;
                for (i = 0; i < cloves.length; ++i) {
                    len += cloves[i].length;
                }
                baos = new ByteArrayOutputStream(len + 16);
                DataHelper.writeLong((OutputStream)baos, (int)1, (long)cloves.length);
                for (i = 0; i < cloves.length; ++i) {
                    baos.write(cloves[i]);
                }
            }
            if (baos == null) {
                new ByteArrayOutputStream(16);
            }
            config.getCertificate().writeBytes((OutputStream)baos);
            DataHelper.writeLong((OutputStream)baos, (int)4, (long)config.getId());
            DataHelper.writeLong((OutputStream)baos, (int)8, (long)config.getExpiration());
        }
        catch (IOException ioe) {
            log.error("Error building the clove set", (Throwable)ioe);
        }
        catch (DataFormatException dfe) {
            log.error("Error building the clove set", (Throwable)dfe);
        }
        return baos.toByteArray();
    }

    private static byte[] buildClove(RouterContext ctx, PayloadGarlicConfig config) throws DataFormatException, IOException {
        GarlicClove clove = new GarlicClove(ctx);
        clove.setData(config.getPayload());
        return GarlicMessageBuilder.buildCommonClove(ctx, clove, config);
    }

    private static byte[] buildClove(RouterContext ctx, GarlicConfig config) throws DataFormatException, IOException {
        GarlicClove clove = new GarlicClove(ctx);
        GarlicMessage msg = GarlicMessageBuilder.buildMessage(ctx, config);
        if (msg == null) {
            throw new DataFormatException("Unable to build message from clove config");
        }
        clove.setData(msg);
        return GarlicMessageBuilder.buildCommonClove(ctx, clove, config);
    }

    private static byte[] buildCommonClove(RouterContext ctx, GarlicClove clove, GarlicConfig config) throws DataFormatException, IOException {
        clove.setCertificate(config.getCertificate());
        clove.setCloveId(config.getId());
        clove.setExpiration(new Date(config.getExpiration()));
        clove.setInstructions(config.getDeliveryInstructions());
        return clove.toByteArray();
    }
}

