/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;

public class Shitlist {
    private Log _log;
    private RouterContext _context;
    private Map<Hash, Entry> _entries;
    public static final long SHITLIST_DURATION_MS = 1200000L;
    public static final long SHITLIST_DURATION_MAX = 1800000L;
    public static final long SHITLIST_DURATION_PARTIAL = 600000L;
    public static final long SHITLIST_DURATION_FOREVER = 15638400000L;
    public static final long SHITLIST_CLEANER_START_DELAY = 600000L;

    public Shitlist(RouterContext context) {
        this._context = context;
        this._log = context.logManager().getLog(Shitlist.class);
        this._entries = new ConcurrentHashMap<Hash, Entry>(8);
        this._context.jobQueue().addJob(new Cleanup(this._context));
    }

    public int getRouterCount() {
        return this._entries.size();
    }

    public boolean shitlistRouter(Hash peer) {
        return this.shitlistRouter(peer, null);
    }

    public boolean shitlistRouter(Hash peer, String reason) {
        return this.shitlistRouter(peer, reason, null);
    }

    public boolean shitlistRouter(Hash peer, String reason, String transport) {
        return this.shitlistRouter(peer, reason, transport, false);
    }

    public boolean shitlistRouterForever(Hash peer, String reason) {
        return this.shitlistRouter(peer, reason, null, true);
    }

    public boolean shitlistRouter(Hash peer, String reason, String transport, boolean forever) {
        Entry old;
        if (peer == null) {
            this._log.error("wtf, why did we try to shitlist null?", (Throwable)new Exception("shitfaced"));
            return false;
        }
        if (this._context.routerHash().equals((Object)peer)) {
            this._log.error("wtf, why did we try to shitlist ourselves?", (Throwable)new Exception("shitfaced"));
            return false;
        }
        boolean wasAlready = false;
        if (this._log.shouldLog(20)) {
            this._log.info("Shitlisting router " + peer.toBase64() + (transport != null ? " on transport " + transport : ""), (Throwable)new Exception("Shitlist cause: " + reason));
        }
        Entry e = new Entry();
        if (forever) {
            e.expireOn = this._context.clock().now() + 15638400000L;
        } else if (transport != null) {
            e.expireOn = this._context.clock().now() + 600000L;
        } else {
            long period = 1200000L + this._context.random().nextLong(1200000L);
            PeerProfile prof = this._context.profileOrganizer().getProfile(peer);
            if (prof != null) {
                period = 1200000L << prof.incrementShitlists();
                period += this._context.random().nextLong(period);
            }
            if (period > 1800000L) {
                period = 1800000L;
            }
            e.expireOn = this._context.clock().now() + period;
        }
        e.cause = reason;
        e.transports = null;
        if (transport != null) {
            e.transports = new ConcurrentHashSet(1);
            e.transports.add(transport);
        }
        if ((old = this._entries.get(peer)) != null) {
            wasAlready = true;
            if (old.expireOn > e.expireOn) {
                e.expireOn = old.expireOn;
                e.cause = old.cause;
            }
            if (e.transports != null) {
                if (old.transports != null) {
                    e.transports.addAll(old.transports);
                } else {
                    e.transports = null;
                    e.cause = reason;
                }
            }
        }
        this._entries.put(peer, e);
        if (transport == null) {
            this._context.netDb().fail(peer);
        }
        if (!wasAlready) {
            this._context.messageHistory().shitlist(peer, reason);
        }
        return wasAlready;
    }

    public void unshitlistRouter(Hash peer) {
        this.unshitlistRouter(peer, true);
    }

    private void unshitlistRouter(Hash peer, boolean realUnshitlist) {
        this.unshitlistRouter(peer, realUnshitlist, null);
    }

    public void unshitlistRouter(Hash peer, String transport) {
        this.unshitlistRouter(peer, true, transport);
    }

    private void unshitlistRouter(Hash peer, boolean realUnshitlist, String transport) {
        if (peer == null) {
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Calling unshitlistRouter " + peer.toBase64() + (transport != null ? "/" + transport : ""));
        }
        boolean fully = false;
        Entry e = this._entries.remove(peer);
        if (e == null || e.transports == null || transport == null || e.transports.size() <= 1) {
            fully = true;
        } else {
            e.transports.remove(transport);
            if (e.transports.size() <= 0) {
                fully = true;
            } else {
                this._entries.put(peer, e);
            }
        }
        if (fully) {
            PeerProfile prof;
            if (realUnshitlist && (prof = this._context.profileOrganizer().getProfile(peer)) != null) {
                prof.unshitlist();
            }
            this._context.messageHistory().unshitlist(peer);
            if (this._log.shouldLog(20) && e != null) {
                this._log.info("Unshitlisting router " + peer.toBase64() + (transport != null ? "/" + transport : ""));
            }
        }
    }

    public boolean isShitlisted(Hash peer) {
        return this.isShitlisted(peer, null);
    }

    public boolean isShitlisted(Hash peer, String transport) {
        boolean rv = false;
        boolean unshitlist = false;
        Entry entry = this._entries.get(peer);
        if (entry == null) {
            rv = false;
        } else if (entry.expireOn <= this._context.clock().now()) {
            this._entries.remove(peer);
            unshitlist = true;
            rv = false;
        } else {
            rv = entry.transports == null ? true : entry.transports.contains(transport);
        }
        if (unshitlist) {
            PeerProfile prof = this._context.profileOrganizer().getProfile(peer);
            if (prof != null) {
                prof.unshitlist();
            }
            this._context.messageHistory().unshitlist(peer);
            if (this._log.shouldLog(20)) {
                this._log.info("Unshitlisting router (expired) " + peer.toBase64());
            }
        }
        return rv;
    }

    public boolean isShitlistedForever(Hash peer) {
        Entry entry = this._entries.get(peer);
        return entry != null && entry.expireOn > this._context.clock().now() + 1800000L;
    }

    public void renderStatusHTML(Writer out) throws IOException {
        StringBuilder buf = new StringBuilder(1024);
        buf.append("<h2>Banned Peers</h2>");
        TreeMap<Hash, Entry> entries = new TreeMap<Hash, Entry>(new HashComparator());
        entries.putAll(this._entries);
        buf.append("<ul>");
        for (Map.Entry e : entries.entrySet()) {
            Hash key = (Hash)e.getKey();
            Entry entry = (Entry)e.getValue();
            buf.append("<li>").append(this._context.commSystem().renderPeerHTML(key));
            long expires = entry.expireOn - this._context.clock().now();
            if (expires < 432000000L) {
                buf.append(" Temporary ban expiring in ");
            } else {
                buf.append(" Banned until restart or in ");
            }
            buf.append(DataHelper.formatDuration((long)expires));
            Set<String> transports = entry.transports;
            if (transports != null && transports.size() > 0) {
                buf.append(" on the following transport: ").append(transports);
            }
            if (entry.cause != null) {
                buf.append("<br>\n");
                buf.append(entry.cause);
            }
            buf.append(" (<a href=\"configpeer.jsp?peer=").append(key.toBase64()).append("#unsh\">unban now</a>)");
            buf.append("</li>\n");
        }
        buf.append("</ul>\n");
        out.write(buf.toString());
        out.flush();
    }

    class HashComparator
    implements Comparator {
        HashComparator() {
        }

        public int compare(Object l, Object r) {
            return ((Hash)l).toBase64().compareTo(((Hash)r).toBase64());
        }
    }

    private class Cleanup
    extends JobImpl {
        private List<Hash> _toUnshitlist;

        public Cleanup(RouterContext ctx) {
            super(ctx);
            this._toUnshitlist = new ArrayList<Hash>(4);
            this.getTiming().setStartAfter(ctx.clock().now() + 600000L);
        }

        public String getName() {
            return "Expire banned peers";
        }

        public void runJob() {
            this._toUnshitlist.clear();
            long now = this.getContext().clock().now();
            try {
                Iterator iter = Shitlist.this._entries.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry e = iter.next();
                    if (((Entry)e.getValue()).expireOn > now) continue;
                    iter.remove();
                    this._toUnshitlist.add((Hash)e.getKey());
                }
            }
            catch (IllegalStateException ise) {
                // empty catch block
            }
            for (Hash peer : this._toUnshitlist) {
                PeerProfile prof = Shitlist.this._context.profileOrganizer().getProfile(peer);
                if (prof != null) {
                    prof.unshitlist();
                }
                Shitlist.this._context.messageHistory().unshitlist(peer);
                if (!Shitlist.this._log.shouldLog(20)) continue;
                Shitlist.this._log.info("Unshitlisting router (expired) " + peer.toBase64());
            }
            this.requeue(30000L);
        }
    }

    private static class Entry {
        long expireOn;
        String cause;
        Set<String> transports;

        private Entry() {
        }
    }
}

