/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import net.i2p.I2PAppContext;
import net.i2p.router.RouterContext;
import net.i2p.util.Clock;

public class RouterClock
extends Clock {
    RouterContext _contextRC;

    public RouterClock(RouterContext context) {
        super((I2PAppContext)context);
        this._contextRC = context;
    }

    public void setOffset(long offsetMs, boolean force) {
        long delta = offsetMs - this._offset;
        if (!force) {
            Long peerClockSkew;
            if (offsetMs > 259200000L || offsetMs < -259200000L) {
                this.getLog().error("Maximum offset shift exceeded [" + offsetMs + "], NOT HONORING IT");
                return;
            }
            if (this._alreadyChanged && System.currentTimeMillis() - this._startedOn > 600000L && (delta > 600000L || delta < -600000L)) {
                this.getLog().log(50, "The clock has already been updated, but you want to change it by " + delta + " to " + offsetMs + "?  Did something break?");
                return;
            }
            if (delta < 10000L && delta > -10000L) {
                this.getLog().debug("Not changing offset since it is only " + delta + "ms");
                this._alreadyChanged = true;
                return;
            }
            if (Boolean.valueOf(this._contextRC.getProperty("router.clockOffsetSanityCheck", "true")).booleanValue() && (peerClockSkew = this._contextRC.commSystem().getFramedAveragePeerClockSkew(50)) != null) {
                long currentPeerClockSkew = peerClockSkew;
                long predictedPeerClockSkew = currentPeerClockSkew + delta / 1000L;
                if (Math.abs(predictedPeerClockSkew) > Math.abs(currentPeerClockSkew) + 5L || Math.abs(predictedPeerClockSkew) > 20L) {
                    this.getLog().error("Ignoring clock offset " + offsetMs + "ms (current " + this._offset + "ms) since it would increase peer clock skew from " + currentPeerClockSkew + "s to " + predictedPeerClockSkew + "s. Broken server in pool.ntp.org?");
                    return;
                }
                this.getLog().debug("Approving clock offset " + offsetMs + "ms (current " + this._offset + "ms) since it would decrease peer clock skew from " + currentPeerClockSkew + "s to " + predictedPeerClockSkew + "s.");
            }
        }
        if (this._alreadyChanged) {
            if (delta > 15000L) {
                this.getLog().log(50, "Updating clock offset to " + offsetMs + "ms from " + this._offset + "ms");
            } else if (this.getLog().shouldLog(20)) {
                this.getLog().info("Updating clock offset to " + offsetMs + "ms from " + this._offset + "ms");
            }
            if (!this._statCreated) {
                this._contextRC.statManager().createRateStat("clock.skew", "How far is the already adjusted clock being skewed?", "Clock", new long[]{600000L, 10800000L, 5184000L});
            }
            this._statCreated = true;
            this._contextRC.statManager().addRateData("clock.skew", delta, 0L);
        } else {
            this.getLog().log(20, "Initializing clock offset to " + offsetMs + "ms from " + this._offset + "ms");
        }
        this._alreadyChanged = true;
        this._offset = offsetMs;
        this.fireOffsetChanged(delta);
    }
}

