/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import net.i2p.crypto.DHSessionKeyBuilder;
import net.i2p.data.Certificate;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.RouterInfo;
import net.i2p.data.SigningPrivateKey;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.RouterWatchdog;
import net.i2p.router.message.GarlicMessageHandler;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.startup.StartupJob;
import net.i2p.router.startup.WorkingDir;
import net.i2p.router.transport.FIFOBandwidthLimiter;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;
import net.i2p.stat.StatManager;
import net.i2p.util.FileUtil;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.SimpleScheduler;
import net.i2p.util.SimpleTimer;

public class Router {
    private Log _log;
    private RouterContext _context;
    private final Properties _config = new Properties();
    private String _configFilename;
    private RouterInfo _routerInfo;
    private long _started;
    private boolean _higherVersionSeen;
    private boolean _killVMOnEnd;
    private boolean _isAlive;
    private int _gracefulExitCode = -1;
    private I2PThread.OOMEventListener _oomListener;
    private ShutdownHook _shutdownHook;
    private final I2PThread _gracefulShutdownDetector;
    public static final String PROP_CONFIG_FILE = "router.configLocation";
    public static final long CLOCK_FUDGE_FACTOR = 60000L;
    public static final int NETWORK_ID = 2;
    private static final int COALESCE_TIME = 50000;
    public static final String PROP_HIDDEN = "router.hiddenMode";
    public static final String PROP_HIDDEN_HIDDEN = "router.isHidden";
    public static final String PROP_DYNAMIC_KEYS = "router.dynamicKeys";
    public static final String PROP_INFO_FILENAME = "router.info.location";
    public static final String PROP_INFO_FILENAME_DEFAULT = "router.info";
    public static final String PROP_KEYS_FILENAME = "router.keys.location";
    public static final String PROP_KEYS_FILENAME_DEFAULT = "router.keys";
    public static final String PROP_SHUTDOWN_IN_PROGRESS = "__shutdownInProgress";
    public static final String DNS_CACHE_TIME = "300";
    public static final char CAPABILITY_BW12 = 'K';
    public static final char CAPABILITY_BW32 = 'L';
    public static final char CAPABILITY_BW64 = 'M';
    public static final char CAPABILITY_BW128 = 'N';
    public static final char CAPABILITY_BW256 = 'O';
    public static final char CAPABILITY_REACHABLE = 'R';
    public static final char CAPABILITY_UNREACHABLE = 'U';
    public static final String PROP_FORCE_UNREACHABLE = "router.forceUnreachable";
    public static final char CAPABILITY_NEW_TUNNEL = 'T';
    private static final String[] _rebuildFiles;
    static final String IDENTLOG = "identlog.txt";
    public static final int EXIT_GRACEFUL = 2;
    public static final int EXIT_HARD = 3;
    public static final int EXIT_OOM = 10;
    public static final int EXIT_HARD_RESTART = 4;
    public static final int EXIT_GRACEFUL_RESTART = 5;
    private static final boolean ALLOW_DYNAMIC_KEYS = false;
    public static final String UPDATE_FILE = "i2pupdate.zip";
    static final long LIVELINESS_DELAY = 60000L;
    public static final String PROP_BANDWIDTH_SHARE_PERCENTAGE = "router.sharePercentage";
    public static final int DEFAULT_SHARE_PERCENTAGE = 80;

    public Router() {
        this(null, null);
    }

    public Router(Properties envProps) {
        this(null, envProps);
    }

    public Router(String configFilename) {
        this(configFilename, null);
    }

    public Router(String configFilename, Properties envProps) {
        if (configFilename == null) {
            if (envProps != null) {
                this._configFilename = envProps.getProperty(PROP_CONFIG_FILE);
            }
            if (this._configFilename == null) {
                this._configFilename = System.getProperty(PROP_CONFIG_FILE, "router.config");
            }
        } else {
            this._configFilename = configFilename;
        }
        String migrate = System.getProperty("i2p.dir.migrate");
        boolean migrateFiles = Boolean.valueOf(migrate);
        String userDir = WorkingDir.getWorkingDir(envProps, migrateFiles);
        File cf = new File(this._configFilename);
        if (!cf.isAbsolute()) {
            cf = new File(userDir, this._configFilename);
            this._configFilename = cf.getAbsolutePath();
        }
        this.readConfig();
        if (envProps == null) {
            envProps = this._config;
        } else {
            for (String string : this._config.keySet()) {
                String v = this._config.getProperty(string);
                envProps.setProperty(string, v);
            }
        }
        if (envProps.getProperty("i2p.dir.config") == null) {
            envProps.setProperty("i2p.dir.config", userDir);
        }
        this._context = new RouterContext(this, envProps);
        if (!this.beginMarkingLiveliness()) {
            System.err.println("ERROR: There appears to be another router already running!");
            System.err.println("       Please make sure to shut down old instances before starting up");
            System.err.println("       a new one.  If you are positive that no other instance is running,");
            System.err.println("       please delete the file " + this.getPingFile().getAbsolutePath());
            System.exit(-1);
        }
        this.installUpdates();
        this._context.initAll();
        this._routerInfo = null;
        this._higherVersionSeen = false;
        this._log = this._context.logManager().getLog(Router.class);
        this._log.info("New router created with config file " + this._configFilename);
        this._killVMOnEnd = true;
        this._oomListener = new I2PThread.OOMEventListener(){

            public void outOfMemory(OutOfMemoryError oom) {
                Router.this._log.log(50, "Thread ran out of memory", (Throwable)oom);
                for (int i = 0; i < 5; ++i) {
                    try {
                        Router.this._log.log(50, "free mem: " + Runtime.getRuntime().freeMemory() + " total mem: " + Runtime.getRuntime().totalMemory());
                        break;
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        continue;
                    }
                }
                Router.this.shutdown(10);
            }
        };
        this._shutdownHook = new ShutdownHook(this._context);
        this._gracefulShutdownDetector = new I2PThread((Runnable)new GracefulShutdown());
        this._gracefulShutdownDetector.setDaemon(true);
        this._gracefulShutdownDetector.setName("Graceful shutdown hook");
        this._gracefulShutdownDetector.start();
        I2PThread watchdog = new I2PThread((Runnable)new RouterWatchdog(this._context));
        watchdog.setName("RouterWatchdog");
        watchdog.setDaemon(true);
        watchdog.start();
    }

    public void setKillVMOnEnd(boolean shouldDie) {
        this._killVMOnEnd = shouldDie;
    }

    public boolean getKillVMOnEnd() {
        return this._killVMOnEnd;
    }

    public String getConfigFilename() {
        return this._configFilename;
    }

    public void setConfigFilename(String filename) {
        this._configFilename = filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConfigSetting(String name) {
        Properties properties = this._config;
        synchronized (properties) {
            return this._config.getProperty(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfigSetting(String name, String value) {
        Properties properties = this._config;
        synchronized (properties) {
            this._config.setProperty(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConfigSetting(String name) {
        Properties properties = this._config;
        synchronized (properties) {
            this._config.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getConfigSettings() {
        Properties properties = this._config;
        synchronized (properties) {
            return new HashSet<Object>(this._config.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getConfigMap() {
        Properties rv = new Properties();
        Properties properties = this._config;
        synchronized (properties) {
            rv.putAll((Map<?, ?>)this._config);
        }
        return rv;
    }

    public RouterInfo getRouterInfo() {
        return this._routerInfo;
    }

    public void setRouterInfo(RouterInfo info) {
        this._routerInfo = info;
        if (info != null) {
            this._context.jobQueue().addJob(new PersistRouterInfoJob(this._context));
        }
    }

    public boolean getHigherVersionSeen() {
        return this._higherVersionSeen;
    }

    public void setHigherVersionSeen(boolean seen) {
        this._higherVersionSeen = seen;
    }

    public long getWhenStarted() {
        return this._started;
    }

    public long getUptime() {
        if (this._context == null || this._context.clock() == null) {
            return 1L;
        }
        return this._context.clock().now() - this._context.clock().getOffset() - this._started;
    }

    public RouterContext getContext() {
        return this._context;
    }

    void runRouter() {
        this._isAlive = true;
        this._started = this._context.clock().now();
        Runtime.getRuntime().addShutdownHook(this._shutdownHook);
        I2PThread.addOOMEventListener((I2PThread.OOMEventListener)this._oomListener);
        this._context.keyManager().startup();
        this.readConfig();
        this.setupHandlers();
        this._context.messageValidator().startup();
        this._context.tunnelDispatcher().startup();
        this._context.inNetMessagePool().startup();
        this.startupQueue();
        SimpleScheduler.getInstance().addPeriodicEvent((SimpleTimer.TimedEvent)new CoalesceStatsEvent(this._context), 50000L);
        this._context.jobQueue().addJob(new UpdateRoutingKeyModifierJob(this._context));
        this.warmupCrypto();
        this._context.blocklist().startup();
        long before = System.currentTimeMillis();
        this._context.clock().getTimestamper().waitForInitialization();
        long waited = System.currentTimeMillis() - before;
        if (this._log.shouldLog(20)) {
            this._log.info("Waited " + waited + "ms to initialize");
        }
        this._context.jobQueue().addJob(new StartupJob(this._context));
    }

    public void readConfig() {
        String f = this.getConfigFilename();
        Properties config = Router.getConfig(this._context, f);
        for (String string : config.keySet()) {
            String val = config.getProperty(string);
            this.setConfigSetting(string, val);
        }
    }

    private static Properties getConfig(RouterContext ctx, String filename) {
        Properties props;
        block6: {
            Log log = null;
            if (ctx != null && (log = ctx.logManager().getLog(Router.class)).shouldLog(10)) {
                log.debug("Config file: " + filename, (Throwable)new Exception("location"));
            }
            props = new Properties();
            try {
                File f = new File(filename);
                if (f.canRead()) {
                    DataHelper.loadProps((Properties)props, (File)f);
                    props.remove(PROP_SHUTDOWN_IN_PROGRESS);
                } else if (log != null) {
                    log.warn("Configuration file " + filename + " does not exist");
                }
            }
            catch (Exception ioe) {
                if (log == null) break block6;
                log.error("Error loading the router configuration from " + filename, (Throwable)ioe);
            }
        }
        return props;
    }

    public boolean isAlive() {
        return this._isAlive;
    }

    public void rebuildRouterInfo() {
        this.rebuildRouterInfo(false);
    }

    public void rebuildRouterInfo(boolean blockingRebuild) {
        if (this._log.shouldLog(20)) {
            this._log.info("Rebuilding new routerInfo");
        }
        RouterInfo ri = null;
        ri = this._routerInfo != null ? new RouterInfo(this._routerInfo) : new RouterInfo();
        try {
            ri.setPublished(this._context.clock().now());
            Properties stats = this._context.statPublisher().publishStatistics();
            stats.setProperty("netId", "2");
            ri.setOptions(stats);
            ri.setAddresses(this._context.commSystem().createAddresses());
            this.addCapabilities(ri);
            SigningPrivateKey key = this._context.keyManager().getSigningPrivateKey();
            if (key == null) {
                this._log.log(50, "Internal error - signing private key not known?  wtf");
                return;
            }
            ri.sign(key);
            this.setRouterInfo(ri);
            Republish r = new Republish();
            if (blockingRebuild) {
                r.timeReached();
            } else {
                SimpleScheduler.getInstance().addEvent((SimpleTimer.TimedEvent)r, 0L);
            }
        }
        catch (DataFormatException dfe) {
            this._log.log(50, "Internal error - unable to sign our own address?!", (Throwable)dfe);
        }
    }

    public void addCapabilities(RouterInfo ri) {
        String forceUnreachable;
        int bwLim = Math.min(this._context.bandwidthLimiter().getInboundKBytesPerSecond(), this._context.bandwidthLimiter().getOutboundKBytesPerSecond());
        bwLim = (int)((double)bwLim * this.getSharePercentage());
        if (this._log.shouldLog(20)) {
            this._log.info("Adding capabilities w/ bw limit @ " + bwLim, (Throwable)new Exception("caps"));
        }
        if (bwLim < 12) {
            ri.addCapability('K');
        } else if (bwLim <= 32) {
            ri.addCapability('L');
        } else if (bwLim <= 64) {
            ri.addCapability('M');
        } else if (bwLim <= 128) {
            ri.addCapability('N');
        } else {
            ri.addCapability('O');
        }
        if (FloodfillNetworkDatabaseFacade.floodfillEnabled(this._context)) {
            ri.addCapability('f');
        }
        if ("true".equalsIgnoreCase(this._context.getProperty(PROP_HIDDEN, "false"))) {
            ri.addCapability('H');
        }
        if ((forceUnreachable = this._context.getProperty(PROP_FORCE_UNREACHABLE)) != null && "true".equalsIgnoreCase(forceUnreachable)) {
            ri.addCapability('U');
            return;
        }
        switch (this._context.commSystem().getReachabilityStatus()) {
            case 0: {
                ri.addCapability('R');
                break;
            }
            case 1: 
            case 2: {
                ri.addCapability('U');
                break;
            }
        }
    }

    public boolean isHidden() {
        RouterInfo ri = this._routerInfo;
        if (ri != null && ri.isHidden()) {
            return true;
        }
        return Boolean.valueOf(this._context.getProperty(PROP_HIDDEN_HIDDEN));
    }

    public Certificate createCertificate() {
        Certificate cert = new Certificate();
        if (this.isHidden()) {
            cert.setCertificateType(2);
            cert.setPayload(null);
        } else {
            cert.setCertificateType(0);
            cert.setPayload(null);
        }
        return cert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killKeys() {
        new Exception("Clearing identity files").printStackTrace();
        int remCount = 0;
        for (int i = 0; i < _rebuildFiles.length; ++i) {
            File f = new File(this._context.getRouterDir(), _rebuildFiles[i]);
            if (!f.exists()) continue;
            boolean removed = f.delete();
            if (removed) {
                System.out.println("INFO:  Removing old identity file: " + _rebuildFiles[i]);
                ++remCount;
                continue;
            }
            System.out.println("ERROR: Could not remove old identity file: " + _rebuildFiles[i]);
        }
        if (remCount > 0) {
            FileOutputStream log = null;
            try {
                log = new FileOutputStream(new File(this._context.getRouterDir(), IDENTLOG), true);
                log.write((new Date() + ": Old router identity keys cleared\n").getBytes());
            }
            catch (IOException ioe) {
            }
            finally {
                if (log != null) {
                    try {
                        log.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
    }

    public void rebuildNewIdentity() {
        this.killKeys();
        for (Runnable task : this._context.getShutdownTasks()) {
            try {
                task.run();
            }
            catch (Throwable t) {
                this._log.log(50, "Error running shutdown task", t);
            }
        }
        this.finalShutdown(4);
    }

    private void warmupCrypto() {
        this._context.random().nextBoolean();
        new DHSessionKeyBuilder();
    }

    private void startupQueue() {
        this._context.jobQueue().runQueue(1);
    }

    private void setupHandlers() {
        this._context.inNetMessagePool().registerHandlerJobBuilder(11, new GarlicMessageHandler(this._context));
    }

    public void renderStatusHTML(Writer out) throws IOException {
        out.write("<h1>Router console</h1>\n<i><a href=\"/oldconsole.jsp\">console</a> | <a href=\"/oldstats.jsp\">stats</a></i><br>\n<form action=\"/oldconsole.jsp\"><select name=\"go\" onChange='location.href=this.value'><option value=\"/oldconsole.jsp#bandwidth\">Bandwidth</option>\n<option value=\"/oldconsole.jsp#clients\">Clients</option>\n<option value=\"/oldconsole.jsp#transports\">Transports</option>\n<option value=\"/oldconsole.jsp#profiles\">Peer Profiles</option>\n<option value=\"/oldconsole.jsp#tunnels\">Tunnels</option>\n<option value=\"/oldconsole.jsp#jobs\">Jobs</option>\n<option value=\"/oldconsole.jsp#shitlist\">Shitlist</option>\n<option value=\"/oldconsole.jsp#pending\">Pending messages</option>\n<option value=\"/oldconsole.jsp#netdb\">Network Database</option>\n<option value=\"/oldconsole.jsp#logs\">Log messages</option>\n</select> <input type=\"submit\" value=\"GO\" /> </form><hr>\n");
        StringBuilder buf = new StringBuilder(32768);
        if (this._routerInfo != null && this._routerInfo.getIdentity() != null) {
            buf.append("<b>Router: </b> ").append(this._routerInfo.getIdentity().getHash().toBase64()).append("<br>\n");
        }
        buf.append("<b>As of: </b> ").append(new Date(this._context.clock().now())).append(" (uptime: ").append(DataHelper.formatDuration((long)this.getUptime())).append(") <br>\n");
        buf.append("<b>Started on: </b> ").append(new Date(this.getWhenStarted())).append("<br>\n");
        buf.append("<b>Clock offset: </b> ").append(this._context.clock().getOffset()).append("ms (OS time: ").append(new Date(this._context.clock().now() - this._context.clock().getOffset())).append(")<br>\n");
        long tot = Runtime.getRuntime().totalMemory() / 1024L;
        long free = Runtime.getRuntime().freeMemory() / 1024L;
        buf.append("<b>Memory:</b> In use: ").append(tot - free).append("KB Free: ").append(free).append("KB <br>\n");
        buf.append("<b>Version:</b> Router: ").append("0.7.7").append(" / SDK: ").append("0.7.7").append("<br>\n");
        if (this._higherVersionSeen) {
            buf.append("<b><font color=\"red\">HIGHER VERSION SEEN</font><b> - please <a href=\"http://www.i2p.net/\">check</a> to see if there is a new release out<br>\n");
        }
        buf.append("<hr><a name=\"bandwidth\"> </a><h2>Bandwidth</h2>\n");
        long sent = this._context.bandwidthLimiter().getTotalAllocatedOutboundBytes();
        long received = this._context.bandwidthLimiter().getTotalAllocatedInboundBytes();
        buf.append("<ul>");
        buf.append("<li> ").append(sent).append(" bytes sent, ");
        buf.append(received).append(" bytes received</li>");
        long notSent = this._context.bandwidthLimiter().getTotalWastedOutboundBytes();
        long notReceived = this._context.bandwidthLimiter().getTotalWastedInboundBytes();
        buf.append("<li> ").append(notSent).append(" bytes outbound bytes unused, ");
        buf.append(notReceived).append(" bytes inbound bytes unused</li>");
        DecimalFormat fmt = new DecimalFormat("##0.00");
        long lifetime = this._context.clock().now() - this._context.clock().getOffset() - this.getWhenStarted();
        lifetime /= 1000L;
        if (sent > 0L && received > 0L) {
            double sendKBps = (double)sent / ((double)lifetime * 1024.0);
            double receivedKBps = (double)received / ((double)lifetime * 1024.0);
            buf.append("<li>Lifetime rate: ");
            buf.append(fmt.format(sendKBps)).append("KBps sent ");
            buf.append(fmt.format(receivedKBps)).append("KBps received");
            buf.append("</li>");
        }
        if (notSent > 0L && notReceived > 0L) {
            double notSendKBps = (double)notSent / ((double)lifetime * 1024.0);
            double notReceivedKBps = (double)notReceived / ((double)lifetime * 1024.0);
            buf.append("<li>Lifetime unused rate: ");
            buf.append(fmt.format(notSendKBps)).append("KBps outbound unused  ");
            buf.append(fmt.format(notReceivedKBps)).append("KBps inbound unused");
            buf.append("</li>");
        }
        RateStat sendRate = this._context.statManager().getRate("transport.sendMessageSize");
        for (int i = 0; i < sendRate.getPeriods().length; ++i) {
            Rate rate = sendRate.getRate(sendRate.getPeriods()[i]);
            double bytes = rate.getLastTotalValue();
            long ms = rate.getLastTotalEventTime() + rate.getLastTotalEventTime();
            if (ms <= 0L) {
                bytes = 0.0;
                ms = 1L;
            }
            buf.append("<li>");
            buf.append(DataHelper.formatDuration((long)rate.getPeriod())).append(" instantaneous send avg: ");
            double bps = bytes * 1000.0 / (double)ms;
            if (bps > 2048.0) {
                buf.append(fmt.format(bps /= 1024.0)).append(" KBps");
            } else {
                buf.append(fmt.format(bps)).append(" Bps");
            }
            buf.append(" over ").append((long)bytes).append(" bytes");
            buf.append("</li><li>");
            buf.append(DataHelper.formatDuration((long)rate.getPeriod())).append(" period send avg: ");
            bps = bytes * 1000.0 / (double)rate.getPeriod();
            if (bps > 2048.0) {
                buf.append(fmt.format(bps /= 1024.0)).append(" KBps");
            } else {
                buf.append(fmt.format(bps)).append(" Bps");
            }
            buf.append(" over ").append((long)bytes).append(" bytes");
            buf.append("</li>");
        }
        RateStat receiveRate = this._context.statManager().getRate("transport.receiveMessageSize");
        for (int i = 0; i < receiveRate.getPeriods().length; ++i) {
            Rate rate = receiveRate.getRate(receiveRate.getPeriods()[i]);
            double bytes = rate.getLastTotalValue();
            long ms = rate.getLastTotalEventTime();
            if (ms <= 0L) {
                bytes = 0.0;
                ms = 1L;
            }
            buf.append("<li>");
            buf.append(DataHelper.formatDuration((long)rate.getPeriod())).append(" instantaneous receive avg: ");
            double bps = bytes * 1000.0 / (double)ms;
            if (bps > 2048.0) {
                buf.append(fmt.format(bps /= 1024.0)).append(" KBps ");
            } else {
                buf.append(fmt.format(bps)).append(" Bps ");
            }
            buf.append(" over ").append((long)bytes).append(" bytes");
            buf.append("</li><li>");
            buf.append(DataHelper.formatDuration((long)rate.getPeriod())).append(" period receive avg: ");
            bps = bytes * 1000.0 / (double)rate.getPeriod();
            if (bps > 2048.0) {
                buf.append(fmt.format(bps /= 1024.0)).append(" KBps");
            } else {
                buf.append(fmt.format(bps)).append(" Bps");
            }
            buf.append(" over ").append((long)bytes).append(" bytes");
            buf.append("</li>");
        }
        buf.append("</ul>\n");
        buf.append("<i>Instantaneous averages count how fast the transfers go when we're trying to transfer data, ");
        buf.append("while period averages count how fast the transfers go across the entire period, even when we're not ");
        buf.append("trying to transfer data.  Lifetime averages count how many elephants there are on the moon [like anyone reads this text]</i>");
        buf.append("\n");
        out.write(buf.toString());
        this._context.bandwidthLimiter().renderStatusHTML(out);
        out.write("<hr><a name=\"clients\"> </a>\n");
        this._context.clientManager().renderStatusHTML(out);
        out.write("\n<hr><a name=\"transports\"> </a>\n");
        this._context.commSystem().renderStatusHTML(out);
        out.write("\n<hr><a name=\"profiles\"> </a>\n");
        this._context.peerManager().renderStatusHTML(out);
        out.write("\n<hr><a name=\"tunnels\"> </a>\n");
        this._context.tunnelManager().renderStatusHTML(out);
        out.write("\n<hr><a name=\"jobs\"> </a>\n");
        this._context.jobQueue().renderStatusHTML(out);
        out.write("\n<hr><a name=\"shitlist\"> </a>\n");
        this._context.shitlist().renderStatusHTML(out);
        out.write("\n<hr><a name=\"pending\"> </a>\n");
        this._context.messageRegistry().renderStatusHTML(out);
        out.write("\n<hr><a name=\"netdb\"> </a>\n");
        this._context.netDb().renderLeaseSetHTML(out);
        this._context.netDb().renderStatusHTML(out);
        buf.setLength(0);
        buf.append("\n<hr><a name=\"logs\"> </a>\n");
        List msgs = this._context.logManager().getBuffer().getMostRecentMessages();
        buf.append("\n<h2>Most recent console messages:</h2><table>\n");
        for (String msg : msgs) {
            buf.append("<tr><td align=\"left\"><pre>");
            Router.appendLogMessage(buf, msg);
            buf.append("</pre></td></tr>\n");
        }
        buf.append("</table>\n");
        out.write(buf.toString());
        out.flush();
    }

    private static final void appendLogMessage(StringBuilder buf, String msg) {
        buf.append(msg);
    }

    public void shutdown(int exitCode) {
        this._isAlive = false;
        this._context.random().saveSeed();
        I2PThread.removeOOMEventListener((I2PThread.OOMEventListener)this._oomListener);
        for (Runnable task : this._context.getShutdownTasks()) {
            try {
                task.run();
            }
            catch (Throwable t) {
                this._log.log(50, "Error running shutdown task", t);
            }
        }
        try {
            this._context.clientManager().shutdown();
        }
        catch (Throwable t) {
            this._log.log(50, "Error shutting down the client manager", t);
        }
        try {
            this._context.jobQueue().shutdown();
        }
        catch (Throwable t) {
            this._log.log(50, "Error shutting down the job queue", t);
        }
        try {
            this._context.statPublisher().shutdown();
        }
        catch (Throwable t) {
            this._log.log(50, "Error shutting down the stats manager", t);
        }
        try {
            this._context.tunnelManager().shutdown();
        }
        catch (Throwable t) {
            this._log.log(50, "Error shutting down the tunnel manager", t);
        }
        try {
            this._context.tunnelDispatcher().shutdown();
        }
        catch (Throwable t) {
            this._log.log(50, "Error shutting down the tunnel dispatcher", t);
        }
        try {
            this._context.netDb().shutdown();
        }
        catch (Throwable t) {
            this._log.log(50, "Error shutting down the networkDb", t);
        }
        try {
            this._context.commSystem().shutdown();
        }
        catch (Throwable t) {
            this._log.log(50, "Error shutting down the comm system", t);
        }
        try {
            this._context.peerManager().shutdown();
        }
        catch (Throwable t) {
            this._log.log(50, "Error shutting down the peer manager", t);
        }
        try {
            this._context.messageRegistry().shutdown();
        }
        catch (Throwable t) {
            this._log.log(50, "Error shutting down the message registry", t);
        }
        try {
            this._context.messageValidator().shutdown();
        }
        catch (Throwable t) {
            this._log.log(50, "Error shutting down the message validator", t);
        }
        try {
            this._context.inNetMessagePool().shutdown();
        }
        catch (Throwable t) {
            this._log.log(50, "Error shutting down the inbound net pool", t);
        }
        this._context.deleteTempDir();
        RouterContext.listContexts().remove((Object)this._context);
        this.finalShutdown(exitCode);
    }

    public void finalShutdown(int exitCode) {
        this._log.log(50, "Shutdown(" + exitCode + ") complete", (Throwable)new Exception("Shutdown"));
        try {
            this._context.logManager().shutdown();
        }
        catch (Throwable t) {
            // empty catch block
        }
        File f = this.getPingFile();
        f.delete();
        if (this._killVMOnEnd) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Runtime.getRuntime().halt(exitCode);
        }
    }

    public void shutdownGracefully() {
        this.shutdownGracefully(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownGracefully(int exitCode) {
        this._gracefulExitCode = exitCode;
        this._config.setProperty(PROP_SHUTDOWN_IN_PROGRESS, "true");
        I2PThread i2PThread = this._gracefulShutdownDetector;
        synchronized (i2PThread) {
            this._gracefulShutdownDetector.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelGracefulShutdown() {
        this._gracefulExitCode = -1;
        this._config.remove(PROP_SHUTDOWN_IN_PROGRESS);
        I2PThread i2PThread = this._gracefulShutdownDetector;
        synchronized (i2PThread) {
            this._gracefulShutdownDetector.notifyAll();
        }
    }

    public int scheduledGracefulExitCode() {
        return this._gracefulExitCode;
    }

    public boolean gracefulShutdownInProgress() {
        return null != this._config.getProperty(PROP_SHUTDOWN_IN_PROGRESS);
    }

    public long getShutdownTimeRemaining() {
        if (this._gracefulExitCode <= 0) {
            return -1L;
        }
        if (this._gracefulExitCode == 3 || this._gracefulExitCode == 4) {
            return 0L;
        }
        long exp = this._context.tunnelManager().getLastParticipatingExpiration();
        if (exp < 0L) {
            return -1L;
        }
        return exp + 120000L - this._context.clock().now();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveConfig() {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this._configFilename);
            StringBuilder buf = new StringBuilder(8192);
            buf.append("# NOTE: This I2P config file must use UTF-8 encoding\n");
            Properties properties = this._config;
            synchronized (properties) {
                TreeSet<Object> ordered = new TreeSet<Object>(this._config.keySet());
                for (String string : ordered) {
                    String val = this._config.getProperty(string);
                    val = val.replaceAll("\\r", "\\\\r");
                    val = val.replaceAll("\\n", "\\\\n");
                    buf.append(string).append('=').append(val).append('\n');
                }
            }
            fos.write(buf.toString().getBytes("UTF-8"));
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(40)) {
                this._log.error("Error saving the config to " + this._configFilename, (Throwable)ioe);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioe) {}
            }
        }
        return true;
    }

    public void restart() {
        this._isAlive = false;
        try {
            this._context.commSystem().restart();
        }
        catch (Throwable t) {
            this._log.log(50, "Error restarting the comm system", t);
        }
        try {
            this._context.clientManager().restart();
        }
        catch (Throwable t) {
            this._log.log(50, "Error restarting the client manager", t);
        }
        try {
            this._context.tunnelManager().restart();
        }
        catch (Throwable t) {
            this._log.log(50, "Error restarting the tunnel manager", t);
        }
        try {
            this._context.peerManager().restart();
        }
        catch (Throwable t) {
            this._log.log(50, "Error restarting the peer manager", t);
        }
        try {
            this._context.netDb().restart();
        }
        catch (Throwable t) {
            this._log.log(50, "Error restarting the networkDb", t);
        }
        this._log.log(50, "Restart teardown complete... ");
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this._log.log(50, "Restarting...");
        this._isAlive = true;
        this._started = this._context.clock().now();
        this._log.log(50, "Restart complete");
    }

    public static void main(String[] args) {
        System.out.println("Starting I2P 0.7.7-0");
        Router r = new Router();
        if (args != null && args.length == 1 && "rebuild".equals(args[0])) {
            r.rebuildNewIdentity();
        } else {
            r.runRouter();
        }
    }

    private void installUpdates() {
        File updateFile = new File(this._context.getRouterDir(), UPDATE_FILE);
        boolean exists = updateFile.exists();
        if (!exists) {
            updateFile = new File(this._context.getBaseDir(), UPDATE_FILE);
            exists = updateFile.exists();
        }
        if (exists) {
            boolean deleted;
            File test = new File(this._context.getBaseDir(), "history.txt");
            if (test.exists() && !test.canWrite() || !this._context.getBaseDir().canWrite()) {
                System.out.println("ERROR: No write permissions on " + this._context.getBaseDir() + " to extract software update file");
                return;
            }
            System.out.println("INFO: Update file exists [i2pupdate.zip] - installing");
            boolean ok = FileUtil.verifyZip((File)updateFile);
            if (ok) {
                ok = FileUtil.extractZip((File)updateFile, (File)this._context.getBaseDir());
            }
            if (ok) {
                System.out.println("INFO: Update installed");
            } else {
                System.out.println("ERROR: Update failed!");
            }
            if (!ok) {
                File bad = new File(this._context.getRouterDir(), "BAD-i2pupdate.zip");
                boolean renamed = updateFile.renameTo(bad);
                if (renamed) {
                    System.out.println("Moved update file to " + bad.getAbsolutePath());
                } else {
                    System.out.println("Deleting file " + updateFile.getAbsolutePath());
                    ok = true;
                }
            }
            if (ok && !(deleted = updateFile.delete())) {
                System.out.println("ERROR: Unable to delete the update file!");
                updateFile.deleteOnExit();
            }
            if (System.getProperty("wrapper.version") != null) {
                System.out.println("INFO: Restarting after update");
            } else {
                System.out.println("WARNING: Exiting after update, restart I2P");
            }
            System.exit(4);
        }
    }

    private File getPingFile() {
        String s = this._context.getProperty("router.pingFile", "router.ping");
        File f = new File(s);
        if (!f.isAbsolute()) {
            f = new File(this._context.getPIDDir(), s);
        }
        return f;
    }

    private boolean beginMarkingLiveliness() {
        File f = this.getPingFile();
        if (f.exists()) {
            long lastWritten = f.lastModified();
            if (System.currentTimeMillis() - lastWritten > 60000L) {
                System.err.println("WARN: Old router was not shut down gracefully, deleting router.ping");
                f.delete();
            } else {
                return false;
            }
        }
        Thread t = new Thread(new MarkLiveliness(this._context, this, f));
        t.setName("Mark router liveliness");
        t.setDaemon(true);
        t.start();
        return true;
    }

    public double getSharePercentage() {
        block5: {
            RouterContext ctx = this._context;
            if (ctx == null) {
                return 0.0;
            }
            String pct = ctx.getProperty(PROP_BANDWIDTH_SHARE_PERCENTAGE);
            if (pct != null) {
                try {
                    double d = Double.parseDouble(pct);
                    if (d > 1.0) {
                        return d / 100.0;
                    }
                    return d;
                }
                catch (NumberFormatException nfe) {
                    if (!this._log.shouldLog(20)) break block5;
                    this._log.info("Unable to get the share percentage");
                }
            }
        }
        return 0.8;
    }

    public int get1sRate() {
        return this.get1sRate(false);
    }

    public int get1sRate(boolean outboundOnly) {
        FIFOBandwidthLimiter bw;
        RouterContext ctx = this._context;
        if (ctx != null && (bw = ctx.bandwidthLimiter()) != null) {
            int out = (int)bw.getSendBps();
            if (outboundOnly) {
                return out;
            }
            return (int)Math.max((float)out, bw.getReceiveBps());
        }
        return 0;
    }

    public int get1sRateIn() {
        FIFOBandwidthLimiter bw;
        RouterContext ctx = this._context;
        if (ctx != null && (bw = ctx.bandwidthLimiter()) != null) {
            return (int)bw.getReceiveBps();
        }
        return 0;
    }

    public int get15sRate() {
        return this.get15sRate(false);
    }

    public int get15sRate(boolean outboundOnly) {
        FIFOBandwidthLimiter bw;
        RouterContext ctx = this._context;
        if (ctx != null && (bw = ctx.bandwidthLimiter()) != null) {
            int out = (int)bw.getSendBps15s();
            if (outboundOnly) {
                return out;
            }
            return (int)Math.max((float)out, bw.getReceiveBps15s());
        }
        return 0;
    }

    public int get15sRateIn() {
        FIFOBandwidthLimiter bw;
        RouterContext ctx = this._context;
        if (ctx != null && (bw = ctx.bandwidthLimiter()) != null) {
            return (int)bw.getReceiveBps15s();
        }
        return 0;
    }

    public int get1mRate() {
        return this.get1mRate(false);
    }

    public int get1mRate(boolean outboundOnly) {
        int send = 0;
        RouterContext ctx = this._context;
        if (ctx == null) {
            return 0;
        }
        StatManager mgr = ctx.statManager();
        if (mgr == null) {
            return 0;
        }
        RateStat rs = mgr.getRate("bw.sendRate");
        if (rs != null) {
            send = (int)rs.getRate(60000L).getAverageValue();
        }
        if (outboundOnly) {
            return send;
        }
        int recv = 0;
        rs = mgr.getRate("bw.recvRate");
        if (rs != null) {
            recv = (int)rs.getRate(60000L).getAverageValue();
        }
        return Math.max(send, recv);
    }

    public int get1mRateIn() {
        RouterContext ctx = this._context;
        if (ctx == null) {
            return 0;
        }
        StatManager mgr = ctx.statManager();
        if (mgr == null) {
            return 0;
        }
        RateStat rs = mgr.getRate("bw.recvRate");
        int recv = 0;
        if (rs != null) {
            recv = (int)rs.getRate(60000L).getAverageValue();
        }
        return recv;
    }

    public int get5mRate() {
        return this.get5mRate(false);
    }

    public int get5mRate(boolean outboundOnly) {
        int send = 0;
        RateStat rs = this._context.statManager().getRate("bw.sendRate");
        if (rs != null) {
            send = (int)rs.getRate(300000L).getAverageValue();
        }
        if (outboundOnly) {
            return send;
        }
        int recv = 0;
        rs = this._context.statManager().getRate("bw.recvRate");
        if (rs != null) {
            recv = (int)rs.getRate(300000L).getAverageValue();
        }
        return Math.max(send, recv);
    }

    static {
        System.setProperty("sun.net.inetaddr.ttl", DNS_CACHE_TIME);
        System.setProperty("sun.net.inetaddr.negative.ttl", DNS_CACHE_TIME);
        System.setProperty("networkaddress.cache.ttl", DNS_CACHE_TIME);
        System.setProperty("networkaddress.cache.negative.ttl", DNS_CACHE_TIME);
        System.setProperty("http.agent", "I2P");
        System.setProperty("http.keepAlive", "false");
        System.setProperty("user.timezone", "GMT");
        TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
        _rebuildFiles = new String[]{PROP_INFO_FILENAME_DEFAULT, PROP_KEYS_FILENAME_DEFAULT, "netDb/my.info", "connectionTag.keys", "keyBackup/privateEncryption.key", "keyBackup/privateSigning.key", "keyBackup/publicEncryption.key", "keyBackup/publicSigning.key", "sessionKeys.dat"};
    }

    private static class PersistRouterInfoJob
    extends JobImpl {
        private Log _log;

        public PersistRouterInfoJob(RouterContext ctx) {
            super(ctx);
        }

        public String getName() {
            return "Persist Updated Router Information";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runJob() {
            this._log = this.getContext().logManager().getLog(PersistRouterInfoJob.class);
            if (this._log.shouldLog(10)) {
                this._log.debug("Persisting updated router info");
            }
            String infoFilename = this.getContext().getProperty(Router.PROP_INFO_FILENAME, Router.PROP_INFO_FILENAME_DEFAULT);
            File infoFile = new File(this.getContext().getRouterDir(), infoFilename);
            RouterInfo info = this.getContext().router().getRouterInfo();
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(infoFile);
                info.writeBytes((OutputStream)fos);
            }
            catch (DataFormatException dfe) {
                this._log.error("Error rebuilding the router information", (Throwable)dfe);
            }
            catch (IOException ioe) {
                this._log.error("Error writing out the rebuilt router information", (Throwable)ioe);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
    }

    private static class ShutdownHook
    extends Thread {
        private RouterContext _context;
        private static int __id = 0;
        private int _id;

        public ShutdownHook(RouterContext ctx) {
            this._context = ctx;
            this._id = ++__id;
        }

        public void run() {
            this.setName("Router " + this._id + " shutdown");
            Log l = this._context.logManager().getLog(Router.class);
            l.log(50, "Shutting down the router...");
            this._context.router().shutdown(3);
        }
    }

    private static class MarkLiveliness
    implements Runnable {
        private RouterContext _context;
        private Router _router;
        private File _pingFile;

        public MarkLiveliness(RouterContext ctx, Router router, File pingFile) {
            this._context = ctx;
            this._router = router;
            this._pingFile = pingFile;
        }

        public void run() {
            this._pingFile.deleteOnExit();
            do {
                this.ping();
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (this._router.isAlive());
            this._pingFile.delete();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void ping() {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(this._pingFile);
                fos.write(("" + System.currentTimeMillis()).getBytes());
            }
            catch (IOException ioe) {
                System.err.println("Error writing to ping file");
                ioe.printStackTrace();
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private static class UpdateRoutingKeyModifierJob
    extends JobImpl {
        private Log _log;
        private Calendar _cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));

        public UpdateRoutingKeyModifierJob(RouterContext ctx) {
            super(ctx);
        }

        public String getName() {
            return "Update Routing Key Modifier";
        }

        public void runJob() {
            this._log = this.getContext().logManager().getLog(this.getClass());
            this.getContext().routingKeyGenerator().generateDateBasedModData();
            this.requeue(this.getTimeTillMidnight());
        }

        private long getTimeTillMidnight() {
            long now = this.getContext().clock().now();
            this._cal.setTime(new Date(now));
            this._cal.set(1, this._cal.get(1));
            this._cal.set(6, this._cal.get(6));
            this._cal.add(5, 1);
            this._cal.set(11, 0);
            this._cal.set(12, 0);
            this._cal.set(13, 0);
            this._cal.set(14, 0);
            long then = this._cal.getTime().getTime();
            long howLong = then - now;
            if (howLong < 0L) {
                howLong = 86400000L + howLong;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Time till midnight: " + howLong + "ms");
            }
            return howLong;
        }
    }

    private static class CoalesceStatsEvent
    implements SimpleTimer.TimedEvent {
        private RouterContext _ctx;

        public CoalesceStatsEvent(RouterContext ctx) {
            this._ctx = ctx;
            ctx.statManager().createRateStat("bw.receiveBps", "How fast we receive data (in KBps)", "Bandwidth", new long[]{60000L, 300000L, 3600000L});
            ctx.statManager().createRateStat("bw.sendBps", "How fast we send data (in KBps)", "Bandwidth", new long[]{60000L, 300000L, 3600000L});
            ctx.statManager().createRateStat("bw.sendRate", "Low level bandwidth send rate", "Bandwidth", new long[]{60000L, 300000L, 600000L, 3600000L});
            ctx.statManager().createRateStat("bw.recvRate", "Low level bandwidth receive rate", "Bandwidth", new long[]{60000L, 300000L, 600000L, 3600000L});
            ctx.statManager().createRateStat("router.activePeers", "How many peers we are actively talking with", "Throttle", new long[]{60000L, 300000L, 3600000L});
            ctx.statManager().createRateStat("router.activeSendPeers", "How many peers we've sent to this minute", "Throttle", new long[]{60000L, 300000L, 3600000L});
            ctx.statManager().createRateStat("router.highCapacityPeers", "How many high capacity peers we know", "Throttle", new long[]{300000L, 3600000L});
            ctx.statManager().createRateStat("router.fastPeers", "How many fast peers we know", "Throttle", new long[]{300000L, 3600000L});
            long max = Runtime.getRuntime().maxMemory() / 0x100000L;
            ctx.statManager().createRateStat("router.memoryUsed", "(Bytes) Max is " + max + "MB", "Router", new long[]{60000L});
        }

        private RouterContext getContext() {
            return this._ctx;
        }

        public void timeReached() {
            Rate rate;
            RateStat sendRate;
            Rate rate2;
            int active = this.getContext().commSystem().countActivePeers();
            this.getContext().statManager().addRateData("router.activePeers", (long)active, 60000L);
            int activeSend = this.getContext().commSystem().countActiveSendPeers();
            this.getContext().statManager().addRateData("router.activeSendPeers", (long)activeSend, 60000L);
            int fast = this.getContext().profileOrganizer().countFastPeers();
            this.getContext().statManager().addRateData("router.fastPeers", (long)fast, 60000L);
            int highCap = this.getContext().profileOrganizer().countHighCapacityPeers();
            this.getContext().statManager().addRateData("router.highCapacityPeers", (long)highCap, 60000L);
            this.getContext().statManager().addRateData("bw.sendRate", (long)this.getContext().bandwidthLimiter().getSendBps(), 0L);
            this.getContext().statManager().addRateData("bw.recvRate", (long)this.getContext().bandwidthLimiter().getReceiveBps(), 0L);
            long used = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            this.getContext().statManager().addRateData("router.memoryUsed", used, 0L);
            this.getContext().tunnelDispatcher().updateParticipatingStats(50000);
            this.getContext().statManager().coalesceStats();
            RateStat receiveRate = this.getContext().statManager().getRate("transport.receiveMessageSize");
            if (receiveRate != null && (rate2 = receiveRate.getRate(60000L)) != null) {
                double bytes = rate2.getLastTotalValue();
                double KBps = bytes * 1000.0 / ((double)rate2.getPeriod() * 1024.0);
                this.getContext().statManager().addRateData("bw.receiveBps", (long)KBps, 60000L);
            }
            if ((sendRate = this.getContext().statManager().getRate("transport.sendMessageSize")) != null && (rate = sendRate.getRate(60000L)) != null) {
                double bytes = rate.getLastTotalValue();
                double KBps = bytes * 1000.0 / ((double)rate.getPeriod() * 1024.0);
                this.getContext().statManager().addRateData("bw.sendBps", (long)KBps, 60000L);
            }
        }
    }

    private class GracefulShutdown
    implements Runnable {
        private GracefulShutdown() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Thread ie3;
                boolean shutdown;
                boolean bl = shutdown = null != Router.this._config.getProperty(Router.PROP_SHUTDOWN_IN_PROGRESS);
                if (shutdown) {
                    if (Router.this._gracefulExitCode == 3 || Router.this._gracefulExitCode == 4 || Router.this._context.tunnelManager().getParticipatingCount() <= 0) {
                        if (Router.this._gracefulExitCode == 3) {
                            Router.this._log.log(50, "Shutting down after a brief delay");
                        } else if (Router.this._gracefulExitCode == 4) {
                            Router.this._log.log(50, "Restarting after a brief delay");
                        } else {
                            Router.this._log.log(50, "Graceful shutdown progress - no more tunnels, safe to die");
                        }
                        try {
                            Thread thread = Thread.currentThread();
                            synchronized (thread) {
                                Thread.currentThread().wait(2000L);
                            }
                        }
                        catch (InterruptedException ie2) {
                            // empty catch block
                        }
                        Router.this.shutdown(Router.this._gracefulExitCode);
                        return;
                    }
                    try {
                        ie3 = Thread.currentThread();
                        synchronized (ie3) {
                            Thread.currentThread().wait(10000L);
                        }
                    }
                    catch (InterruptedException ie3) {}
                    continue;
                }
                try {
                    ie3 = Thread.currentThread();
                    synchronized (ie3) {
                        Thread.currentThread().wait();
                        continue;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    private class Republish
    implements SimpleTimer.TimedEvent {
        private Republish() {
        }

        public void timeReached() {
            try {
                Router.this._context.netDb().publish(Router.this.getRouterInfo());
            }
            catch (IllegalArgumentException iae) {
                Router.this._log.log(50, "Local router info is invalid?  rebuilding a new identity", (Throwable)iae);
                Router.this.rebuildNewIdentity();
            }
        }
    }
}

