/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import net.i2p.data.DataHelper;

class JobStats {
    private String _job;
    private volatile long _numRuns;
    private volatile long _totalTime;
    private volatile long _maxTime;
    private volatile long _minTime;
    private volatile long _totalPendingTime;
    private volatile long _maxPendingTime;
    private volatile long _minPendingTime;

    public JobStats(String name) {
        this._job = name;
        this._numRuns = 0L;
        this._totalTime = 0L;
        this._maxTime = -1L;
        this._minTime = -1L;
        this._totalPendingTime = 0L;
        this._maxPendingTime = -1L;
        this._minPendingTime = -1L;
    }

    public void jobRan(long runTime, long lag) {
        ++this._numRuns;
        this._totalTime += runTime;
        if (this._maxTime < 0L || runTime > this._maxTime) {
            this._maxTime = runTime;
        }
        if (this._minTime < 0L || runTime < this._minTime) {
            this._minTime = runTime;
        }
        this._totalPendingTime += lag;
        if (this._maxPendingTime < 0L || lag > this._maxPendingTime) {
            this._maxPendingTime = lag;
        }
        if (this._minPendingTime < 0L || lag < this._minPendingTime) {
            this._minPendingTime = lag;
        }
    }

    public String getName() {
        return this._job;
    }

    public long getRuns() {
        return this._numRuns;
    }

    public long getTotalTime() {
        return this._totalTime;
    }

    public long getMaxTime() {
        return this._maxTime;
    }

    public long getMinTime() {
        return this._minTime;
    }

    public long getAvgTime() {
        if (this._numRuns > 0L) {
            return this._totalTime / this._numRuns;
        }
        return 0L;
    }

    public long getTotalPendingTime() {
        return this._totalPendingTime;
    }

    public long getMaxPendingTime() {
        return this._maxPendingTime;
    }

    public long getMinPendingTime() {
        return this._minPendingTime;
    }

    public long getAvgPendingTime() {
        if (this._numRuns > 0L) {
            return this._totalPendingTime / this._numRuns;
        }
        return 0L;
    }

    public int hashCode() {
        return this._job.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof JobStats) {
            JobStats stats = (JobStats)obj;
            return DataHelper.eq((Object)this.getName(), (Object)stats.getName()) && this.getRuns() == stats.getRuns() && this.getTotalTime() == stats.getTotalTime() && this.getMaxTime() == stats.getMaxTime() && this.getMinTime() == stats.getMinTime();
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Over ").append(this.getRuns()).append(" runs, job <b>").append(this.getName()).append("</b> took ");
        buf.append(this.getTotalTime()).append("ms (").append(this.getAvgTime()).append("ms/").append(this.getMaxTime()).append("ms/");
        buf.append(this.getMinTime()).append("ms avg/max/min) after a total lag of ");
        buf.append(this.getTotalPendingTime()).append("ms (").append(this.getAvgPendingTime()).append("ms/");
        buf.append(this.getMaxPendingTime()).append("ms/").append(this.getMinPendingTime()).append("ms avg/max/min)");
        return buf.toString();
    }
}

