/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import net.i2p.data.DataHelper;
import net.i2p.router.Job;
import net.i2p.router.JobImpl;
import net.i2p.router.JobQueueRunner;
import net.i2p.router.JobStats;
import net.i2p.router.MessageHistory;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.HandleDatabaseLookupMessageJob;
import net.i2p.util.Clock;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

public class JobQueue {
    private Log _log;
    private RouterContext _context;
    private final HashMap _queueRunners;
    private static volatile int _runnerId = 0;
    private ArrayList _readyJobs;
    private ArrayList _timedJobs;
    private final SortedMap _jobStats;
    private int _maxRunners = 1;
    private QueuePumper _pumper;
    private boolean _allowParallelOperation;
    private boolean _alive;
    private final Object _jobLock;
    private static final int DEFAULT_MAX_RUNNERS = 1;
    private static final String PROP_MAX_RUNNERS = "router.maxJobRunners";
    private static final long MAX_LIMIT_UPDATE_DELAY = 60000L;
    private long _lagWarning = 5000L;
    private static final long DEFAULT_LAG_WARNING = 5000L;
    private static final String PROP_LAG_WARNING = "router.jobLagWarning";
    private long _lagFatal = 30000L;
    private static final long DEFAULT_LAG_FATAL = 30000L;
    private static final String PROP_LAG_FATAL = "router.jobLagFatal";
    private long _runWarning = 5000L;
    private static final long DEFAULT_RUN_WARNING = 5000L;
    private static final String PROP_RUN_WARNING = "router.jobRunWarning";
    private long _runFatal = 30000L;
    private static final long DEFAULT_RUN_FATAL = 30000L;
    private static final String PROP_RUN_FATAL = "router.jobRunFatal";
    private long _warmupTime = 600000L;
    private static final long DEFAULT_WARMUP_TIME = 600000L;
    private static final String PROP_WARMUM_TIME = "router.jobWarmupTime";
    private int _maxWaitingJobs = 100;
    private static final int DEFAULT_MAX_WAITING_JOBS = 100;
    private static final String PROP_MAX_WAITING_JOBS = "router.maxWaitingJobs";
    private final Object _runnerLock = new Object();

    public JobQueue(RouterContext context) {
        this._context = context;
        this._log = context.logManager().getLog(JobQueue.class);
        this._context.statManager().createRateStat("jobQueue.readyJobs", "How many ready and waiting jobs there are?", "JobQueue", new long[]{60000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("jobQueue.droppedJobs", "How many jobs do we drop due to insane overload?", "JobQueue", new long[]{60000L, 3600000L, 86400000L});
        this._alive = true;
        this._readyJobs = new ArrayList(16);
        this._timedJobs = new ArrayList(64);
        this._jobLock = new Object();
        this._queueRunners = new HashMap();
        this._jobStats = Collections.synchronizedSortedMap(new TreeMap());
        this._allowParallelOperation = false;
        this._pumper = new QueuePumper();
        I2PThread pumperThread = new I2PThread((Runnable)this._pumper);
        pumperThread.setDaemon(true);
        pumperThread.setName("QueuePumper");
        pumperThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJob(Job job) {
        if (job == null) {
            return;
        }
        if (job instanceof JobImpl) {
            ((JobImpl)job).addedToQueue();
        }
        long numReady = 0L;
        boolean alreadyExists = false;
        boolean dropped = false;
        Object object = this._jobLock;
        synchronized (object) {
            if (this._readyJobs.contains(job)) {
                alreadyExists = true;
            }
            numReady = this._readyJobs.size();
            if (!alreadyExists && this._timedJobs.contains(job)) {
                alreadyExists = true;
            }
            if (this.shouldDrop(job, numReady)) {
                job.dropped();
                dropped = true;
            } else if (!alreadyExists) {
                if (job.getTiming().getStartAfter() <= this._context.clock().now()) {
                    job.getTiming().setStartAfter(this._context.clock().now());
                    if (job instanceof JobImpl) {
                        ((JobImpl)job).madeReady();
                    }
                    this._readyJobs.add(job);
                } else {
                    this._timedJobs.add(job);
                }
            }
            this._jobLock.notifyAll();
        }
        this._context.statManager().addRateData("jobQueue.readyJobs", numReady, 0L);
        if (dropped) {
            this._context.statManager().addRateData("jobQueue.droppedJobs", 1L, 1L);
            if (this._log.shouldLog(30)) {
                this._log.warn("Dropping job due to overload!  # ready jobs: " + numReady + ": job = " + job);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJob(Job job) {
        Object object = this._jobLock;
        synchronized (object) {
            this._readyJobs.remove(job);
            this._timedJobs.remove(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timingUpdated() {
        Object object = this._jobLock;
        synchronized (object) {
            this._jobLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getReadyCount() {
        Object object = this._jobLock;
        synchronized (object) {
            return this._readyJobs.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaxLag() {
        Object object = this._jobLock;
        synchronized (object) {
            if (this._readyJobs.size() <= 0) {
                return 0L;
            }
            long startAfter = ((Job)this._readyJobs.get(0)).getTiming().getStartAfter();
            return this._context.clock().now() - startAfter;
        }
    }

    private boolean shouldDrop(Job job, long numReady) {
        if (this._maxWaitingJobs <= 0) {
            return false;
        }
        if (!this._allowParallelOperation) {
            return false;
        }
        Class<?> cls = job.getClass();
        return numReady > (long)this._maxWaitingJobs && cls == HandleDatabaseLookupMessageJob.class;
    }

    public void allowParallelOperation() {
        this._allowParallelOperation = true;
        this.runQueue(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() {
        Object object = this._jobLock;
        synchronized (object) {
            this._timedJobs.clear();
            this._readyJobs.clear();
            this._jobLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        this._alive = false;
        Object object = this._jobLock;
        synchronized (object) {
            this._jobLock.notifyAll();
        }
        if (this._log.shouldLog(30)) {
            int i;
            StringBuilder buf = new StringBuilder(1024);
            buf.append("current jobs: \n");
            for (JobQueueRunner runner : this._queueRunners.values()) {
                Job j = runner.getCurrentJob();
                buf.append("Runner ").append(runner.getRunnerId()).append(": ");
                if (j == null) {
                    buf.append("no current job ");
                } else {
                    buf.append(j.toString());
                    buf.append(" started ").append(this._context.clock().now() - j.getTiming().getActualStart());
                    buf.append("ms ago");
                }
                j = runner.getLastJob();
                if (j == null) {
                    buf.append("no last job");
                    continue;
                }
                buf.append(j.toString());
                buf.append(" started ").append(this._context.clock().now() - j.getTiming().getActualStart());
                buf.append("ms ago and finished ");
                buf.append(this._context.clock().now() - j.getTiming().getActualEnd());
                buf.append("ms ago");
            }
            buf.append("\nready jobs: ").append(this._readyJobs.size()).append("\n\t");
            for (i = 0; i < this._readyJobs.size(); ++i) {
                buf.append(this._readyJobs.get(i).toString()).append("\n\t");
            }
            buf.append("\n\ntimed jobs: ").append(this._timedJobs.size()).append("\n\t");
            for (i = 0; i < this._timedJobs.size(); ++i) {
                buf.append(this._timedJobs.get(i).toString()).append("\n\t");
            }
            this._log.log(30, buf.toString());
        }
    }

    boolean isAlive() {
        return this._alive;
    }

    public long getLastJobBegin() {
        long when = -1L;
        Iterator iter = this._queueRunners.values().iterator();
        while (iter.hasNext()) {
            long cur = ((JobQueueRunner)iter.next()).getLastBegin();
            if (cur <= when) continue;
            cur = when;
        }
        return when;
    }

    public long getLastJobEnd() {
        long when = -1L;
        Iterator iter = this._queueRunners.values().iterator();
        while (iter.hasNext()) {
            long cur = ((JobQueueRunner)iter.next()).getLastEnd();
            if (cur <= when) continue;
            cur = when;
        }
        return when;
    }

    public Job getLastJob() {
        Job j = null;
        long when = -1L;
        for (JobQueueRunner cur : this._queueRunners.values()) {
            if (cur.getLastBegin() <= when) continue;
            j = cur.getCurrentJob();
            when = cur.getLastBegin();
        }
        return j;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Job getNext() {
        while (this._alive) {
            try {
                Object object = this._jobLock;
                synchronized (object) {
                    if (this._readyJobs.size() > 0) {
                        return (Job)this._readyJobs.remove(0);
                    }
                    this._jobLock.wait();
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("No longer alive, returning null");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runQueue(int numThreads) {
        HashMap hashMap = this._queueRunners;
        synchronized (hashMap) {
            if (this._queueRunners.size() > 0 && !this._allowParallelOperation) {
                return;
            }
            if (this._queueRunners.size() < numThreads) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Increasing the number of queue runners from " + this._queueRunners.size() + " to " + numThreads);
                }
                for (int i = this._queueRunners.size(); i < numThreads; ++i) {
                    JobQueueRunner runner = new JobQueueRunner(this._context, i);
                    this._queueRunners.put(i, runner);
                    I2PThread t = new I2PThread((Runnable)runner);
                    t.setName("JobQueue" + _runnerId++);
                    t.setDaemon(false);
                    t.start();
                }
            } else if (this._queueRunners.size() == numThreads) {
                for (JobQueueRunner runner : this._queueRunners.values()) {
                    runner.startRunning();
                }
            }
        }
    }

    void removeRunner(int id) {
        this._queueRunners.remove(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateJobTimings(long delta) {
        Object object = this._jobLock;
        synchronized (object) {
            Job j;
            int i;
            for (i = 0; i < this._timedJobs.size(); ++i) {
                j = (Job)this._timedJobs.get(i);
                j.getTiming().offsetChanged(delta);
            }
            for (i = 0; i < this._readyJobs.size(); ++i) {
                j = (Job)this._readyJobs.get(i);
                j.getTiming().offsetChanged(delta);
            }
        }
        object = this._runnerLock;
        synchronized (object) {
            for (JobQueueRunner runner : this._queueRunners.values()) {
                Job job = runner.getCurrentJob();
                if (job == null) continue;
                job.getTiming().offsetChanged(delta);
            }
        }
    }

    void updateStats(Job job, long doStart, long origStartAfter, long duration) {
        if (this._context.router() == null) {
            return;
        }
        String key = job.getName();
        long lag = doStart - origStartAfter;
        MessageHistory hist = this._context.messageHistory();
        long uptime = this._context.router().getUptime();
        if (lag < 0L) {
            lag = 0L;
        }
        if (duration < 0L) {
            duration = 0L;
        }
        JobStats stats = null;
        if (!this._jobStats.containsKey(key)) {
            this._jobStats.put(key, new JobStats(key));
        }
        stats = (JobStats)this._jobStats.get(key);
        stats.jobRan(duration, lag);
        String dieMsg = null;
        if (lag > this._lagWarning) {
            dieMsg = "Lag too long for job " + job.getName() + " [" + lag + "ms and a run time of " + duration + "ms]";
        } else if (duration > this._runWarning) {
            dieMsg = "Job run too long for job " + job.getName() + " [" + lag + "ms lag and run time of " + duration + "ms]";
        }
        if (dieMsg != null) {
            if (this._log.shouldLog(30)) {
                this._log.warn(dieMsg);
            }
            if (hist != null) {
                hist.messageProcessingError(-1L, JobQueue.class.getName(), dieMsg);
            }
        }
        if (lag > this._lagFatal && uptime > this._warmupTime) {
            if (this._log.shouldLog(30)) {
                this._log.log(30, "The router is either incredibly overloaded or (more likely) there's an error.", (Throwable)new Exception("ttttooooo mmmuuuccccchhhh llllaaagggg"));
            }
            return;
        }
        if (uptime > this._warmupTime && duration > this._runFatal) {
            if (this._log.shouldLog(30)) {
                this._log.log(30, "The router is incredibly overloaded - either you have a 386, or (more likely) there's an error. ", (Throwable)new Exception("ttttooooo sssllloooowww"));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderStatusHTML(Writer out) throws IOException {
        Job j;
        int i;
        ArrayList readyJobs = null;
        ArrayList timedJobs = null;
        ArrayList<Job> activeJobs = new ArrayList<Job>(1);
        ArrayList<Job> justFinishedJobs = new ArrayList<Job>(4);
        out.flush();
        int[] states = null;
        int numRunners = 0;
        Object object = this._queueRunners;
        synchronized (object) {
            states = new int[this._queueRunners.size()];
            int i2 = 0;
            for (JobQueueRunner runner : this._queueRunners.values()) {
                states[i2] = runner.getState();
                Job job = runner.getCurrentJob();
                if (job != null) {
                    activeJobs.add(job);
                } else {
                    job = runner.getLastJob();
                    if (job != null) {
                        justFinishedJobs.add(job);
                    }
                }
                ++i2;
            }
            numRunners = this._queueRunners.size();
        }
        object = this._jobLock;
        synchronized (object) {
            readyJobs = new ArrayList(this._readyJobs);
            timedJobs = new ArrayList(this._timedJobs);
        }
        StringBuilder buf = new StringBuilder(32768);
        buf.append("<b><div class=\"joblog\"><h3>I2P Job Queue</h3><div class=\"wideload\">Job runners: ").append(numRunners);
        buf.append("</b><br>\n");
        long now = this._context.clock().now();
        buf.append("<hr><b>Active jobs: ").append(activeJobs.size()).append("</b><ol>\n");
        for (i = 0; i < activeJobs.size(); ++i) {
            j = (Job)activeJobs.get(i);
            buf.append("<li>[started ").append(DataHelper.formatDuration((long)(now - j.getTiming().getStartAfter()))).append(" ago]: ");
            buf.append(j.toString()).append("</li>\n");
        }
        buf.append("</ol>\n");
        buf.append("<hr><b>Just finished jobs: ").append(justFinishedJobs.size()).append("</b><ol>\n");
        for (i = 0; i < justFinishedJobs.size(); ++i) {
            j = (Job)justFinishedJobs.get(i);
            buf.append("<li>[finished ").append(DataHelper.formatDuration((long)(now - j.getTiming().getActualEnd()))).append(" ago]: ");
            buf.append(j.toString()).append("</li>\n");
        }
        buf.append("</ol>\n");
        buf.append("<hr><b>Ready/waiting jobs: ").append(readyJobs.size()).append("</b><ol>\n");
        for (i = 0; i < readyJobs.size(); ++i) {
            j = (Job)readyJobs.get(i);
            buf.append("<li>[waiting ");
            buf.append(DataHelper.formatDuration((long)(now - j.getTiming().getStartAfter())));
            buf.append("]: ");
            buf.append(j.toString()).append("</li>\n");
        }
        buf.append("</ol>\n");
        out.flush();
        buf.append("<hr><b>Scheduled jobs: ").append(timedJobs.size()).append("</b><ol>\n");
        TreeMap<Long, Job> ordered = new TreeMap<Long, Job>();
        for (int i3 = 0; i3 < timedJobs.size(); ++i3) {
            Job j2 = (Job)timedJobs.get(i3);
            ordered.put(new Long(j2.getTiming().getStartAfter()), j2);
        }
        for (Job j2 : ordered.values()) {
            long time = j2.getTiming().getStartAfter() - now;
            buf.append("<li>").append(j2.getName()).append(" in ");
            buf.append(DataHelper.formatDuration((long)time)).append("</li>\n");
        }
        buf.append("</ol></div>\n");
        out.flush();
        this.getJobStats(buf);
        out.flush();
        out.write(buf.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getJobStats(StringBuilder buf) {
        buf.append("<table>\n<tr><th>Job</th><th>Runs</th><th>Time</th><th><i>Avg</i></th><th><i>Max</i></th><th><i>Min</i></th><th>Pending</th><th><i>Avg</i></th><th><i>Max</i></th><th><i>Min</i></th></tr>\n");
        long totRuns = 0L;
        long totExecTime = 0L;
        long avgExecTime = 0L;
        long maxExecTime = -1L;
        long minExecTime = -1L;
        long totPendingTime = 0L;
        long avgPendingTime = 0L;
        long maxPendingTime = -1L;
        long minPendingTime = -1L;
        TreeMap tstats = null;
        SortedMap sortedMap = this._jobStats;
        synchronized (sortedMap) {
            tstats = new TreeMap(this._jobStats);
        }
        for (JobStats stats : tstats.values()) {
            buf.append("<tr>");
            buf.append("<td><b>").append(stats.getName()).append("</b></td>");
            buf.append("<td>").append(stats.getRuns()).append("</td>");
            buf.append("<td>").append(stats.getTotalTime()).append("</td>");
            buf.append("<td>").append(stats.getAvgTime()).append("</td>");
            buf.append("<td>").append(stats.getMaxTime()).append("</td>");
            buf.append("<td>").append(stats.getMinTime()).append("</td>");
            buf.append("<td>").append(stats.getTotalPendingTime()).append("</td>");
            buf.append("<td>").append(stats.getAvgPendingTime()).append("</td>");
            buf.append("<td>").append(stats.getMaxPendingTime()).append("</td>");
            buf.append("<td>").append(stats.getMinPendingTime()).append("</td>");
            buf.append("</tr>\n");
            totRuns += stats.getRuns();
            totExecTime += stats.getTotalTime();
            if (stats.getMaxTime() > maxExecTime) {
                maxExecTime = stats.getMaxTime();
            }
            if (minExecTime < 0L || minExecTime > stats.getMinTime()) {
                minExecTime = stats.getMinTime();
            }
            totPendingTime += stats.getTotalPendingTime();
            if (stats.getMaxPendingTime() > maxPendingTime) {
                maxPendingTime = stats.getMaxPendingTime();
            }
            if (minPendingTime >= 0L && minPendingTime <= stats.getMinPendingTime()) continue;
            minPendingTime = stats.getMinPendingTime();
        }
        if (totRuns != 0L) {
            if (totExecTime != 0L) {
                avgExecTime = totExecTime / totRuns;
            }
            if (totPendingTime != 0L) {
                avgPendingTime = totPendingTime / totRuns;
            }
        }
        buf.append("<tr class=\"tablefooter\">");
        buf.append("<td><b>").append("SUMMARY").append("</b></td>");
        buf.append("<td>").append(totRuns).append("</td>");
        buf.append("<td>").append(totExecTime).append("</td>");
        buf.append("<td>").append(avgExecTime).append("</td>");
        buf.append("<td>").append(maxExecTime).append("</td>");
        buf.append("<td>").append(minExecTime).append("</td>");
        buf.append("<td>").append(totPendingTime).append("</td>");
        buf.append("<td>").append(avgPendingTime).append("</td>");
        buf.append("<td>").append(maxPendingTime).append("</td>");
        buf.append("<td>").append(minPendingTime).append("</td>");
        buf.append("</tr></table></div>\n");
    }

    private final class QueuePumper
    implements Runnable,
    Clock.ClockUpdateListener {
        public QueuePumper() {
            JobQueue.this._context.clock().addUpdateListener((Clock.ClockUpdateListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block7: while (true) {
                try {
                    while (JobQueue.this._alive) {
                        long now = JobQueue.this._context.clock().now();
                        long timeToWait = -1L;
                        ArrayList<Job> toAdd = null;
                        try {
                            Object object = JobQueue.this._jobLock;
                            synchronized (object) {
                                int i;
                                for (i = 0; i < JobQueue.this._timedJobs.size(); ++i) {
                                    Job j = (Job)JobQueue.this._timedJobs.get(i);
                                    long timeLeft = j.getTiming().getStartAfter() - now;
                                    if (timeLeft <= 0L) {
                                        if (j instanceof JobImpl) {
                                            ((JobImpl)j).madeReady();
                                        }
                                        if (toAdd == null) {
                                            toAdd = new ArrayList<Job>(4);
                                        }
                                        toAdd.add(j);
                                        JobQueue.this._timedJobs.remove(i);
                                        --i;
                                        continue;
                                    }
                                    if (timeToWait > 0L && timeLeft >= timeToWait) continue;
                                    timeToWait = timeLeft;
                                }
                                if (toAdd != null) {
                                    if (JobQueue.this._log.shouldLog(10)) {
                                        JobQueue.this._log.debug("Not waiting - we have " + toAdd.size() + " newly ready jobs");
                                    }
                                    for (i = 0; i < toAdd.size(); ++i) {
                                        JobQueue.this._readyJobs.add(toAdd.get(i));
                                    }
                                    JobQueue.this._jobLock.notifyAll();
                                } else {
                                    if (timeToWait < 0L) {
                                        timeToWait = 30000L;
                                    } else if (timeToWait < 10L) {
                                        timeToWait = 10L;
                                    } else if (timeToWait > 10000L) {
                                        timeToWait = 10000L;
                                    }
                                    JobQueue.this._jobLock.wait(timeToWait);
                                }
                                continue block7;
                            }
                        }
                        catch (InterruptedException ie) {
                        }
                    }
                    break;
                }
                catch (Throwable t) {
                    JobQueue.this._context.clock().removeUpdateListener((Clock.ClockUpdateListener)this);
                    if (!JobQueue.this._log.shouldLog(40)) break;
                    JobQueue.this._log.error("wtf, pumper killed", t);
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void offsetChanged(long delta) {
            JobQueue.this.updateJobTimings(delta);
            Object object = JobQueue.this._jobLock;
            synchronized (object) {
                JobQueue.this._jobLock.notifyAll();
            }
        }
    }
}

