/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import net.i2p.router.Job;
import net.i2p.router.JobTiming;
import net.i2p.router.RouterContext;

public abstract class JobImpl
implements Job {
    private RouterContext _context;
    private JobTiming _timing;
    private static int _idSrc = 0;
    private int _id;
    private Exception _addedBy;
    private long _madeReadyOn;

    public JobImpl(RouterContext context) {
        this._context = context;
        this._timing = new JobTiming(context);
        this._id = ++_idSrc;
        this._addedBy = null;
        this._madeReadyOn = 0L;
    }

    public int getJobId() {
        return this._id;
    }

    public JobTiming getTiming() {
        return this._timing;
    }

    public final RouterContext getContext() {
        return this._context;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append(super.toString());
        buf.append(": Job ").append(this._id).append(": ").append(this.getName());
        return buf.toString();
    }

    void addedToQueue() {
        if (this._context.logManager().getLog(this.getClass()).shouldLog(10)) {
            this._addedBy = new Exception();
        }
    }

    public Exception getAddedBy() {
        return this._addedBy;
    }

    public long getMadeReadyOn() {
        return this._madeReadyOn;
    }

    public void madeReady() {
        this._madeReadyOn = this._context.clock().now();
    }

    public void dropped() {
    }

    protected void requeue(long delayMs) {
        this.getTiming().setStartAfter(this._context.clock().now() + delayMs);
        this._context.jobQueue().addJob(this);
    }
}

