/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import java.io.IOException;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.I2NPMessageImpl;
import net.i2p.util.Log;

public class TunnelCreateStatusMessage
extends I2NPMessageImpl {
    private static final Log _log = new Log(TunnelCreateStatusMessage.class);
    public static final int MESSAGE_TYPE = 7;
    private TunnelId _receiveTunnelId;
    private int _status;
    private long _nonce;
    public static final int STATUS_SUCCESS = 0;

    public TunnelCreateStatusMessage(I2PAppContext context) {
        super(context);
        this.setReceiveTunnelId(null);
        this.setStatus(-1);
        this.setNonce(-1L);
    }

    public TunnelId getReceiveTunnelId() {
        return this._receiveTunnelId;
    }

    public void setReceiveTunnelId(TunnelId id) {
        this._receiveTunnelId = id;
        if (id != null && id.getTunnelId() <= 0L) {
            throw new IllegalArgumentException("wtf, tunnelId " + id);
        }
    }

    public int getStatus() {
        return this._status;
    }

    public void setStatus(int status) {
        this._status = status;
    }

    public long getNonce() {
        return this._nonce;
    }

    public void setNonce(long nonce) {
        this._nonce = nonce;
    }

    public void readMessage(byte[] data, int offset, int dataSize, int type) throws I2NPMessageException, IOException {
        if (type != 7) {
            throw new I2NPMessageException("Message type is incorrect for this message");
        }
        int curIndex = offset;
        this._receiveTunnelId = new TunnelId(DataHelper.fromLong((byte[])data, (int)curIndex, (int)4));
        curIndex += 4;
        if (this._receiveTunnelId.getTunnelId() <= 0L) {
            throw new I2NPMessageException("wtf, negative tunnelId? " + this._receiveTunnelId);
        }
        this._status = (int)DataHelper.fromLong((byte[])data, (int)curIndex, (int)1);
        this._nonce = DataHelper.fromLong((byte[])data, (int)(++curIndex), (int)4);
    }

    protected int calculateWrittenLength() {
        return 9;
    }

    protected int writeMessageBody(byte[] out, int curIndex) throws I2NPMessageException {
        if (this._receiveTunnelId == null || this._nonce <= 0L) {
            throw new I2NPMessageException("Not enough data to write out");
        }
        if (this._receiveTunnelId.getTunnelId() <= 0L) {
            throw new I2NPMessageException("Invalid tunnelId!? " + this._receiveTunnelId);
        }
        DataHelper.toLong((byte[])out, (int)curIndex, (int)4, (long)this._receiveTunnelId.getTunnelId());
        DataHelper.toLong((byte[])out, (int)(curIndex += 4), (int)1, (long)this._status);
        DataHelper.toLong((byte[])out, (int)(++curIndex), (int)4, (long)this._nonce);
        return curIndex += 4;
    }

    public int getType() {
        return 7;
    }

    public int hashCode() {
        return DataHelper.hashCode((Object)this.getReceiveTunnelId()) + this.getStatus() + (int)this.getNonce();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof TunnelCreateStatusMessage) {
            TunnelCreateStatusMessage msg = (TunnelCreateStatusMessage)object;
            return DataHelper.eq((Object)this.getReceiveTunnelId(), (Object)msg.getReceiveTunnelId()) && DataHelper.eq((long)this.getNonce(), (long)msg.getNonce()) && this.getStatus() == msg.getStatus();
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[TunnelCreateStatusMessage: ");
        buf.append("\n\tTunnel ID: ").append(this.getReceiveTunnelId());
        buf.append("\n\tStatus: ").append(this.getStatus());
        buf.append("\n\tNonce: ").append(this.getNonce());
        buf.append("]");
        return buf.toString();
    }
}

