/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import net.i2p.I2PAppContext;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;
import net.i2p.data.Hash;
import net.i2p.data.i2np.DataMessage;
import net.i2p.data.i2np.DatabaseLookupMessage;
import net.i2p.data.i2np.DatabaseSearchReplyMessage;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.DateMessage;
import net.i2p.data.i2np.DeliveryStatusMessage;
import net.i2p.data.i2np.GarlicMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.I2NPMessageHandler;
import net.i2p.data.i2np.TunnelBuildMessage;
import net.i2p.data.i2np.TunnelBuildReplyMessage;
import net.i2p.data.i2np.TunnelCreateMessage;
import net.i2p.data.i2np.TunnelCreateStatusMessage;
import net.i2p.data.i2np.TunnelDataMessage;
import net.i2p.data.i2np.TunnelGatewayMessage;
import net.i2p.util.Log;

public abstract class I2NPMessageImpl
extends DataStructureImpl
implements I2NPMessage {
    private Log _log;
    protected I2PAppContext _context;
    private long _expiration;
    private long _uniqueId;
    private boolean _written;
    private boolean _read;
    public static final long DEFAULT_EXPIRATION_MS = 60000L;
    public static final int CHECKSUM_LENGTH = 1;
    private static final boolean RAW_FULL_SIZE = false;
    private static final Map _builders = new HashMap(8);

    public static final void registerBuilder(Builder builder, int type) {
        _builders.put(type, builder);
    }

    public I2NPMessageImpl(I2PAppContext context) {
        this._context = context;
        this._log = context.logManager().getLog(I2NPMessageImpl.class);
        this._expiration = this._context.clock().now() + 60000L;
        this._uniqueId = this._context.random().nextLong(0xFFFFFFFFL);
        this._written = false;
        this._read = false;
    }

    public void readBytes(InputStream in) throws DataFormatException, IOException {
        try {
            this.readBytes(in, -1, new byte[1024]);
        }
        catch (I2NPMessageException ime) {
            throw new DataFormatException("Bad bytes", (Throwable)((Object)ime));
        }
    }

    public int readBytes(InputStream in, int type, byte[] buffer) throws I2NPMessageException, IOException {
        try {
            int numRead;
            if (type < 0) {
                type = (int)DataHelper.readLong((InputStream)in, (int)1);
            }
            this._uniqueId = DataHelper.readLong((InputStream)in, (int)4);
            this._expiration = DataHelper.readLong((InputStream)in, (int)8);
            int size = (int)DataHelper.readLong((InputStream)in, (int)2);
            byte[] checksum = new byte[1];
            int read = DataHelper.read((InputStream)in, (byte[])checksum);
            if (read != 1) {
                throw new I2NPMessageException("checksum is too small [" + read + "]");
            }
            if (buffer.length < size) {
                if (size > 65536) {
                    throw new I2NPMessageException("size=" + size);
                }
                buffer = new byte[size];
            }
            for (int cur = 0; cur < size; cur += numRead) {
                numRead = in.read(buffer, cur, size - cur);
                if (numRead != -1) continue;
                throw new I2NPMessageException("Payload is too short [" + numRead + ", wanted " + size + "]");
            }
            Hash calc = this._context.sha().calculateHash(buffer, 0, size);
            boolean eq = DataHelper.eq((byte[])checksum, (int)0, (byte[])calc.getData(), (int)0, (int)1);
            if (!eq) {
                throw new I2NPMessageException("Hash does not match for " + this.getClass().getName());
            }
            long start = this._context.clock().now();
            if (this._log.shouldLog(10)) {
                this._log.debug("Reading bytes: type = " + type + " / uniqueId : " + this._uniqueId + " / expiration : " + this._expiration);
            }
            this.readMessage(buffer, 0, size, type);
            this._read = true;
            return size + 32 + 1 + 4 + 8;
        }
        catch (DataFormatException dfe) {
            throw new I2NPMessageException("Error reading the message header", dfe);
        }
    }

    public int readBytes(byte[] data, int type, int offset) throws I2NPMessageException, IOException {
        int cur = offset;
        if (type < 0) {
            type = (int)DataHelper.fromLong((byte[])data, (int)cur, (int)1);
            ++cur;
        }
        this._uniqueId = DataHelper.fromLong((byte[])data, (int)cur, (int)4);
        this._expiration = DataHelper.fromLong((byte[])data, (int)(cur += 4), (int)8);
        int size = (int)DataHelper.fromLong((byte[])data, (int)(cur += 8), (int)2);
        byte[] hdata = new byte[1];
        System.arraycopy(data, cur += 2, hdata, 0, 1);
        if (++cur + size > data.length) {
            throw new I2NPMessageException("Payload is too short [data.len=" + data.length + " offset=" + offset + " cur=" + cur + " wanted=" + size + "]: " + this.getClass().getName());
        }
        Hash calc = this._context.sha().calculateHash(data, cur, size);
        boolean eq = DataHelper.eq((byte[])hdata, (int)0, (byte[])calc.getData(), (int)0, (int)1);
        if (!eq) {
            throw new I2NPMessageException("Hash does not match for " + this.getClass().getName());
        }
        long start = this._context.clock().now();
        if (this._log.shouldLog(10)) {
            this._log.debug("Reading bytes: type = " + type + " / uniqueId : " + this._uniqueId + " / expiration : " + this._expiration);
        }
        this.readMessage(data, cur, size, type);
        this._read = true;
        return (cur += size) - offset;
    }

    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        int size = this.getMessageSize();
        if (size < 16) {
            throw new DataFormatException("Unable to build the message");
        }
        byte[] buf = new byte[size];
        int read = this.toByteArray(buf);
        if (read < 0) {
            throw new DataFormatException("Unable to build the message");
        }
        out.write(buf, 0, read);
    }

    public long getUniqueId() {
        return this._uniqueId;
    }

    public void setUniqueId(long id) {
        this._uniqueId = id;
    }

    public long getMessageExpiration() {
        return this._expiration;
    }

    public void setMessageExpiration(long exp) {
        this._expiration = exp;
    }

    public synchronized int getMessageSize() {
        return this.calculateWrittenLength() + 15 + 1;
    }

    public synchronized int getRawMessageSize() {
        return this.calculateWrittenLength() + 5;
    }

    public byte[] toByteArray() {
        byte[] data = new byte[this.getMessageSize()];
        int written = this.toByteArray(data);
        if (written != data.length) {
            this._log.log(50, "Error writing out " + data.length + " (written: " + written + ", msgSize: " + this.getMessageSize() + ", writtenLen: " + this.calculateWrittenLength() + ") for " + this.getClass().getName());
            return null;
        }
        return data;
    }

    public int toByteArray(byte[] buffer) {
        long start = this._context.clock().now();
        int prefixLen = 16;
        try {
            int writtenLen = this.writeMessageBody(buffer, prefixLen);
            int payloadLen = writtenLen - prefixLen;
            Hash h = this._context.sha().calculateHash(buffer, prefixLen, payloadLen);
            int off = 0;
            DataHelper.toLong((byte[])buffer, (int)off, (int)1, (long)this.getType());
            DataHelper.toLong((byte[])buffer, (int)(++off), (int)4, (long)this._uniqueId);
            DataHelper.toLong((byte[])buffer, (int)(off += 4), (int)8, (long)this._expiration);
            DataHelper.toLong((byte[])buffer, (int)(off += 8), (int)2, (long)payloadLen);
            System.arraycopy(h.getData(), 0, buffer, off += 2, 1);
            return writtenLen;
        }
        catch (I2NPMessageException ime) {
            this._context.logManager().getLog(this.getClass()).log(50, "Error writing", (Throwable)((Object)ime));
            throw new IllegalStateException("Unable to serialize the message (" + this.getClass().getName() + "): " + ime.getMessage());
        }
    }

    protected abstract int calculateWrittenLength();

    protected abstract int writeMessageBody(byte[] var1, int var2) throws I2NPMessageException;

    public int toRawByteArray(byte[] buffer) {
        this.verifyUnwritten();
        try {
            int off = 0;
            DataHelper.toLong((byte[])buffer, (int)off, (int)1, (long)this.getType());
            DataHelper.toLong((byte[])buffer, (int)(++off), (int)4, (long)(this._expiration / 1000L));
            int n = this.writeMessageBody(buffer, off += 4);
            return n;
        }
        catch (I2NPMessageException ime) {
            this._context.logManager().getLog(this.getClass()).log(50, "Error writing", (Throwable)((Object)ime));
            throw new IllegalStateException("Unable to serialize the message (" + this.getClass().getName() + "): " + ime.getMessage());
        }
        finally {
            this.written();
        }
    }

    public void readMessage(byte[] data, int offset, int dataSize, int type, I2NPMessageHandler handler) throws I2NPMessageException, IOException {
        try {
            this.readMessage(data, offset, dataSize, type);
        }
        catch (IllegalArgumentException iae) {
            throw new I2NPMessageException("Error reading the message", iae);
        }
    }

    public static I2NPMessage fromRawByteArray(I2PAppContext ctx, byte[] buffer, int offset, int len) throws I2NPMessageException {
        return I2NPMessageImpl.fromRawByteArray(ctx, buffer, offset, len, new I2NPMessageHandler(ctx));
    }

    public static I2NPMessage fromRawByteArray(I2PAppContext ctx, byte[] buffer, int offset, int len, I2NPMessageHandler handler) throws I2NPMessageException {
        int type = (int)DataHelper.fromLong((byte[])buffer, (int)offset, (int)1);
        ++offset;
        I2NPMessageImpl msg = (I2NPMessageImpl)I2NPMessageImpl.createMessage(ctx, type);
        if (msg == null) {
            throw new I2NPMessageException("Unknown message type: " + type);
        }
        try {
            long expiration = DataHelper.fromLong((byte[])buffer, (int)offset, (int)4) * 1000L;
            int dataSize = len - 1 - 4;
            msg.readMessage(buffer, offset += 4, dataSize, type, handler);
            msg.setMessageExpiration(expiration);
            msg.read();
            return msg;
        }
        catch (IOException ioe) {
            throw new I2NPMessageException("IO error reading raw message", ioe);
        }
        catch (IllegalArgumentException iae) {
            throw new I2NPMessageException("Corrupt message (negative expiration)", iae);
        }
    }

    protected void verifyUnwritten() {
        if (this._written) {
            throw new IllegalStateException("Already written");
        }
    }

    protected void written() {
        this._written = true;
    }

    protected void read() {
        this._read = true;
    }

    public static I2NPMessage createMessage(I2PAppContext context, int type) throws I2NPMessageException {
        switch (type) {
            case 1: {
                return new DatabaseStoreMessage(context);
            }
            case 2: {
                return new DatabaseLookupMessage(context);
            }
            case 3: {
                return new DatabaseSearchReplyMessage(context);
            }
            case 10: {
                return new DeliveryStatusMessage(context);
            }
            case 16: {
                return new DateMessage(context);
            }
            case 11: {
                return new GarlicMessage(context);
            }
            case 18: {
                return new TunnelDataMessage(context);
            }
            case 19: {
                return new TunnelGatewayMessage(context);
            }
            case 20: {
                return new DataMessage(context);
            }
            case 6: {
                return new TunnelCreateMessage(context);
            }
            case 7: {
                return new TunnelCreateStatusMessage(context);
            }
            case 21: {
                return new TunnelBuildMessage(context);
            }
            case 22: {
                return new TunnelBuildReplyMessage(context);
            }
        }
        Builder builder = (Builder)_builders.get(type);
        if (builder == null) {
            return null;
        }
        return builder.build(context);
    }

    public static interface Builder {
        public I2NPMessage build(I2PAppContext var1);
    }
}

