/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import java.io.IOException;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.I2NPMessageImpl;
import net.i2p.util.Log;

public class DeliveryStatusMessage
extends I2NPMessageImpl {
    private static final Log _log = new Log(DeliveryStatusMessage.class);
    public static final int MESSAGE_TYPE = 10;
    private long _id;
    private long _arrival;

    public DeliveryStatusMessage(I2PAppContext context) {
        super(context);
        this.setMessageId(-1L);
        this.setArrival(-1L);
    }

    public long getMessageId() {
        return this._id;
    }

    public void setMessageId(long id) {
        this._id = id;
    }

    public long getArrival() {
        return this._arrival;
    }

    public void setArrival(long arrival) {
        this._arrival = arrival;
    }

    public void readMessage(byte[] data, int offset, int dataSize, int type) throws I2NPMessageException, IOException {
        if (type != 10) {
            throw new I2NPMessageException("Message type is incorrect for this message");
        }
        int curIndex = offset;
        this._id = DataHelper.fromLong((byte[])data, (int)curIndex, (int)4);
        this._arrival = DataHelper.fromLong((byte[])data, (int)(curIndex += 4), (int)8);
    }

    protected int calculateWrittenLength() {
        return 12;
    }

    protected int writeMessageBody(byte[] out, int curIndex) throws I2NPMessageException {
        if (this._id < 0L || this._arrival <= 0L) {
            throw new I2NPMessageException("Not enough data to write out");
        }
        DataHelper.toLong((byte[])out, (int)curIndex, (int)4, (long)this._id);
        DataHelper.toLong((byte[])out, (int)(curIndex += 4), (int)8, (long)this._arrival);
        return curIndex += 8;
    }

    public int getType() {
        return 10;
    }

    public int hashCode() {
        return (int)this.getMessageId() + (int)this.getArrival();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof DeliveryStatusMessage) {
            DeliveryStatusMessage msg = (DeliveryStatusMessage)object;
            return DataHelper.eq((long)this.getMessageId(), (long)msg.getMessageId()) && DataHelper.eq((long)this.getArrival(), (long)msg.getArrival());
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[DeliveryStatusMessage: ");
        buf.append("\n\tMessage ID: ").append(this.getMessageId());
        buf.append("\n\tArrival: ").append(this._context.clock().now() - this._arrival);
        buf.append("ms in the past");
        buf.append("]");
        return buf.toString();
    }
}

