/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.i2p.I2PAppContext;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;

public class SimpleScheduler {
    private static final SimpleScheduler _instance = new SimpleScheduler();
    private static final int THREADS = 4;
    private I2PAppContext _context = I2PAppContext.getGlobalContext();
    private Log _log = this._context.logManager().getLog(SimpleScheduler.class);
    private ScheduledThreadPoolExecutor _executor;
    private String _name;
    private int _count;

    public static SimpleScheduler getInstance() {
        return _instance;
    }

    protected SimpleScheduler() {
        this("SimpleScheduler");
    }

    protected SimpleScheduler(String name) {
        this._name = name;
        this._count = 0;
        this._executor = new ScheduledThreadPoolExecutor(4, new CustomThreadFactory());
        this._executor.prestartAllCoreThreads();
    }

    public void stop() {
        this._executor.shutdownNow();
    }

    public void addEvent(SimpleTimer.TimedEvent event, long timeoutMs) {
        if (event == null) {
            throw new IllegalArgumentException("addEvent null");
        }
        RunnableEvent re = new RunnableEvent(event, timeoutMs);
        re.schedule();
    }

    public void addPeriodicEvent(SimpleTimer.TimedEvent event, long timeoutMs) {
        this.addPeriodicEvent(event, timeoutMs, timeoutMs);
    }

    public void addPeriodicEvent(SimpleTimer.TimedEvent event, long initialDelay, long timeoutMs) {
        if (event == null) {
            throw new IllegalArgumentException("addEvent null");
        }
        PeriodicRunnableEvent re = new PeriodicRunnableEvent(event, initialDelay, timeoutMs);
        ((RunnableEvent)re).schedule();
    }

    private String debug() {
        return " Pool: " + this._name + " Active: " + this._executor.getActiveCount() + '/' + this._executor.getPoolSize() + " Completed: " + this._executor.getCompletedTaskCount() + " Queued: " + this._executor.getQueue().size();
    }

    private class PeriodicRunnableEvent
    extends RunnableEvent {
        private long _timeoutMs;
        private long _initialDelay;

        public PeriodicRunnableEvent(SimpleTimer.TimedEvent t, long initialDelay, long timeoutMs) {
            super(t, timeoutMs);
            this._initialDelay = initialDelay;
            this._timeoutMs = timeoutMs;
            this._scheduled = initialDelay + System.currentTimeMillis();
        }

        public void schedule() {
            SimpleScheduler.this._executor.scheduleWithFixedDelay(this, this._initialDelay, this._timeoutMs, TimeUnit.MILLISECONDS);
        }

        public void run() {
            super.run();
            this._scheduled = this._timeoutMs + System.currentTimeMillis();
        }
    }

    private class RunnableEvent
    implements Runnable {
        protected SimpleTimer.TimedEvent _timedEvent;
        protected long _scheduled;

        public RunnableEvent(SimpleTimer.TimedEvent t, long timeoutMs) {
            if (SimpleScheduler.this._log.shouldLog(10)) {
                SimpleScheduler.this._log.debug("Creating w/ delay " + timeoutMs + " : " + t);
            }
            this._timedEvent = t;
            this._scheduled = timeoutMs + System.currentTimeMillis();
        }

        public void schedule() {
            SimpleScheduler.this._executor.schedule(this, this._scheduled - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        public void run() {
            if (SimpleScheduler.this._log.shouldLog(10)) {
                SimpleScheduler.this._log.debug("Running: " + this._timedEvent);
            }
            long before = System.currentTimeMillis();
            if (SimpleScheduler.this._log.shouldLog(30) && before < this._scheduled - 100L) {
                SimpleScheduler.this._log.warn(SimpleScheduler.this._name + " wtf, early execution " + (this._scheduled - before) + ": " + this._timedEvent);
            } else if (SimpleScheduler.this._log.shouldLog(30) && before > this._scheduled + 1000L) {
                SimpleScheduler.this._log.warn(" wtf, late execution " + (before - this._scheduled) + ": " + this._timedEvent + SimpleScheduler.this.debug());
            }
            try {
                this._timedEvent.timeReached();
            }
            catch (Throwable t) {
                SimpleScheduler.this._log.log(50, SimpleScheduler.this._name + " wtf, event borked: " + this._timedEvent, t);
            }
            long time = System.currentTimeMillis() - before;
            if (time > 1000L && SimpleScheduler.this._log.shouldLog(30)) {
                SimpleScheduler.this._log.warn(SimpleScheduler.this._name + " wtf, event execution took " + time + ": " + this._timedEvent);
            }
            long completed = SimpleScheduler.this._executor.getCompletedTaskCount();
            if (SimpleScheduler.this._log.shouldLog(20) && completed % 250L == 0L) {
                SimpleScheduler.this._log.info(SimpleScheduler.this.debug());
            }
        }
    }

    private class CustomThreadFactory
    implements ThreadFactory {
        private CustomThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            Thread rv = Executors.defaultThreadFactory().newThread(r);
            rv.setName(SimpleScheduler.this._name + ' ' + ++SimpleScheduler.this._count + '/' + 4);
            rv.setDaemon(true);
            return rv;
        }
    }
}

