/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2cp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.i2cp.AbuseReason;
import net.i2p.data.i2cp.AbuseSeverity;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.I2CPMessageImpl;
import net.i2p.data.i2cp.MessageId;
import net.i2p.data.i2cp.SessionId;
import net.i2p.util.Log;

public class ReportAbuseMessage
extends I2CPMessageImpl {
    private static final Log _log = new Log(ReportAbuseMessage.class);
    public static final int MESSAGE_TYPE = 29;
    private SessionId _sessionId;
    private AbuseSeverity _severity;
    private AbuseReason _reason;
    private MessageId _messageId;

    public ReportAbuseMessage() {
        this.setSessionId(null);
        this.setSeverity(null);
        this.setReason(null);
        this.setMessageId(null);
    }

    public SessionId getSessionId() {
        return this._sessionId;
    }

    public void setSessionId(SessionId id) {
        this._sessionId = id;
    }

    public AbuseSeverity getSeverity() {
        return this._severity;
    }

    public void setSeverity(AbuseSeverity severity) {
        this._severity = severity;
    }

    public AbuseReason getReason() {
        return this._reason;
    }

    public void setReason(AbuseReason reason) {
        this._reason = reason;
    }

    public MessageId getMessageId() {
        return this._messageId;
    }

    public void setMessageId(MessageId id) {
        this._messageId = id;
    }

    protected void doReadMessage(InputStream in, int size) throws I2CPMessageException, IOException {
        try {
            this._sessionId = new SessionId();
            this._sessionId.readBytes(in);
            this._severity = new AbuseSeverity();
            this._severity.readBytes(in);
            this._reason = new AbuseReason();
            this._reason.readBytes(in);
            this._messageId = new MessageId();
            this._messageId.readBytes(in);
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Unable to load the message data", dfe);
        }
    }

    protected byte[] doWriteMessage() throws I2CPMessageException, IOException {
        if (this._sessionId == null || this._severity == null || this._reason == null) {
            throw new I2CPMessageException("Not enough information to construct the message");
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream(32);
        try {
            this._sessionId.writeBytes(os);
            this._severity.writeBytes(os);
            this._reason.writeBytes(os);
            if (this._messageId == null) {
                this._messageId = new MessageId();
                this._messageId.setMessageId(0L);
            }
            this._messageId.writeBytes(os);
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Error writing out the message data", dfe);
        }
        return os.toByteArray();
    }

    public int getType() {
        return 29;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof ReportAbuseMessage) {
            ReportAbuseMessage msg = (ReportAbuseMessage)object;
            return DataHelper.eq(this.getSessionId(), msg.getSessionId()) && DataHelper.eq(this.getSeverity(), msg.getSeverity()) && DataHelper.eq(this.getReason(), msg.getReason()) && DataHelper.eq(this.getMessageId(), msg.getMessageId());
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[ReportAbuseMessage: ");
        buf.append("\n\tSessionID: ").append(this.getSessionId());
        buf.append("\n\tSeverity: ").append(this.getSeverity());
        buf.append("\n\tReason: ").append(this.getReason());
        buf.append("\n\tMessageId: ").append(this.getMessageId());
        buf.append("]");
        return buf.toString();
    }
}

