/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2cp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Payload;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.I2CPMessageImpl;
import net.i2p.util.Log;

public class MessagePayloadMessage
extends I2CPMessageImpl {
    private static final Log _log = new Log(MessagePayloadMessage.class);
    public static final int MESSAGE_TYPE = 31;
    private long _sessionId;
    private long _messageId;
    private Payload _payload;

    public MessagePayloadMessage() {
        this.setSessionId(-1L);
        this.setMessageId(-1L);
        this.setPayload(null);
    }

    public long getSessionId() {
        return this._sessionId;
    }

    public void setSessionId(long id) {
        this._sessionId = id;
    }

    public long getMessageId() {
        return this._messageId;
    }

    public void setMessageId(long id) {
        this._messageId = id;
    }

    public Payload getPayload() {
        return this._payload;
    }

    public void setPayload(Payload payload) {
        this._payload = payload;
    }

    protected void doReadMessage(InputStream in, int size) throws I2CPMessageException, IOException {
        try {
            this._sessionId = DataHelper.readLong(in, 2);
            this._messageId = DataHelper.readLong(in, 4);
            this._payload = new Payload();
            this._payload.readBytes(in);
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Unable to load the message data", dfe);
        }
    }

    protected byte[] doWriteMessage() throws I2CPMessageException, IOException {
        throw new RuntimeException("go away, we dont want any");
    }

    public void writeMessage(OutputStream out) throws I2CPMessageException, IOException {
        if (this._sessionId <= 0L) {
            throw new I2CPMessageException("Unable to write out the message, as the session ID has not been defined");
        }
        if (this._messageId < 0L) {
            throw new I2CPMessageException("Unable to write out the message, as the message ID has not been defined");
        }
        if (this._payload == null) {
            throw new I2CPMessageException("Unable to write out the message, as the payload has not been defined");
        }
        int size = 10 + this._payload.getSize();
        try {
            DataHelper.writeLong(out, 4, size);
            DataHelper.writeLong(out, 1, this.getType());
            DataHelper.writeLong(out, 2, this._sessionId);
            DataHelper.writeLong(out, 4, this._messageId);
            DataHelper.writeLong(out, 4, this._payload.getSize());
            out.write(this._payload.getEncryptedData());
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Unable to write the message length or type", dfe);
        }
    }

    public int getType() {
        return 31;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof MessagePayloadMessage) {
            MessagePayloadMessage msg = (MessagePayloadMessage)object;
            return DataHelper.eq(this.getSessionId(), msg.getSessionId()) && DataHelper.eq(this.getMessageId(), msg.getMessageId()) && DataHelper.eq(this.getPayload(), msg.getPayload());
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[MessagePayloadMessage: ");
        buf.append("\n\tSessionId: ").append(this.getSessionId());
        buf.append("\n\tMessageId: ").append(this.getMessageId());
        buf.append("\n\tPayload: ").append(this.getPayload());
        buf.append("]");
        return buf.toString();
    }
}

