/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2cp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.I2CPMessageImpl;

public class DestReplyMessage
extends I2CPMessageImpl {
    public static final int MESSAGE_TYPE = 35;
    private Destination _dest;

    public DestReplyMessage() {
    }

    public DestReplyMessage(Destination d) {
        this._dest = d;
    }

    public Destination getDestination() {
        return this._dest;
    }

    protected void doReadMessage(InputStream in, int size) throws I2CPMessageException, IOException {
        try {
            Destination d = new Destination();
            d.readBytes(in);
            this._dest = d;
        }
        catch (DataFormatException dfe) {
            this._dest = null;
        }
    }

    protected byte[] doWriteMessage() throws I2CPMessageException, IOException {
        if (this._dest == null) {
            return new byte[0];
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream(this._dest.size());
        try {
            this._dest.writeBytes(os);
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Error writing out the dest", dfe);
        }
        return os.toByteArray();
    }

    public int getType() {
        return 35;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof DestReplyMessage) {
            DestReplyMessage msg = (DestReplyMessage)object;
            return DataHelper.eq(this.getDestination(), msg.getDestination());
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[DestReplyMessage: ");
        buf.append("\n\tDestination: ").append(this._dest);
        buf.append("]");
        return buf.toString();
    }
}

