/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import com.nettgryppa.security.HashCash;
import java.security.NoSuchAlgorithmException;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.util.Log;

public class VerifiedDestination
extends Destination {
    protected static final Log _log = new Log(Destination.class);
    public static final int MIN_HASHCASH_EFFORT = 20;
    public static final int CERTIFICATE_LENGTH_SIGNED = 40;
    public static final int CERTIFICATE_LENGTH_SIGNED_WITH_HASH = 72;

    public VerifiedDestination() {
    }

    public VerifiedDestination(String s) throws DataFormatException {
        this();
        this.fromBase64(s);
    }

    public VerifiedDestination(Destination d) throws DataFormatException {
        this(d.toBase64());
    }

    public boolean verifyCert(boolean allowNone) {
        if (this._publicKey == null || this._signingKey == null || this._certificate == null) {
            return false;
        }
        switch (this._certificate.getCertificateType()) {
            case 0: 
            case 2: {
                return allowNone;
            }
            case 1: {
                return this.verifyHashCashCert();
            }
            case 3: {
                return this.verifySignedCert();
            }
        }
        return this.verifyUnknownCert();
    }

    protected boolean verifyHashCashCert() {
        HashCash hc;
        String hcs = new String(this._certificate.getPayload());
        int end1 = 0;
        for (int i = 0; i < 3; ++i) {
            if ((end1 = 1 + hcs.indexOf(58, end1)) >= 0) continue;
            return false;
        }
        int start2 = hcs.indexOf(58, end1);
        if (start2 < 0) {
            return false;
        }
        hcs = hcs.substring(0, end1) + this._publicKey.toBase64() + this._signingKey.toBase64() + hcs.substring(start2);
        try {
            hc = new HashCash(hcs);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
        catch (NoSuchAlgorithmException nsae) {
            return false;
        }
        return hc.getValue() >= 20;
    }

    protected boolean verifySignedCert() {
        return this._certificate.getPayload() != null && (this._certificate.getPayload().length == 40 || this._certificate.getPayload().length == 72);
    }

    protected boolean verifyUnknownCert() {
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append(super.toString());
        buf.append("\n\tVerified Certificate? ").append(this.verifyCert(true));
        return buf.toString();
    }
}

