/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.crypto.CryptoConstants;
import net.i2p.util.Clock;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.NativeBigInteger;
import net.i2p.util.RandomSource;

class YKGenerator {
    private static final Log _log;
    private static int MIN_NUM_BUILDERS;
    private static int MAX_NUM_BUILDERS;
    private static int CALC_DELAY;
    private static volatile List _values;
    private static Thread _precalcThread;
    public static final String PROP_YK_PRECALC_MIN = "crypto.yk.precalc.min";
    public static final String PROP_YK_PRECALC_MAX = "crypto.yk.precalc.max";
    public static final String PROP_YK_PRECALC_DELAY = "crypto.yk.precalc.delay";
    public static final String DEFAULT_YK_PRECALC_MIN = "10";
    public static final String DEFAULT_YK_PRECALC_MAX = "30";
    public static final String DEFAULT_YK_PRECALC_DELAY = "10000";
    private static final long CHECK_DELAY = 30000L;
    private static final BigInteger _two;

    YKGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final int getSize() {
        List list = _values;
        synchronized (list) {
            return _values.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final int addValues(BigInteger[] yk) {
        int sz = 0;
        List list = _values;
        synchronized (list) {
            _values.add(yk);
            sz = _values.size();
        }
        return sz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BigInteger[] getNextYK() {
        List list = _values;
        synchronized (list) {
            if (_values.size() > 0) {
                if (_log.shouldLog(10)) {
                    _log.debug("Sufficient precalculated YK values - fetch the existing");
                }
                return (BigInteger[])_values.remove(0);
            }
        }
        if (_log.shouldLog(20)) {
            _log.info("Insufficient precalculated YK values - create a new one");
        }
        return YKGenerator.generateYK();
    }

    private static final BigInteger[] generateYK() {
        NativeBigInteger k = null;
        BigInteger y = null;
        long t0 = 0L;
        long t1 = 0L;
        while (k == null) {
            t0 = Clock.getInstance().now();
            k = new NativeBigInteger(226, RandomSource.getInstance());
            t1 = Clock.getInstance().now();
            if (BigInteger.ZERO.compareTo(k) == 0) {
                k = null;
                continue;
            }
            BigInteger kPlus2 = k.add(_two);
            if (kPlus2.compareTo(CryptoConstants.elgp) <= 0) continue;
            k = null;
        }
        long t2 = Clock.getInstance().now();
        y = CryptoConstants.elgg.modPow(k, CryptoConstants.elgp);
        BigInteger[] yk = new BigInteger[]{y, k};
        long diff = t2 - t0;
        if (diff > 1000L && _log.shouldLog(30)) {
            _log.warn("Took too long to generate YK value for ElGamal (" + diff + "ms)");
        }
        return yk;
    }

    public static void main(String[] args) {
        RandomSource.getInstance().nextBoolean();
        try {
            Thread.sleep(20000L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        _log.debug("\n\n\n\nBegin test\n");
        long negTime = 0L;
        for (int i = 0; i < 5; ++i) {
            long startNeg = Clock.getInstance().now();
            YKGenerator.getNextYK();
            long endNeg = Clock.getInstance().now();
        }
        _log.debug("YK fetch time for 5 runs: " + negTime + " @ " + negTime / 5L + "ms each");
        try {
            Thread.sleep(30000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static {
        int val;
        int val2;
        _log = new Log(YKGenerator.class);
        MIN_NUM_BUILDERS = -1;
        MAX_NUM_BUILDERS = -1;
        CALC_DELAY = -1;
        _values = new ArrayList(50);
        _precalcThread = null;
        I2PAppContext ctx = I2PAppContext.getGlobalContext();
        try {
            MIN_NUM_BUILDERS = val2 = Integer.parseInt(ctx.getProperty(PROP_YK_PRECALC_MIN, DEFAULT_YK_PRECALC_MIN));
        }
        catch (Throwable t) {
            MIN_NUM_BUILDERS = val = Integer.parseInt(DEFAULT_YK_PRECALC_MIN);
        }
        try {
            MAX_NUM_BUILDERS = val2 = Integer.parseInt(ctx.getProperty(PROP_YK_PRECALC_MAX, DEFAULT_YK_PRECALC_MAX));
        }
        catch (Throwable t) {
            MAX_NUM_BUILDERS = val = Integer.parseInt(DEFAULT_YK_PRECALC_MAX);
        }
        try {
            int val3;
            CALC_DELAY = val3 = Integer.parseInt(ctx.getProperty(PROP_YK_PRECALC_DELAY, DEFAULT_YK_PRECALC_DELAY));
        }
        catch (Throwable t) {
            CALC_DELAY = val = Integer.parseInt(DEFAULT_YK_PRECALC_DELAY);
        }
        if (_log.shouldLog(10)) {
            _log.debug("ElGamal YK Precalc (minimum: " + MIN_NUM_BUILDERS + " max: " + MAX_NUM_BUILDERS + ", delay: " + CALC_DELAY + ")");
        }
        _precalcThread = new I2PThread(new YKPrecalcRunner(MIN_NUM_BUILDERS, MAX_NUM_BUILDERS));
        _precalcThread.setName("YK Precalc");
        _precalcThread.setDaemon(true);
        _precalcThread.setPriority(1);
        _precalcThread.start();
        _two = new NativeBigInteger(1, new byte[]{2});
    }

    private static class YKPrecalcRunner
    implements Runnable {
        private int _minSize;
        private int _maxSize;

        private YKPrecalcRunner(int minSize, int maxSize) {
            this._minSize = minSize;
            this._maxSize = maxSize;
        }

        public void run() {
            while (true) {
                int startSize;
                int curSize = 0;
                long start = Clock.getInstance().now();
                curSize = startSize = YKGenerator.getSize();
                while (curSize < this._minSize) {
                    while (curSize < this._maxSize) {
                        long begin = Clock.getInstance().now();
                        curSize = YKGenerator.addValues(YKGenerator.generateYK());
                        long end = Clock.getInstance().now();
                        if (_log.shouldLog(10)) {
                            _log.debug("Precalculated YK value in " + (end - begin) + "ms");
                        }
                        try {
                            Thread.sleep(CALC_DELAY);
                        }
                        catch (InterruptedException ie) {}
                    }
                }
                long end = Clock.getInstance().now();
                int numCalc = curSize - startSize;
                if (numCalc > 0 && _log.shouldLog(10)) {
                    _log.debug("Precalced " + numCalc + " to " + curSize + " in " + (end - start - (long)(CALC_DELAY * numCalc)) + "ms (not counting " + CALC_DELAY * numCalc + "ms relief).  now sleeping");
                }
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException ie) {
                }
            }
        }
    }
}

