/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import net.i2p.I2PAppContext;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Signature;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.util.Log;

public class TrustedUpdate {
    private static final String DEFAULT_TRUSTED_KEY = "W4kJbnv9KSVwbnapV7SaNW2kMIZKs~hwL0ro9pZXFo1xTwqz45nykCp1HM7sAKYDZay5z1HvYYOl9CNVz00xF03KPU9RUCVxhDZ1YXhZIskPKjUPUsCIpE~Z1C~N9KSEV6~2stDlBNH10VZ4T0X1TrcXwb3IBXliWo2y2GAx~Ow=";
    private static final String DEFAULT_TRUSTED_KEY2 = "lT54eq3SH0TWWwQ1wgH6XPelIno7wH7UfiZOpQg-ZuxdNhc4UjjrohKdKZqfswt1ANPnmOlMewLGBESl7kJB9c5sByz~IOlNyz5BMLRC~R~ZC9QI4WXwUBYW8BhYO2mkvtdOrcy690lDkwzdf5xLxlCBpQlTaLYzQVjVWBcvbCA=";
    private static final String DEFAULT_TRUSTED_KEY3 = "JHFA0yXUgKtmhajXFZH9Nk62OPRHbvvQHTi8EANV-D~3tjLjaz9p9cs6Fs8W3FSLfUwsQeFg7dfVSQQZga~1jMjboo94vIcm3j6XbW4mbcorVQ74uPjd8EA1AQhJ6bBTxDAFk~6fVDOdhHT0Wo5CcUn7v8bAYY3x3UWiL8Remx0=";
    private static final String VALID_VERSION_CHARS = "0123456789.";
    private static final int VERSION_BYTES = 16;
    private static final int HEADER_BYTES = 56;
    private static final String PROP_TRUSTED_KEYS = "router.trustedUpdateKeys";
    private static I2PAppContext _context;
    private Log _log;
    private ArrayList _trustedKeys;
    private String _newVersion;

    public TrustedUpdate() {
        this(I2PAppContext.getGlobalContext());
    }

    public TrustedUpdate(I2PAppContext context) {
        _context = context;
        this._log = _context.logManager().getLog(TrustedUpdate.class);
        this._trustedKeys = new ArrayList();
        this._newVersion = null;
        String propertyTrustedKeys = context.getProperty(PROP_TRUSTED_KEYS);
        if (propertyTrustedKeys != null && propertyTrustedKeys.length() > 0) {
            StringTokenizer propertyTrustedKeysTokens = new StringTokenizer(propertyTrustedKeys, " ,\r\n");
            while (propertyTrustedKeysTokens.hasMoreTokens()) {
                this._trustedKeys.add(propertyTrustedKeysTokens.nextToken().trim());
            }
        } else {
            this._trustedKeys.add(DEFAULT_TRUSTED_KEY);
            this._trustedKeys.add(DEFAULT_TRUSTED_KEY2);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("TrustedUpdate created, trusting " + this._trustedKeys.size() + " keys.");
        }
    }

    public static void main(String[] args) {
        try {
            if ("keygen".equals(args[0])) {
                TrustedUpdate.genKeysCLI(args[1], args[2]);
            } else if ("showversion".equals(args[0])) {
                TrustedUpdate.showVersionCLI(args[1]);
            } else if ("sign".equals(args[0])) {
                TrustedUpdate.signCLI(args[1], args[2], args[3], args[4]);
            } else if ("verifysig".equals(args[0])) {
                TrustedUpdate.verifySigCLI(args[1]);
            } else if ("verifyupdate".equals(args[0])) {
                TrustedUpdate.verifyUpdateCLI(args[1]);
            } else {
                TrustedUpdate.showUsageCLI();
            }
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            TrustedUpdate.showUsageCLI();
        }
    }

    public static final boolean needsUpdate(String currentVersion, String newVersion) {
        StringTokenizer newVersionTokens = new StringTokenizer(TrustedUpdate.sanitize(newVersion), ".");
        StringTokenizer currentVersionTokens = new StringTokenizer(TrustedUpdate.sanitize(currentVersion), ".");
        while (newVersionTokens.hasMoreTokens() && currentVersionTokens.hasMoreTokens()) {
            String newNumber = newVersionTokens.nextToken();
            String currentNumber = currentVersionTokens.nextToken();
            switch (TrustedUpdate.compare(newNumber, currentNumber)) {
                case -1: {
                    return false;
                }
                case 0: {
                    break;
                }
                case 1: {
                    return true;
                }
            }
        }
        return newVersionTokens.hasMoreTokens() && !currentVersionTokens.hasMoreTokens();
    }

    private static final int compare(String lop, String rop) {
        try {
            int left = Integer.parseInt(lop);
            int right = Integer.parseInt(rop);
            if (left < right) {
                return -1;
            }
            if (left == right) {
                return 0;
            }
            return 1;
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void genKeysCLI(String publicKeyFile, String privateKeyFile) {
        FileOutputStream fileOutputStream = null;
        _context = I2PAppContext.getGlobalContext();
        try {
            Object[] signingKeypair = _context.keyGenerator().generateSigningKeypair();
            SigningPublicKey signingPublicKey = (SigningPublicKey)signingKeypair[0];
            SigningPrivateKey signingPrivateKey = (SigningPrivateKey)signingKeypair[1];
            fileOutputStream = new FileOutputStream(publicKeyFile);
            signingPublicKey.writeBytes(fileOutputStream);
            fileOutputStream.close();
            fileOutputStream = null;
            fileOutputStream = new FileOutputStream(privateKeyFile);
            signingPrivateKey.writeBytes(fileOutputStream);
            System.out.println("\r\nPrivate key written to: " + privateKeyFile);
            System.out.println("Public key written to: " + publicKeyFile);
            System.out.println("\r\nPublic key: " + signingPublicKey.toBase64() + "\r\n");
        }
        catch (Exception e) {
            System.err.println("Error writing keys:");
            e.printStackTrace();
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static final String sanitize(String versionString) {
        StringBuilder versionStringBuilder = new StringBuilder(versionString);
        for (int i = 0; i < versionStringBuilder.length(); ++i) {
            if (VALID_VERSION_CHARS.indexOf(versionStringBuilder.charAt(i)) != -1) continue;
            versionStringBuilder.deleteCharAt(i);
            --i;
        }
        return versionStringBuilder.toString();
    }

    private static final void showUsageCLI() {
        System.err.println("Usage: TrustedUpdate keygen       publicKeyFile privateKeyFile");
        System.err.println("       TrustedUpdate showversion  signedFile");
        System.err.println("       TrustedUpdate sign         inputFile signedFile privateKeyFile version");
        System.err.println("       TrustedUpdate verifysig    signedFile");
        System.err.println("       TrustedUpdate verifyupdate signedFile");
    }

    private static final void showVersionCLI(String signedFile) {
        String versionString = new TrustedUpdate().getVersionString(new File(signedFile));
        if (versionString.equals("")) {
            System.out.println("No version string found in file '" + signedFile + "'");
        } else {
            System.out.println("Version: " + versionString);
        }
    }

    private static final void signCLI(String inputFile, String signedFile, String privateKeyFile, String version) {
        Signature signature = new TrustedUpdate().sign(inputFile, signedFile, privateKeyFile, version);
        if (signature != null) {
            System.out.println("Input file '" + inputFile + "' signed and written to '" + signedFile + "'");
        } else {
            System.out.println("Error signing input file '" + inputFile + "'");
        }
    }

    private static final void verifySigCLI(String signedFile) {
        boolean isValidSignature = new TrustedUpdate().verify(new File(signedFile));
        if (isValidSignature) {
            System.out.println("Signature VALID");
        } else {
            System.out.println("Signature INVALID");
        }
    }

    private static final void verifyUpdateCLI(String signedFile) {
        boolean isUpdate = new TrustedUpdate().isUpdatedVersion("0.7.7", new File(signedFile));
        if (isUpdate) {
            System.out.println("File version is newer than current version.");
        } else {
            System.out.println("File version is older than or equal to current version.");
        }
    }

    public ArrayList getTrustedKeys() {
        return this._trustedKeys;
    }

    public String getTrustedKeysString() {
        StringBuilder buf = new StringBuilder(1024);
        for (int i = 0; i < this._trustedKeys.size(); ++i) {
            if (buf.length() > 0) {
                buf.append("\r\n");
            }
            buf.append((String)this._trustedKeys.get(i));
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getVersionString(File signedFile) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(signedFile);
            long skipped = fileInputStream.skip(40L);
            if (skipped != 40L) {
                String string = "";
                return string;
            }
            byte[] data = new byte[16];
            int bytesRead = DataHelper.read(fileInputStream, data);
            if (bytesRead != 16) {
                String string = "";
                return string;
            }
            for (int i = 0; i < 16; ++i) {
                if (data[i] != 0) continue;
                String ioe = new String(data, 0, i, "UTF-8");
                return ioe;
            }
            String string = new String(data, "UTF-8");
            return string;
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("wtf, your JVM doesnt support utf-8? " + uee.getMessage());
        }
        catch (IOException ioe) {
            String string = "";
            return string;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    public String newVersion() {
        return this._newVersion;
    }

    public boolean isUpdatedVersion(String currentVersion, File signedFile) {
        this._newVersion = this.getVersionString(signedFile);
        return TrustedUpdate.needsUpdate(currentVersion, this._newVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String migrateVerified(String currentVersion, File signedFile, File outputFile) {
        if (!this.isUpdatedVersion(currentVersion, signedFile)) {
            return "Downloaded version is not greater than current version";
        }
        if (!this.verify(signedFile)) {
            return "Unknown signing key or corrupt file";
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(signedFile);
            fileOutputStream = new FileOutputStream(outputFile);
            for (long skipped = 0L; skipped < 56L; skipped += fileInputStream.skip(56L - skipped)) {
            }
            byte[] buffer = new byte[1024];
            int bytesRead = 0;
            while ((bytesRead = fileInputStream.read(buffer)) != -1) {
                fileOutputStream.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException ioe) {
            String string = "I/O Exception during file extraction";
            return string;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException ioe) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException ioe) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Signature sign(String inputFile, String signedFile, String privateKeyFile, String version) {
        FileInputStream fileInputStream = null;
        SigningPrivateKey signingPrivateKey = new SigningPrivateKey();
        try {
            fileInputStream = new FileInputStream(privateKeyFile);
            signingPrivateKey.readBytes(fileInputStream);
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Unable to load the signing key", ioe);
            }
            Signature signature = null;
            return signature;
        }
        catch (DataFormatException dfe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Unable to load the signing key", dfe);
            }
            Signature signature = null;
            return signature;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException ioe) {}
            }
        }
        return this.sign(inputFile, signedFile, signingPrivateKey, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Signature sign(String inputFile, String signedFile, SigningPrivateKey signingPrivateKey, String version) {
        byte[] versionHeader = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        byte[] versionRawBytes = null;
        if (version.length() > 16) {
            version = version.substring(0, 16);
        }
        try {
            versionRawBytes = version.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("wtf, your JVM doesnt support utf-8? " + e.getMessage());
        }
        System.arraycopy(versionRawBytes, 0, versionHeader, 0, versionRawBytes.length);
        FileInputStream fileInputStream = null;
        Signature signature = null;
        SequenceInputStream bytesToSignInputStream = null;
        ByteArrayInputStream versionHeaderInputStream = null;
        try {
            fileInputStream = new FileInputStream(inputFile);
            versionHeaderInputStream = new ByteArrayInputStream(versionHeader);
            bytesToSignInputStream = new SequenceInputStream(versionHeaderInputStream, fileInputStream);
            signature = _context.dsa().sign(bytesToSignInputStream, signingPrivateKey);
        }
        catch (Exception e) {
            if (this._log.shouldLog(40)) {
                this._log.error("Error signing", e);
            }
            Signature signature2 = null;
            return signature2;
        }
        finally {
            if (bytesToSignInputStream != null) {
                try {
                    bytesToSignInputStream.close();
                }
                catch (IOException ioe) {}
            }
            fileInputStream = null;
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(signedFile);
            fileOutputStream.write(signature.getData());
            fileOutputStream.write(versionHeader);
            fileInputStream = new FileInputStream(inputFile);
            byte[] buffer = new byte[1024];
            int bytesRead = 0;
            while ((bytesRead = fileInputStream.read(buffer)) != -1) {
                fileOutputStream.write(buffer, 0, bytesRead);
            }
            fileOutputStream.close();
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(30)) {
                this._log.log(30, "Error writing signed file " + signedFile, ioe);
            }
            Signature signature3 = null;
            return signature3;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException ioe) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException ioe) {}
            }
        }
        return signature;
    }

    public boolean verify(File signedFile) {
        for (int i = 0; i < this._trustedKeys.size(); ++i) {
            SigningPublicKey signingPublicKey = new SigningPublicKey();
            try {
                signingPublicKey.fromBase64((String)this._trustedKeys.get(i));
                boolean isValidSignature = this.verify(signedFile, signingPublicKey);
                if (!isValidSignature) continue;
                return true;
            }
            catch (DataFormatException dfe) {
                this._log.log(50, "Trusted key " + i + " is not valid");
            }
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("None of the keys match");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verify(String signedFile, String publicKeyFile) {
        SigningPublicKey signingPublicKey = new SigningPublicKey();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(signedFile);
            signingPublicKey.readBytes(fileInputStream);
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Unable to load the signature", ioe);
            }
            boolean bl = false;
            return bl;
        }
        catch (DataFormatException dfe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Unable to load the signature", dfe);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException ioe) {}
            }
        }
        return this.verify(new File(signedFile), signingPublicKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verify(File signedFile, SigningPublicKey signingPublicKey) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(signedFile);
            Signature signature = new Signature();
            signature.readBytes(fileInputStream);
            boolean bl = _context.dsa().verifySignature(signature, fileInputStream, signingPublicKey);
            return bl;
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Error reading " + signedFile + " to verify", ioe);
            }
            boolean bl = false;
            return bl;
        }
        catch (DataFormatException dfe) {
            if (this._log.shouldLog(40)) {
                this._log.error("Error reading the signature", dfe);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException ioe) {}
            }
        }
    }
}

