/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.macs.I2PHMac;

public class HMACGenerator {
    private I2PAppContext _context;
    protected final List _available;
    private final List _availableTmp;

    public HMACGenerator(I2PAppContext context) {
        this._context = context;
        this._available = new ArrayList(32);
        this._availableTmp = new ArrayList(32);
    }

    public Hash calculate(SessionKey key, byte[] data) {
        if (key == null || key.getData() == null || data == null) {
            throw new NullPointerException("Null arguments for HMAC");
        }
        byte[] rv = new byte[32];
        this.calculate(key, data, 0, data.length, rv, 0);
        return new Hash(rv);
    }

    public void calculate(SessionKey key, byte[] data, int offset, int length, byte[] target, int targetOffset) {
        if (key == null || key.getData() == null || data == null) {
            throw new NullPointerException("Null arguments for HMAC");
        }
        I2PHMac mac = this.acquire();
        mac.init(key.getData());
        mac.update(data, offset, length);
        mac.doFinal(target, targetOffset);
        this.release(mac);
    }

    public boolean verify(SessionKey key, byte[] curData, int curOffset, int curLength, byte[] origMAC, int origMACOffset, int origMACLength) {
        if (key == null || key.getData() == null || curData == null) {
            throw new NullPointerException("Null arguments for HMAC");
        }
        I2PHMac mac = this.acquire();
        mac.init(key.getData());
        mac.update(curData, curOffset, curLength);
        byte[] rv = this.acquireTmp();
        mac.doFinal(rv, 0);
        this.release(mac);
        boolean eq = DataHelper.eq(rv, 0, origMAC, origMACOffset, origMACLength);
        this.releaseTmp(rv);
        return eq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected I2PHMac acquire() {
        List list = this._available;
        synchronized (list) {
            if (this._available.size() > 0) {
                return (I2PHMac)this._available.remove(0);
            }
        }
        return new I2PHMac(new MD5Digest(), 32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release(Mac mac) {
        List list = this._available;
        synchronized (list) {
            if (this._available.size() < 64) {
                this._available.add(mac);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] acquireTmp() {
        byte[] rv = null;
        List list = this._availableTmp;
        synchronized (list) {
            if (this._availableTmp.size() > 0) {
                rv = (byte[])this._availableTmp.remove(0);
            }
        }
        if (rv != null) {
            Arrays.fill(rv, (byte)0);
        } else {
            rv = new byte[32];
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseTmp(byte[] tmp) {
        List list = this._availableTmp;
        synchronized (list) {
            if (this._availableTmp.size() < 64) {
                this._availableTmp.add(tmp);
            }
        }
    }
}

