/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.i2p.I2PAppContext;
import net.i2p.crypto.AESOutputStream;
import net.i2p.crypto.KeyGenerator;
import net.i2p.crypto.SHA256Generator;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.util.Clock;
import net.i2p.util.Log;
import net.i2p.util.RandomSource;

public class AESInputStream
extends FilterInputStream {
    private Log _log;
    private I2PAppContext _context;
    private SessionKey _key;
    private byte[] _lastBlock;
    private boolean _eofFound;
    private long _cumulativeRead;
    private long _cumulativePrepared;
    private long _cumulativePaddingStripped;
    private byte[] _encryptedBuf;
    private int _writesSinceDecrypt;
    private int[] _decryptedBuf;
    private int _decryptedSize;
    private static final int BLOCK_SIZE = 16;

    public AESInputStream(I2PAppContext context, InputStream source, SessionKey key, byte[] iv) {
        super(source);
        this._context = context;
        this._log = context.logManager().getLog(AESInputStream.class);
        this._key = key;
        this._lastBlock = new byte[16];
        System.arraycopy(iv, 0, this._lastBlock, 0, 16);
        this._encryptedBuf = new byte[16];
        this._writesSinceDecrypt = 0;
        this._decryptedBuf = new int[15];
        this._decryptedSize = 0;
        this._cumulativePaddingStripped = 0L;
        this._eofFound = false;
    }

    public int read() throws IOException {
        while (!this._eofFound && this._decryptedSize <= 0) {
            this.refill();
        }
        if (this._decryptedSize > 0) {
            int c = this._decryptedBuf[0];
            System.arraycopy(this._decryptedBuf, 1, this._decryptedBuf, 0, this._decryptedBuf.length - 1);
            --this._decryptedSize;
            return c;
        }
        if (this._eofFound) {
            return -1;
        }
        throw new IOException("Not EOF, but none available?  " + this._decryptedSize + "/" + this._writesSinceDecrypt + "/" + this._cumulativeRead + "... impossible");
    }

    public int read(byte[] dest) throws IOException {
        return this.read(dest, 0, dest.length);
    }

    public int read(byte[] dest, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            int val = this.read();
            if (val == -1) {
                if (this._eofFound && i == 0) {
                    if (this._log.shouldLog(10)) {
                        this._log.info("EOF? " + this._eofFound + "\nread=" + i + " decryptedSize=" + this._decryptedSize + " \nencryptedSize=" + this._writesSinceDecrypt + " \ntotal=" + this._cumulativeRead + " \npadding=" + this._cumulativePaddingStripped + " \nprepared=" + this._cumulativePrepared);
                    }
                    return -1;
                }
                if (i != len && this._log.shouldLog(10)) {
                    this._log.info("non-terminal eof: " + this._eofFound + " i=" + i + " len=" + len);
                }
                return i;
            }
            dest[off + i] = (byte)val;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Read the full buffer of size " + len);
        }
        return len;
    }

    public long skip(long numBytes) throws IOException {
        for (long l = 0L; l < numBytes; ++l) {
            int val = this.read();
            if (val != -1) continue;
            return l;
        }
        return numBytes;
    }

    public int available() throws IOException {
        return this._decryptedSize;
    }

    public void close() throws IOException {
        this.in.close();
        if (this._log.shouldLog(10)) {
            this._log.debug("Cumulative bytes read from source/decrypted/stripped: " + this._cumulativeRead + "/" + this._cumulativePrepared + "/" + this._cumulativePaddingStripped + "] remaining [" + this._decryptedSize + " ready, " + this._writesSinceDecrypt + " still encrypted]");
        }
    }

    public void mark(int readLimit) {
    }

    public void reset() throws IOException {
        throw new IOException("Reset not supported");
    }

    public boolean markSupported() {
        return false;
    }

    private void refill() throws IOException {
        if (!this._eofFound && this._writesSinceDecrypt < 16) {
            int read = this.in.read(this._encryptedBuf, this._writesSinceDecrypt, this._encryptedBuf.length - this._writesSinceDecrypt);
            if (read == -1) {
                this._eofFound = true;
            } else if (read > 0) {
                this._cumulativeRead += (long)read;
                this._writesSinceDecrypt += read;
            }
        }
        if (this._writesSinceDecrypt == 16) {
            if (this._log.shouldLog(10)) {
                this._log.debug("We have " + this._writesSinceDecrypt + " available to decrypt... doing so");
            }
            this.decryptBlock();
            if (this._writesSinceDecrypt > 0 && this._log.shouldLog(10)) {
                this._log.debug("Bytes left in the encrypted buffer after decrypt: " + this._writesSinceDecrypt);
            }
        }
    }

    private void decryptBlock() throws IOException {
        if (this._writesSinceDecrypt != 16) {
            throw new IOException("Error decrypting - no data to decrypt");
        }
        if (this._decryptedSize != 0) {
            throw new IOException("wtf, decrypted size is not 0? " + this._decryptedSize);
        }
        this._context.aes().decrypt(this._encryptedBuf, 0, this._encryptedBuf, 0, this._key, this._lastBlock, 16);
        DataHelper.xor(this._encryptedBuf, 0, this._lastBlock, 0, this._encryptedBuf, 0, 16);
        int payloadBytes = this.countBlockPayload(this._encryptedBuf, 0);
        for (int i = 0; i < payloadBytes; ++i) {
            int c = this._encryptedBuf[i];
            if (c <= 0) {
                c += 256;
            }
            this._decryptedBuf[i] = c;
        }
        this._decryptedSize = payloadBytes;
        this._cumulativePaddingStripped += (long)(16 - payloadBytes);
        this._cumulativePrepared += (long)payloadBytes;
        System.arraycopy(this._encryptedBuf, 0, this._lastBlock, 0, 16);
        this._writesSinceDecrypt = 0;
    }

    private int countBlockPayload(byte[] data, int startIndex) throws IOException {
        byte numPadBytes = data[startIndex + 16 - 1];
        if (numPadBytes >= 16 || numPadBytes <= 0) {
            if (this._log.shouldLog(10)) {
                this._log.debug("countBlockPayload on block index " + startIndex + numPadBytes + " is an invalid # of pad bytes");
            }
            throw new IOException("Invalid number of pad bytes (" + numPadBytes + ") for " + startIndex + " index");
        }
        for (int i = 16 - numPadBytes; i < 16; ++i) {
            if (data[startIndex + i] == (byte)numPadBytes) continue;
            throw new IOException("Incorrect padding on decryption: data[" + i + "] = " + data[startIndex + i] + " not " + numPadBytes);
        }
        return 16 - numPadBytes;
    }

    int remainingBytes() {
        return this._writesSinceDecrypt;
    }

    int readyBytes() {
        return this._decryptedSize;
    }

    public static void main(String[] args) {
        I2PAppContext ctx = new I2PAppContext();
        try {
            System.out.println("pwd=" + new File(".").getAbsolutePath());
            System.out.println("Beginning");
            AESInputStream.runTest(ctx);
        }
        catch (Throwable e) {
            ctx.logManager().getLog(AESInputStream.class).error("Fail", e);
        }
        try {
            Thread.sleep(30000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("Done");
    }

    private static void runTest(I2PAppContext ctx) {
        int i;
        Log log = ctx.logManager().getLog(AESInputStream.class);
        log.setMinimumPriority(10);
        byte[] orig = new byte[32768];
        RandomSource.getInstance().nextBytes(orig);
        SessionKey key = KeyGenerator.getInstance().generateSessionKey();
        byte[] iv = "there once was a".getBytes();
        for (i = 0; i < 20; ++i) {
            AESInputStream.runTest(ctx, orig, key, iv);
        }
        log.info("Done testing 32KB data");
        orig = new byte[20];
        RandomSource.getInstance().nextBytes(orig);
        for (i = 0; i < 20; ++i) {
            AESInputStream.runTest(ctx, orig, key, iv);
        }
        log.info("Done testing 20 byte data");
        orig = new byte[3];
        RandomSource.getInstance().nextBytes(orig);
        for (i = 0; i < 20; ++i) {
            AESInputStream.runTest(ctx, orig, key, iv);
        }
        log.info("Done testing 3 byte data");
        orig = new byte[]{};
        RandomSource.getInstance().nextBytes(orig);
        for (i = 0; i < 20; ++i) {
            AESInputStream.runTest(ctx, orig, key, iv);
        }
        log.info("Done testing 0 byte data");
        for (i = 0; i <= 32768; ++i) {
            orig = new byte[i];
            ctx.random().nextBytes(orig);
            try {
                log.info("Testing " + orig.length);
                AESInputStream.runTest(ctx, orig, key, iv);
                continue;
            }
            catch (RuntimeException re) {
                log.error("Error testing " + orig.length);
                throw re;
            }
        }
        orig = new byte[32];
        RandomSource.getInstance().nextBytes(orig);
        try {
            AESInputStream.runOffsetTest(ctx, orig, key, iv);
        }
        catch (Exception e) {
            log.info("Error running offset test", e);
        }
        log.info("Done testing offset test (it should have come back with a statement NOT EQUAL!)");
        try {
            Thread.sleep(30000L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
    }

    private static void runTest(I2PAppContext ctx, byte[] orig, SessionKey key, byte[] iv) {
        Log log = ctx.logManager().getLog(AESInputStream.class);
        try {
            long start = Clock.getInstance().now();
            ByteArrayOutputStream origStream = new ByteArrayOutputStream(512);
            AESOutputStream out = new AESOutputStream(ctx, origStream, key, iv);
            out.write(orig);
            out.close();
            byte[] encrypted = origStream.toByteArray();
            long endE = Clock.getInstance().now();
            ByteArrayInputStream encryptedStream = new ByteArrayInputStream(encrypted);
            AESInputStream sin = new AESInputStream(ctx, encryptedStream, key, iv);
            ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
            byte[] buf = new byte[32768];
            int read = DataHelper.read(sin, buf);
            if (read > 0) {
                baos.write(buf, 0, read);
            }
            sin.close();
            byte[] fin = baos.toByteArray();
            long end = Clock.getInstance().now();
            Hash origHash = SHA256Generator.getInstance().calculateHash(orig);
            Hash newHash = SHA256Generator.getInstance().calculateHash(fin);
            boolean eq = origHash.equals(newHash);
            if (!eq) {
                throw new RuntimeException("NOT EQUAL!  len=" + orig.length + " read=" + read + "\norig: \t" + Base64.encode(orig) + "\nnew : \t" + Base64.encode(fin));
            }
            boolean ok = DataHelper.eq(orig, fin);
            log.debug("EQ data? " + ok + " origLen: " + orig.length + " fin.length: " + fin.length);
            log.debug("Time to D(E(" + orig.length + ")): " + (end - start) + "ms");
            log.debug("Time to E(" + orig.length + "): " + (endE - start) + "ms");
            log.debug("Time to D(" + orig.length + "): " + (end - endE) + "ms");
        }
        catch (IOException ioe) {
            log.error("ERROR transferring", ioe);
        }
    }

    private static void runOffsetTest(I2PAppContext ctx, byte[] orig, SessionKey key, byte[] iv) {
        Log log = ctx.logManager().getLog(AESInputStream.class);
        try {
            long start = Clock.getInstance().now();
            ByteArrayOutputStream origStream = new ByteArrayOutputStream(512);
            AESOutputStream out = new AESOutputStream(ctx, origStream, key, iv);
            out.write(orig);
            out.close();
            byte[] encrypted = origStream.toByteArray();
            long endE = Clock.getInstance().now();
            log.info("Encrypted segment length: " + encrypted.length);
            byte[] encryptedSegment = new byte[40];
            System.arraycopy(encrypted, 0, encryptedSegment, 0, 40);
            ByteArrayInputStream encryptedStream = new ByteArrayInputStream(encryptedSegment);
            AESInputStream sin = new AESInputStream(ctx, encryptedStream, key, iv);
            ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
            byte[] buf = new byte[32768];
            int read = DataHelper.read(sin, buf);
            int remaining = sin.remainingBytes();
            int readyBytes = sin.readyBytes();
            log.info("Read: " + read);
            if (read > 0) {
                baos.write(buf, 0, read);
            }
            sin.close();
            byte[] fin = baos.toByteArray();
            log.info("fin.length: " + fin.length + " remaining: " + remaining + " ready: " + readyBytes);
            long end = Clock.getInstance().now();
            Hash origHash = SHA256Generator.getInstance().calculateHash(orig);
            Hash newHash = SHA256Generator.getInstance().calculateHash(fin);
            boolean eq = origHash.equals(newHash);
            if (!eq) {
                throw new RuntimeException("NOT EQUAL!  len=" + orig.length + "\norig: \t" + Base64.encode(orig) + "\nnew : \t" + Base64.encode(fin));
            }
            log.info("Equal hashes.  hash: " + origHash);
            boolean ok = DataHelper.eq(orig, fin);
            log.debug("EQ data? " + ok + " origLen: " + orig.length + " fin.length: " + fin.length);
            log.debug("Time to D(E(" + orig.length + ")): " + (end - start) + "ms");
            log.debug("Time to E(" + orig.length + "): " + (endE - start) + "ms");
            log.debug("Time to D(" + orig.length + "): " + (end - endE) + "ms");
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (IOException ioe) {
            log.error("ERROR transferring", ioe);
        }
    }
}

