/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.naming;

import java.io.IOException;
import net.i2p.I2PAppContext;
import net.i2p.client.naming.NamingService;
import net.i2p.client.naming.PetName;
import net.i2p.client.naming.PetNameDB;
import net.i2p.data.Destination;

public class PetNameNamingService
extends NamingService {
    private PetNameDB _petnameDb;
    public static final String PROP_PETNAME_FILE = "i2p.petnamefile";
    public static final String DEFAULT_PETNAME_FILE = "petnames.txt";

    public PetNameNamingService(I2PAppContext context) {
        super(context);
        this._petnameDb = this._context.petnameDb();
        String file = this._context.getProperty(PROP_PETNAME_FILE, DEFAULT_PETNAME_FILE);
        try {
            this._petnameDb.load(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Destination lookup(String hostname) {
        PetName name = this._petnameDb.getByName(hostname);
        if (name != null && name.getNetwork().equalsIgnoreCase("i2p")) {
            return this.lookupBase64(name.getLocation());
        }
        return this.lookupBase64(hostname);
    }

    public String reverseLookup(Destination dest) {
        return this._petnameDb.getByLocation(dest.toBase64()).getName();
    }
}

