/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark.bencode;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import org.klomp.snark.bencode.BEValue;
import org.klomp.snark.bencode.InvalidBEncodingException;

public class BDecoder {
    private final InputStream in;
    private int indicator = 0;
    private String special_map = "info";
    private boolean in_special_map = false;
    private final MessageDigest sha_digest;

    public byte[] get_special_map_digest() {
        byte[] result = this.sha_digest.digest();
        return result;
    }

    public void set_special_map_name(String name) {
        this.special_map = name;
    }

    public BDecoder(InputStream in) {
        this.in = in;
        try {
            this.sha_digest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException nsa) {
            throw new InternalError(nsa.toString());
        }
    }

    public static BEValue bdecode(InputStream in) throws IOException {
        return new BDecoder(in).bdecode();
    }

    public int getNextIndicator() throws IOException {
        if (this.indicator == 0) {
            this.indicator = this.in.read();
            if (this.in_special_map) {
                this.sha_digest.update((byte)this.indicator);
            }
        }
        return this.indicator;
    }

    public BEValue bdecode() throws IOException {
        this.indicator = this.getNextIndicator();
        if (this.indicator == -1) {
            return null;
        }
        if (this.indicator >= 48 && this.indicator <= 57) {
            return this.bdecodeBytes();
        }
        if (this.indicator == 105) {
            return this.bdecodeNumber();
        }
        if (this.indicator == 108) {
            return this.bdecodeList();
        }
        if (this.indicator == 100) {
            return this.bdecodeMap();
        }
        throw new InvalidBEncodingException("Unknown indicator '" + this.indicator + "'");
    }

    public BEValue bdecodeBytes() throws IOException {
        int c = this.getNextIndicator();
        int num = c - 48;
        if (num < 0 || num > 9) {
            throw new InvalidBEncodingException("Number expected, not '" + (char)c + "'");
        }
        this.indicator = 0;
        c = this.read();
        int i = c - 48;
        while (i >= 0 && i <= 9) {
            num = num * 10 + i;
            c = this.read();
            i = c - 48;
        }
        if (c != 58) {
            throw new InvalidBEncodingException("Colon expected, not '" + (char)c + "'");
        }
        return new BEValue(this.read(num));
    }

    public BEValue bdecodeNumber() throws IOException {
        int c = this.getNextIndicator();
        if (c != 105) {
            throw new InvalidBEncodingException("Expected 'i', not '" + (char)c + "'");
        }
        this.indicator = 0;
        c = this.read();
        if (c == 48) {
            c = this.read();
            if (c == 101) {
                return new BEValue(BigInteger.ZERO);
            }
            throw new InvalidBEncodingException("'e' expected after zero, not '" + (char)c + "'");
        }
        char[] chars = new char[256];
        int off = 0;
        if (c == 45) {
            c = this.read();
            if (c == 48) {
                throw new InvalidBEncodingException("Negative zero not allowed");
            }
            chars[off] = (char)c;
            ++off;
        }
        if (c < 49 || c > 57) {
            throw new InvalidBEncodingException("Invalid Integer start '" + (char)c + "'");
        }
        chars[off] = (char)c;
        ++off;
        c = this.read();
        int i = c - 48;
        while (i >= 0 && i <= 9) {
            chars[off] = (char)c;
            ++off;
            c = this.read();
            i = c - 48;
        }
        if (c != 101) {
            throw new InvalidBEncodingException("Integer should end with 'e'");
        }
        String s = new String(chars, 0, off);
        return new BEValue(new BigInteger(s));
    }

    public BEValue bdecodeList() throws IOException {
        int c = this.getNextIndicator();
        if (c != 108) {
            throw new InvalidBEncodingException("Expected 'l', not '" + (char)c + "'");
        }
        this.indicator = 0;
        ArrayList<BEValue> result = new ArrayList<BEValue>();
        c = this.getNextIndicator();
        while (c != 101) {
            result.add(this.bdecode());
            c = this.getNextIndicator();
        }
        this.indicator = 0;
        return new BEValue(result);
    }

    public BEValue bdecodeMap() throws IOException {
        int c = this.getNextIndicator();
        if (c != 100) {
            throw new InvalidBEncodingException("Expected 'd', not '" + (char)c + "'");
        }
        this.indicator = 0;
        HashMap<String, BEValue> result = new HashMap<String, BEValue>();
        c = this.getNextIndicator();
        while (c != 101) {
            String key = this.bdecode().getString();
            boolean special = this.special_map.equals(key);
            if (special) {
                this.in_special_map = true;
            }
            BEValue value = this.bdecode();
            result.put(key, value);
            if (special) {
                this.in_special_map = false;
            }
            c = this.getNextIndicator();
        }
        this.indicator = 0;
        return new BEValue(result);
    }

    private int read() throws IOException {
        int c = this.in.read();
        if (c == -1) {
            throw new EOFException();
        }
        if (this.in_special_map) {
            this.sha_digest.update((byte)c);
        }
        return c;
    }

    private byte[] read(int length) throws IOException {
        int i;
        byte[] result = new byte[length];
        for (int read = 0; read < length; read += i) {
            i = this.in.read(result, read, length - read);
            if (i != -1) continue;
            throw new EOFException();
        }
        if (this.in_special_map) {
            this.sha_digest.update(result, 0, length);
        }
        return result;
    }
}

