/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import net.i2p.I2PAppContext;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;
import org.klomp.snark.BWLimits;
import org.klomp.snark.BitField;
import org.klomp.snark.ConnectionAcceptor;
import org.klomp.snark.I2PSnarkUtil;
import org.klomp.snark.MetaInfo;
import org.klomp.snark.PeerCoordinatorSet;
import org.klomp.snark.Snark;

public class SnarkManager
implements Snark.CompleteListener {
    private static SnarkManager _instance = new SnarkManager();
    private final Map _snarks = new HashMap();
    private final Object _addSnarkLock = new Object();
    private File _configFile;
    private Properties _config;
    private I2PAppContext _context = I2PAppContext.getGlobalContext();
    private Log _log = this._context.logManager().getLog(SnarkManager.class);
    private final List _messages = new ArrayList(16);
    private I2PSnarkUtil _util = new I2PSnarkUtil(this._context);
    private PeerCoordinatorSet _peerCoordinatorSet;
    private ConnectionAcceptor _connectionAcceptor;
    public static final String PROP_I2CP_HOST = "i2psnark.i2cpHost";
    public static final String PROP_I2CP_PORT = "i2psnark.i2cpPort";
    public static final String PROP_I2CP_OPTS = "i2psnark.i2cpOptions";
    public static final String PROP_EEP_HOST = "i2psnark.eepHost";
    public static final String PROP_EEP_PORT = "i2psnark.eepPort";
    public static final String PROP_UPLOADERS_TOTAL = "i2psnark.uploaders.total";
    public static final String PROP_UPBW_MAX = "i2psnark.upbw.max";
    public static final String PROP_DIR = "i2psnark.dir";
    public static final String PROP_META_PREFIX = "i2psnark.zmeta.";
    public static final String PROP_META_BITFIELD_SUFFIX = ".bitfield";
    private static final String CONFIG_FILE = "i2psnark.config";
    public static final String PROP_AUTO_START = "i2snark.autoStart";
    public static final String DEFAULT_AUTO_START = "false";
    public static final String PROP_LINK_PREFIX = "i2psnark.linkPrefix";
    public static final String DEFAULT_LINK_PREFIX = "file:///";
    public static final int MIN_UP_BW = 2;
    public static final int DEFAULT_MAX_UP_BW = 10;
    private static final int MAX_MESSAGES = 5;
    private static final int MAX_FILES_PER_TORRENT = 512;
    private static final String[] DEFAULT_TRACKERS = new String[]{"POSTMAN", "http://tracker2.postman.i2p/announce.php=http://tracker2.postman.i2p/", "WELTERDE", "http://BGKmlDOoH3RzFbPRfRpZV2FjpVj8~3moFftw5-dZfDf2070TOe8Tf2~DAVeaM6ZRLdmFEt~9wyFL8YMLMoLoiwGEH6IGW6rc45tstN68KsBDWZqkTohV1q9XFgK9JnCwE~Oi89xLBHsLMTHOabowWM6dkC8nI6QqJC2JODqLPIRfOVrDdkjLwtCrsckzLybNdFmgfoqF05UITDyczPsFVaHtpF1sRggOVmdvCM66otyonlzNcJbn59PA-R808vUrCPMGU~O9Wys0i-NoqtIbtWfOKnjCRFMNw5ex4n9m5Sxm9e20UkpKG6qzEuvKZWi8vTLe1NW~CBrj~vG7I3Ok4wybUFflBFOaBabxYJLlx4xTE1zJIVxlsekmAjckB4v-cQwulFeikR4LxPQ6mCQknW2HZ4JQIq6hL9AMabxjOlYnzh7kjOfRGkck8YgeozcyTvcDUcUsOuSTk06L4kdrv8h2Cozjbloi5zl6KTbj5ZTciKCxi73Pn9grICn-HQqEAAAA.i2p/a=http://tracker.welterde.i2p/stats?mode=top5", "CRSTRACK", "http://b4G9sCdtfvccMAXh~SaZrPqVQNyGQbhbYMbw6supq2XGzbjU4NcOmjFI0vxQ8w1L05twmkOvg5QERcX6Mi8NQrWnR0stLExu2LucUXg1aYjnggxIR8TIOGygZVIMV3STKH4UQXD--wz0BUrqaLxPhrm2Eh9Hwc8TdB6Na4ShQUq5Xm8D4elzNUVdpM~RtChEyJWuQvoGAHY3ppX-EJJLkiSr1t77neS4Lc-KofMVmgI9a2tSSpNAagBiNI6Ak9L1T0F9uxeDfEG9bBSQPNMOSUbAoEcNxtt7xOW~cNOAyMyGydwPMnrQ5kIYPY8Pd3XudEko970vE0D6gO19yoBMJpKx6Dh50DGgybLQ9CpRaynh2zPULTHxm8rneOGRcQo8D3mE7FQ92m54~SvfjXjD2TwAVGI~ae~n9HDxt8uxOecAAvjjJ3TD4XM63Q9TmB38RmGNzNLDBQMEmJFpqQU8YeuhnS54IVdUoVQFqui5SfDeLXlSkh4vYoMU66pvBfWbAAAA.i2p/tracker/announce.php=http://crstrack.i2p/tracker/"};
    public static final String PROP_TRACKERS = "i2psnark.trackers";
    private static Map trackerMap = null;

    public static SnarkManager instance() {
        return _instance;
    }

    private SnarkManager() {
        this._configFile = new File(CONFIG_FILE);
        if (!this._configFile.isAbsolute()) {
            this._configFile = new File(this._context.getConfigDir(), CONFIG_FILE);
        }
        this.loadConfig(null);
    }

    public void start() {
        this._peerCoordinatorSet = new PeerCoordinatorSet();
        this._connectionAcceptor = new ConnectionAcceptor(this._util);
        int minutes = this.getStartupDelayMinutes();
        this._messages.add("Adding torrents in " + minutes + (minutes == 1 ? " minute" : " minutes"));
        I2PAppThread monitor = new I2PAppThread(new DirMonitor(), "Snark DirMonitor");
        monitor.setDaemon(true);
        monitor.start();
        this._context.addShutdownTask(new SnarkManagerShutdown());
    }

    public I2PSnarkUtil util() {
        return this._util;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(String message) {
        List list = this._messages;
        synchronized (list) {
            this._messages.add(message);
            while (this._messages.size() > 5) {
                this._messages.remove(0);
            }
        }
        if (this._log.shouldLog(20)) {
            this._log.info("MSG: " + message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMessages() {
        List list = this._messages;
        synchronized (list) {
            return new ArrayList(this._messages);
        }
    }

    public boolean shouldAutoStart() {
        return Boolean.valueOf(this._config.getProperty(PROP_AUTO_START, DEFAULT_AUTO_START));
    }

    public String linkPrefix() {
        return this._config.getProperty(PROP_LINK_PREFIX, DEFAULT_LINK_PREFIX + this.getDataDir().getAbsolutePath() + File.separatorChar);
    }

    private int getStartupDelayMinutes() {
        return 3;
    }

    public File getDataDir() {
        String dir = this._config.getProperty(PROP_DIR, "i2psnark");
        File f = new File(dir);
        if (!f.isAbsolute()) {
            f = new File(this._context.getAppDir(), dir);
        }
        return f;
    }

    public void loadConfig(String filename) {
        if (this._config == null) {
            this._config = new Properties();
        }
        if (filename != null) {
            File cfg = new File(filename);
            if (!cfg.isAbsolute()) {
                cfg = new File(this._context.getConfigDir(), filename);
            }
            this._configFile = cfg;
            if (cfg.exists()) {
                try {
                    DataHelper.loadProps(this._config, cfg);
                }
                catch (IOException ioe) {
                    this._log.error("Error loading I2PSnark config '" + filename + "'", ioe);
                }
            }
        }
        if (!this._config.containsKey(PROP_I2CP_HOST)) {
            this._config.setProperty(PROP_I2CP_HOST, "127.0.0.1");
        }
        if (!this._config.containsKey(PROP_I2CP_PORT)) {
            this._config.setProperty(PROP_I2CP_PORT, "7654");
        }
        if (!this._config.containsKey(PROP_I2CP_OPTS)) {
            this._config.setProperty(PROP_I2CP_OPTS, "inbound.length=2 inbound.lengthVariance=0 outbound.length=2 outbound.lengthVariance=0 inbound.quantity=3 outbound.quantity=3");
        }
        if (!this._config.containsKey(PROP_EEP_HOST)) {
            this._config.setProperty(PROP_EEP_HOST, "127.0.0.1");
        }
        if (!this._config.containsKey(PROP_EEP_PORT)) {
            this._config.setProperty(PROP_EEP_PORT, "4444");
        }
        if (!this._config.containsKey(PROP_UPLOADERS_TOTAL)) {
            this._config.setProperty(PROP_UPLOADERS_TOTAL, "10");
        }
        if (!this._config.containsKey(PROP_DIR)) {
            this._config.setProperty(PROP_DIR, "i2psnark");
        }
        if (!this._config.containsKey(PROP_AUTO_START)) {
            this._config.setProperty(PROP_AUTO_START, DEFAULT_AUTO_START);
        }
        this.updateConfig();
    }

    private void getBWLimit() {
        int[] limits;
        if (!this._config.containsKey(PROP_UPBW_MAX) && (limits = BWLimits.getBWLimits(this._util.getI2CPHost(), this._util.getI2CPPort())) != null && limits[1] > 0) {
            this._util.setMaxUpBW(limits[1]);
        }
    }

    private void updateConfig() {
        String i2cpHost = this._config.getProperty(PROP_I2CP_HOST);
        int i2cpPort = this.getInt(PROP_I2CP_PORT, 7654);
        String opts = this._config.getProperty(PROP_I2CP_OPTS);
        HashMap<String, String> i2cpOpts = new HashMap<String, String>();
        if (opts != null) {
            StringTokenizer tok = new StringTokenizer(opts, " ");
            while (tok.hasMoreTokens()) {
                String pair = tok.nextToken();
                int split = pair.indexOf(61);
                if (split <= 0) continue;
                i2cpOpts.put(pair.substring(0, split), pair.substring(split + 1));
            }
        }
        if (i2cpHost != null) {
            this._util.setI2CPConfig(i2cpHost, i2cpPort, i2cpOpts);
            this._log.debug("Configuring with I2CP options " + i2cpOpts);
        }
        String eepHost = this._config.getProperty(PROP_EEP_HOST);
        int eepPort = this.getInt(PROP_EEP_PORT, 4444);
        if (eepHost != null) {
            this._util.setProxy(eepHost, eepPort);
        }
        this._util.setMaxUploaders(this.getInt(PROP_UPLOADERS_TOTAL, 10));
        this._util.setMaxUpBW(this.getInt(PROP_UPBW_MAX, 10));
        String ot = this._config.getProperty("i2psnark.opentrackers");
        if (ot != null) {
            this._util.setOpenTrackerString(ot);
        }
        this.getDataDir().mkdirs();
    }

    private int getInt(String prop, int defaultVal) {
        String p = this._config.getProperty(prop);
        try {
            if (p != null && p.trim().length() > 0) {
                return Integer.parseInt(p.trim());
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        return defaultVal;
    }

    public void updateConfig(String dataDir, boolean autoStart, String seedPct, String eepHost, String eepPort, String i2cpHost, String i2cpPort, String i2cpOpts, String upLimit, String upBW, boolean useOpenTrackers, String openTrackers) {
        int limit;
        boolean changed = false;
        if (eepHost != null) {
            int port = this._util.getEepProxyPort();
            try {
                port = Integer.parseInt(eepPort);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            String host = this._util.getEepProxyHost();
            if (!(eepHost.trim().length() <= 0 || port <= 0 || host.equals(eepHost) && port == this._util.getEepProxyPort())) {
                this._util.setProxy(eepHost, port);
                changed = true;
                this._config.setProperty(PROP_EEP_HOST, eepHost);
                this._config.setProperty(PROP_EEP_PORT, eepPort + "");
                this.addMessage("EepProxy location changed to " + eepHost + ":" + port);
            }
        }
        if (upLimit != null) {
            limit = this._util.getMaxUploaders();
            try {
                limit = Integer.parseInt(upLimit);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (limit != this._util.getMaxUploaders()) {
                if (limit >= 4) {
                    this._util.setMaxUploaders(limit);
                    changed = true;
                    this._config.setProperty(PROP_UPLOADERS_TOTAL, "" + limit);
                    this.addMessage("Total uploaders limit changed to " + limit);
                } else {
                    this.addMessage("Minimum total uploaders limit is 4");
                }
            }
        }
        if (upBW != null) {
            limit = this._util.getMaxUpBW();
            try {
                limit = Integer.parseInt(upBW);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (limit != this._util.getMaxUpBW()) {
                if (limit >= 2) {
                    this._util.setMaxUpBW(limit);
                    changed = true;
                    this._config.setProperty(PROP_UPBW_MAX, "" + limit);
                    this.addMessage("Up BW limit changed to " + limit + "KBps");
                } else {
                    this.addMessage("Minimum Up BW limit is 2KBps");
                }
            }
        }
        if (i2cpHost != null) {
            int oldI2CPPort = this._util.getI2CPPort();
            String oldI2CPHost = this._util.getI2CPHost();
            int port = oldI2CPPort;
            try {
                port = Integer.parseInt(i2cpPort);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            String host = oldI2CPHost;
            HashMap<String, String> opts = new HashMap<String, String>();
            if (i2cpOpts == null) {
                i2cpOpts = "";
            }
            StringTokenizer tok = new StringTokenizer(i2cpOpts, " \t\n");
            while (tok.hasMoreTokens()) {
                String pair = tok.nextToken();
                int split = pair.indexOf(61);
                if (split <= 0) continue;
                opts.put(pair.substring(0, split), pair.substring(split + 1));
            }
            HashMap<String, String> oldOpts = new HashMap<String, String>();
            String oldI2CPOpts = this._config.getProperty(PROP_I2CP_OPTS);
            if (oldI2CPOpts == null) {
                oldI2CPOpts = "";
            }
            tok = new StringTokenizer(oldI2CPOpts, " \t\n");
            while (tok.hasMoreTokens()) {
                String pair = tok.nextToken();
                int split = pair.indexOf(61);
                if (split <= 0) continue;
                oldOpts.put(pair.substring(0, split), pair.substring(split + 1));
            }
            if (!(i2cpHost.trim().length() <= 0 || port <= 0 || host.equals(i2cpHost) && port == this._util.getI2CPPort() && ((Object)oldOpts).equals(opts))) {
                boolean snarksActive = false;
                Set names = this.listTorrentFiles();
                Iterator iter = names.iterator();
                while (iter.hasNext()) {
                    Snark snark = this.getTorrent((String)iter.next());
                    if (snark == null || snark.stopped) continue;
                    snarksActive = true;
                    break;
                }
                if (snarksActive) {
                    this.addMessage("Cannot change the I2CP settings while torrents are active");
                    this._log.debug("i2cp host [" + i2cpHost + "] i2cp port " + port + " opts [" + opts + "] oldOpts [" + oldOpts + "]");
                } else {
                    if (this._util.connected()) {
                        this._util.disconnect();
                        this.addMessage("Disconnecting old I2CP destination");
                    }
                    Properties p = new Properties();
                    p.putAll((Map<?, ?>)opts);
                    this.addMessage("I2CP settings changed to " + i2cpHost + ":" + port + " (" + i2cpOpts.trim() + ")");
                    this._util.setI2CPConfig(i2cpHost, port, p);
                    boolean ok = this._util.connect();
                    if (!ok) {
                        this.addMessage("Unable to connect with the new settings, reverting to the old I2CP settings");
                        this._util.setI2CPConfig(oldI2CPHost, oldI2CPPort, oldOpts);
                        ok = this._util.connect();
                        if (!ok) {
                            this.addMessage("Unable to reconnect with the old settings!");
                        }
                    } else {
                        this.addMessage("Reconnected on the new I2CP destination");
                        this._config.setProperty(PROP_I2CP_HOST, i2cpHost.trim());
                        this._config.setProperty(PROP_I2CP_PORT, "" + port);
                        this._config.setProperty(PROP_I2CP_OPTS, i2cpOpts.trim());
                        changed = true;
                        for (String name : names) {
                            Snark snark = this.getTorrent(name);
                            if (snark == null || snark.acceptor == null) continue;
                            snark.acceptor.restart();
                            this.addMessage("I2CP listener restarted for " + snark.meta.getName());
                        }
                    }
                }
                changed = true;
            }
        }
        if (this.shouldAutoStart() != autoStart) {
            this._config.setProperty(PROP_AUTO_START, autoStart + "");
            this.addMessage("Adjusted autostart to " + autoStart);
            changed = true;
        }
        if (this._util.shouldUseOpenTrackers() != useOpenTrackers) {
            this._config.setProperty("i2psnark.useOpentrackers", useOpenTrackers + "");
            this.addMessage((useOpenTrackers ? "En" : "Dis") + "abled open trackers - torrent restart required to take effect.");
            changed = true;
        }
        if (openTrackers != null && openTrackers.trim().length() > 0 && !openTrackers.trim().equals(this._util.getOpenTrackerString())) {
            this._config.setProperty("i2psnark.opentrackers", openTrackers.trim());
            this._util.setOpenTrackerString(openTrackers);
            this.addMessage("Open Tracker list changed - torrent restart required to take effect.");
            changed = true;
        }
        if (changed) {
            this.saveConfig();
        } else {
            this.addMessage("Configuration unchanged.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfig() {
        try {
            File file = this._configFile;
            synchronized (file) {
                DataHelper.storeProps(this._config, this._configFile);
            }
        }
        catch (IOException ioe) {
            this.addMessage("Unable to save the config to '" + this._configFile.getAbsolutePath() + "'.");
        }
    }

    public Properties getConfig() {
        return this._config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set listTorrentFiles() {
        Map map = this._snarks;
        synchronized (map) {
            return new HashSet(this._snarks.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Snark getTorrent(String filename) {
        Map map = this._snarks;
        synchronized (map) {
            return (Snark)this._snarks.get(filename);
        }
    }

    public void addTorrent(String filename) {
        this.addTorrent(filename, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addTorrent(String filename, boolean dontAutoStart) {
        Snark torrent;
        block31: {
            if (!dontAutoStart && !this._util.connected()) {
                this.addMessage("Connecting to I2P");
                boolean ok = this._util.connect();
                if (!ok) {
                    this.addMessage("Error connecting to I2P - check your I2CP settings!");
                    return;
                }
            }
            File sfile = new File(filename);
            try {
                filename = sfile.getCanonicalPath();
            }
            catch (IOException ioe) {
                this._log.error("Unable to add the torrent " + filename, ioe);
                this.addMessage("ERR: Could not add the torrent '" + filename + "': " + ioe.getMessage());
                return;
            }
            File dataDir = this.getDataDir();
            torrent = null;
            Object object = this._snarks;
            synchronized (object) {
                torrent = (Snark)this._snarks.get(filename);
            }
            if (torrent != null) return;
            object = this._addSnarkLock;
            synchronized (object) {
                FileInputStream fis;
                block30: {
                    Map map = this._snarks;
                    synchronized (map) {
                        if (this._snarks.get(filename) != null) {
                            return;
                        }
                    }
                    fis = null;
                    try {
                        fis = new FileInputStream(sfile);
                        MetaInfo info = new MetaInfo(fis);
                        fis.close();
                        fis = null;
                        String rejectMessage = this.locked_validateTorrent(info);
                        if (rejectMessage != null) {
                            sfile.delete();
                            this.addMessage(rejectMessage);
                            break block30;
                        }
                        torrent = new Snark(this._util, filename, null, -1, null, null, this, this._peerCoordinatorSet, this._connectionAcceptor, false, dataDir.getPath());
                        torrent.completeListener = this;
                        Map map2 = this._snarks;
                        synchronized (map2) {
                            this._snarks.put(filename, torrent);
                            break block31;
                        }
                    }
                    catch (IOException ioe) {
                        this.addMessage("Torrent in " + sfile.getName() + " is invalid: " + ioe.getMessage());
                        if (!sfile.exists()) return;
                        sfile.delete();
                        return;
                    }
                }
                return;
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException ioe) {}
                    }
                }
            }
        }
        File f = new File(filename);
        if (!dontAutoStart && this.shouldAutoStart()) {
            torrent.startTorrent();
            this.addMessage("Torrent added and started: '" + f.getName() + "'.");
            return;
        }
        this.addMessage("Torrent added: '" + f.getName() + "'.");
    }

    public long getSavedTorrentTime(Snark snark) {
        MetaInfo metainfo = snark.meta;
        byte[] ih = metainfo.getInfoHash();
        String infohash = Base64.encode(ih);
        infohash = infohash.replace('=', '$');
        String time = this._config.getProperty(PROP_META_PREFIX + infohash + PROP_META_BITFIELD_SUFFIX);
        if (time == null) {
            return 0L;
        }
        int comma = time.indexOf(44);
        if (comma <= 0) {
            return 0L;
        }
        time = time.substring(0, comma);
        try {
            return Long.parseLong(time);
        }
        catch (NumberFormatException nfe) {
            return 0L;
        }
    }

    public BitField getSavedTorrentBitField(Snark snark) {
        MetaInfo metainfo = snark.meta;
        byte[] ih = metainfo.getInfoHash();
        String infohash = Base64.encode(ih);
        infohash = infohash.replace('=', '$');
        String bf = this._config.getProperty(PROP_META_PREFIX + infohash + PROP_META_BITFIELD_SUFFIX);
        if (bf == null) {
            return null;
        }
        int comma = bf.indexOf(44);
        if (comma <= 0) {
            return null;
        }
        bf = bf.substring(comma + 1).trim();
        int len = metainfo.getPieces();
        if (bf.equals(".")) {
            BitField bitfield = new BitField(len);
            for (int i = 0; i < len; ++i) {
                bitfield.set(i);
            }
            return bitfield;
        }
        byte[] bitfield = Base64.decode(bf);
        if (bitfield == null) {
            return null;
        }
        if (bitfield.length * 8 < len) {
            return null;
        }
        return new BitField(bitfield, len);
    }

    public void saveTorrentStatus(MetaInfo metainfo, BitField bitfield) {
        String bfs;
        byte[] ih = metainfo.getInfoHash();
        String infohash = Base64.encode(ih);
        infohash = infohash.replace('=', '$');
        String now = "" + System.currentTimeMillis();
        if (bitfield.complete()) {
            bfs = ".";
        } else {
            byte[] bf = bitfield.getFieldBytes();
            bfs = Base64.encode(bf);
        }
        this._config.setProperty(PROP_META_PREFIX + infohash + PROP_META_BITFIELD_SUFFIX, now + "," + bfs);
        this.saveConfig();
    }

    public void removeTorrentStatus(MetaInfo metainfo) {
        byte[] ih = metainfo.getInfoHash();
        String infohash = Base64.encode(ih);
        infohash = infohash.replace('=', '$');
        this._config.remove(PROP_META_PREFIX + infohash + PROP_META_BITFIELD_SUFFIX);
        this.saveConfig();
    }

    private String locked_validateTorrent(MetaInfo info) throws IOException {
        String announce = info.getAnnounce();
        if (!announce.startsWith("http://") || announce.indexOf(".i2p/") < 0) {
            return "Non-i2p tracker in " + info.getName() + ", deleting it from our list of trackers!";
        }
        List files = info.getFiles();
        if (files != null && files.size() > 512) {
            return "Too many files in " + info.getName() + " (" + files.size() + "), deleting it!";
        }
        if (info.getPieces() <= 0) {
            return "No pieces in " + info.getName() + "?  deleting it!";
        }
        if (info.getPieceLength(0) > 0x100000) {
            return "Pieces are too large in " + info.getName() + " (" + DataHelper.formatSize(info.getPieceLength(0)) + "B), deleting it.";
        }
        if (info.getTotalLength() > 0x280000000L) {
            System.out.println("torrent info: " + info.toString());
            List lengths = info.getLengths();
            if (lengths != null) {
                for (int i = 0; i < lengths.size(); ++i) {
                    System.out.println("File " + i + " is " + lengths.get(i) + " long.");
                }
            }
            return "Torrents larger than " + DataHelper.formatSize(0x280000000L) + "B are not supported yet (because we're paranoid): " + info.getName() + ", deleting it!";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Snark stopTorrent(String filename, boolean shouldRemove) {
        File sfile = new File(filename);
        try {
            filename = sfile.getCanonicalPath();
        }
        catch (IOException ioe) {
            this._log.error("Unable to remove the torrent " + filename, ioe);
            this.addMessage("ERR: Could not remove the torrent '" + filename + "': " + ioe.getMessage());
            return null;
        }
        int remaining = 0;
        Snark torrent = null;
        Map map = this._snarks;
        synchronized (map) {
            torrent = shouldRemove ? (Snark)this._snarks.remove(filename) : (Snark)this._snarks.get(filename);
            remaining = this._snarks.size();
        }
        if (torrent != null) {
            boolean wasStopped = torrent.stopped;
            torrent.stopTorrent();
            if (remaining == 0) {
                // empty if block
            }
            if (!wasStopped) {
                this.addMessage("Torrent stopped: '" + sfile.getName() + "'.");
            }
        }
        return torrent;
    }

    public void removeTorrent(String filename) {
        Snark torrent = this.stopTorrent(filename, true);
        if (torrent != null) {
            File torrentFile = new File(filename);
            torrentFile.delete();
            if (torrent.storage != null) {
                this.removeTorrentStatus(torrent.storage.getMetaInfo());
            }
            this.addMessage("Torrent removed: '" + torrentFile.getName() + "'.");
        }
    }

    public void torrentComplete(Snark snark) {
        File f = new File(snark.torrent);
        long len = snark.meta.getTotalLength();
        this.addMessage("Download finished: " + f.getName() + " (size: " + DataHelper.formatSize(len) + "B)");
        this.updateStatus(snark);
    }

    public void updateStatus(Snark snark) {
        this.saveTorrentStatus(snark.meta, snark.storage.getBitField());
    }

    private void monitorTorrents(File dir) {
        String[] fileNames = dir.list(TorrentFilenameFilter.instance());
        ArrayList<String> foundNames = new ArrayList<String>(0);
        if (fileNames != null) {
            for (int i = 0; i < fileNames.length; ++i) {
                try {
                    foundNames.add(new File(dir, fileNames[i]).getCanonicalPath());
                    continue;
                }
                catch (IOException ioe) {
                    this._log.error("Error resolving '" + fileNames[i] + "' in '" + dir, ioe);
                }
            }
        }
        Set existingNames = this.listTorrentFiles();
        for (int i = 0; i < foundNames.size(); ++i) {
            if (existingNames.contains(foundNames.get(i))) continue;
            if (this.shouldAutoStart() && !this._util.connect()) {
                this.addMessage("Unable to connect to I2P!");
            }
            this.addTorrent((String)foundNames.get(i), !this.shouldAutoStart());
        }
        for (String name : existingNames) {
            if (foundNames.contains(name)) continue;
            this.stopTorrent(name, true);
        }
    }

    public Map getTrackers() {
        if (trackerMap != null) {
            return trackerMap;
        }
        TreeMap<String, String> rv = new TreeMap<String, String>();
        String trackers = this._config.getProperty(PROP_TRACKERS);
        if (trackers == null || trackers.trim().length() <= 0) {
            trackers = this._context.getProperty(PROP_TRACKERS);
        }
        if (trackers == null || trackers.trim().length() <= 0) {
            for (int i = 0; i < DEFAULT_TRACKERS.length; i += 2) {
                rv.put(DEFAULT_TRACKERS[i], DEFAULT_TRACKERS[i + 1]);
            }
        } else {
            StringTokenizer tok = new StringTokenizer(trackers, ",");
            while (tok.hasMoreTokens()) {
                String pair = tok.nextToken();
                int split = pair.indexOf(61);
                if (split <= 0) continue;
                String name = pair.substring(0, split).trim();
                String url = pair.substring(split + 1).trim();
                if (name.length() <= 0 || url.length() <= 0) continue;
                rv.put(name, url);
            }
        }
        trackerMap = rv;
        return trackerMap;
    }

    public class SnarkManagerShutdown
    extends I2PAppThread {
        public void run() {
            Set names = SnarkManager.this.listTorrentFiles();
            Iterator iter = names.iterator();
            while (iter.hasNext()) {
                Snark snark = SnarkManager.this.getTorrent((String)iter.next());
                if (snark == null || snark.stopped) continue;
                snark.stopTorrent();
            }
        }
    }

    private static class TorrentFilenameFilter
    implements FilenameFilter {
        private static final TorrentFilenameFilter _filter = new TorrentFilenameFilter();

        private TorrentFilenameFilter() {
        }

        public static TorrentFilenameFilter instance() {
            return _filter;
        }

        public boolean accept(File dir, String name) {
            return name != null && name.endsWith(".torrent");
        }
    }

    private class DirMonitor
    implements Runnable {
        private DirMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Thread.sleep(60000 * SnarkManager.this.getStartupDelayMinutes());
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            List ie = SnarkManager.this._messages;
            synchronized (ie) {
                if (SnarkManager.this._messages.size() == 1) {
                    SnarkManager.this._messages.remove(0);
                }
            }
            SnarkManager.this.getBWLimit();
            while (true) {
                File dir = SnarkManager.this.getDataDir();
                SnarkManager.this._log.debug("Directory Monitor loop over " + dir.getAbsolutePath());
                try {
                    SnarkManager.this.monitorTorrents(dir);
                }
                catch (Exception e) {
                    SnarkManager.this._log.error("Error in the DirectoryMonitor", e);
                }
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

