/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.i2p.util.Log;
import org.klomp.snark.BitField;
import org.klomp.snark.MetaInfo;
import org.klomp.snark.Peer;
import org.klomp.snark.PeerConnectionIn;
import org.klomp.snark.PeerConnectionOut;
import org.klomp.snark.PeerListener;
import org.klomp.snark.Request;

class PeerState {
    private Log _log = new Log(PeerState.class);
    final Peer peer;
    final PeerListener listener;
    final MetaInfo metainfo;
    boolean interesting = false;
    boolean choking = true;
    boolean interested = false;
    boolean choked = true;
    long downloaded;
    long uploaded;
    BitField bitfield;
    final PeerConnectionIn in;
    final PeerConnectionOut out;
    private final List outstandingRequests = new ArrayList();
    private Request lastRequest = null;
    private boolean resend = false;
    private static final int MAX_PIPELINE = 5;
    private static final int MAX_PIPELINE_BYTES = 131072;
    public static final int PARTSIZE = 16384;
    private static final int MAX_PARTSIZE = 65536;
    Request pendingRequest = null;

    PeerState(Peer peer, PeerListener listener, MetaInfo metainfo, PeerConnectionIn in, PeerConnectionOut out) {
        this.peer = peer;
        this.listener = listener;
        this.metainfo = metainfo;
        this.in = in;
        this.out = out;
    }

    void keepAliveMessage() {
        if (this._log.shouldLog(10)) {
            this._log.debug(this.peer + " rcv alive");
        }
    }

    void chokeMessage(boolean choke) {
        if (this._log.shouldLog(10)) {
            this._log.debug(this.peer + " rcv " + (choke ? "" : "un") + "choked");
        }
        this.choked = choke;
        if (this.choked) {
            this.resend = true;
        }
        this.listener.gotChoke(this.peer, choke);
        if (!this.choked && this.interesting) {
            this.request();
        }
    }

    void interestedMessage(boolean interest) {
        if (this._log.shouldLog(10)) {
            this._log.debug(this.peer + " rcv " + (interest ? "" : "un") + "interested");
        }
        this.interested = interest;
        this.listener.gotInterest(this.peer, interest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void haveMessage(int piece) {
        if (this._log.shouldLog(10)) {
            this._log.debug(this.peer + " rcv have(" + piece + ")");
        }
        if (piece < 0 || piece >= this.metainfo.getPieces()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Got strange 'have: " + piece + "' message from " + this.peer);
            }
            return;
        }
        PeerState peerState = this;
        synchronized (peerState) {
            if (this.bitfield == null) {
                this.bitfield = new BitField(this.metainfo.getPieces());
            }
            this.bitfield.set(piece);
        }
        if (this.listener.gotHave(this.peer, piece)) {
            this.setInteresting(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bitfieldMessage(byte[] bitmap) {
        PeerState peerState = this;
        synchronized (peerState) {
            if (this._log.shouldLog(10)) {
                this._log.debug(this.peer + " rcv bitfield");
            }
            if (this.bitfield != null) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Got unexpected bitfield message from " + this.peer);
                }
                return;
            }
            this.bitfield = new BitField(bitmap, this.metainfo.getPieces());
        }
        this.setInteresting(this.listener.gotBitField(this.peer, this.bitfield));
    }

    void requestMessage(int piece, int begin, int length) {
        if (this._log.shouldLog(10)) {
            this._log.debug(this.peer + " rcv request(" + piece + ", " + begin + ", " + length + ") ");
        }
        if (this.choking) {
            if (this._log.shouldLog(20)) {
                this._log.info("Request received, but choking " + this.peer);
            }
            return;
        }
        if (piece < 0 || piece >= this.metainfo.getPieces() || begin < 0 || begin > this.metainfo.getPieceLength(piece) || length <= 0 || length > 65536) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Got strange 'request: " + piece + ", " + begin + ", " + length + "' message from " + this.peer);
            }
            return;
        }
        if (this.out.queuedBytes() + length > 131072) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Discarding request over pipeline limit from " + this.peer);
            }
            return;
        }
        byte[] pieceBytes = this.listener.gotRequest(this.peer, piece, begin, length);
        if (pieceBytes == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Got request for unknown piece: " + piece);
            }
            return;
        }
        if (length != pieceBytes.length) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Got out of range 'request: " + piece + ", " + begin + ", " + length + "' message from " + this.peer);
            }
            return;
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Sending (" + piece + ", " + begin + ", " + length + ")" + " to " + this.peer);
        }
        this.out.sendPiece(piece, begin, length, pieceBytes);
    }

    void uploaded(int size) {
        this.uploaded += (long)size;
        this.listener.uploaded(this.peer, size);
    }

    void pieceMessage(Request req) {
        int size = req.len;
        this.downloaded += (long)size;
        this.listener.downloaded(this.peer, size);
        this.pendingRequest = null;
        if (this.getFirstOutstandingRequest(req.piece) == -1) {
            if (this.listener.gotPiece(this.peer, req.piece, req.bs)) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Got " + req.piece + ": " + this.peer);
                }
            } else {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Got BAD " + req.piece + " from " + this.peer);
                }
                this.downloaded = 0L;
            }
        }
    }

    private synchronized int getFirstOutstandingRequest(int piece) {
        for (int i = 0; i < this.outstandingRequests.size(); ++i) {
            if (((Request)this.outstandingRequests.get((int)i)).piece != piece) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Request getOutstandingRequest(int piece, int begin, int length) {
        Request req;
        int r;
        if (this._log.shouldLog(10)) {
            this._log.debug("getChunk(" + piece + "," + begin + "," + length + ") " + this.peer);
        }
        if ((r = this.getFirstOutstandingRequest(piece)) == -1) {
            if (this._log.shouldLog(20)) {
                this._log.info("Unrequested 'piece: " + piece + ", " + begin + ", " + length + "' received from " + this.peer);
            }
            this.downloaded = 0L;
            return null;
        }
        PeerState peerState = this;
        synchronized (peerState) {
            req = (Request)this.outstandingRequests.get(r);
            while (req.piece == piece && req.off != begin && r < this.outstandingRequests.size() - 1) {
                req = (Request)this.outstandingRequests.get(++r);
            }
            if (req.piece != piece || req.off != begin || req.len != length) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Unrequested or unneeded 'piece: " + piece + ", " + begin + ", " + length + "' received from " + this.peer);
                }
                this.downloaded = 0L;
                return null;
            }
            if (r != 0) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Some requests dropped, got " + req + ", wanted for peer: " + this.peer);
                }
                for (int i = 0; i < r; ++i) {
                    Request dropReq = (Request)this.outstandingRequests.remove(0);
                    this.outstandingRequests.add(dropReq);
                    if (!this.choked) {
                        this.out.sendRequest(dropReq);
                    }
                    if (!this._log.shouldLog(30)) continue;
                    this._log.warn("dropped " + dropReq + " with peer " + this.peer);
                }
            }
            this.outstandingRequests.remove(0);
        }
        this.addRequest();
        this.pendingRequest = req;
        return req;
    }

    Request getPartialRequest() {
        Request req = null;
        for (int i = 0; i < this.outstandingRequests.size(); ++i) {
            Request r1 = (Request)this.outstandingRequests.get(i);
            int j = this.getFirstOutstandingRequest(r1.piece);
            if (j == -1) continue;
            Request r2 = (Request)this.outstandingRequests.get(j);
            if (r2.off <= 0 || req != null && r2.off <= req.off) continue;
            req = r2;
        }
        if (this.pendingRequest != null && req != null && this.pendingRequest.off < req.off) {
            req = this.pendingRequest.off != 0 ? this.pendingRequest : null;
        }
        return req;
    }

    int[] getRequestedPieces() {
        int size = this.outstandingRequests.size();
        int[] arr = new int[size + 2];
        int pc = -1;
        int pos = 0;
        if (this.pendingRequest != null) {
            pc = this.pendingRequest.piece;
            arr[pos++] = pc;
        }
        Object req = null;
        for (int i = 0; i < size; ++i) {
            Request r1 = (Request)this.outstandingRequests.get(i);
            if (pc == r1.piece) continue;
            pc = r1.piece;
            arr[pos++] = pc;
        }
        arr[pos] = -1;
        return arr;
    }

    void cancelMessage(int piece, int begin, int length) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Got cancel message (" + piece + ", " + begin + ", " + length + ")");
        }
        this.out.cancelRequest(piece, begin, length);
    }

    void unknownMessage(int type, byte[] bs) {
        if (this._log.shouldLog(30)) {
            this._log.warn("Warning: Ignoring unknown message type: " + type + " length: " + bs.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void havePiece(int piece) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Tell " + this.peer + " havePiece(" + piece + ")");
        }
        PeerState peerState = this;
        synchronized (peerState) {
            if (this.lastRequest != null && this.lastRequest.piece == piece) {
                this.lastRequest = null;
            }
            Iterator it = this.outstandingRequests.iterator();
            while (it.hasNext()) {
                Request req = (Request)it.next();
                if (req.piece != piece) continue;
                it.remove();
                this.out.sendCancel(req);
            }
        }
        this.out.sendHave(piece);
        this.addRequest();
        peerState = this;
        synchronized (peerState) {
            if (this.lastRequest == null) {
                this.setInteresting(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void request() {
        if (this.resend) {
            PeerState peerState = this;
            synchronized (peerState) {
                this.out.sendRequests(this.outstandingRequests);
            }
            this.resend = false;
        }
        this.addRequest();
    }

    private synchronized void addRequest() {
        boolean more_pieces = true;
        while (more_pieces) {
            boolean isLastChunk;
            boolean bl = more_pieces = this.outstandingRequests.size() < 5;
            if (more_pieces && this.lastRequest == null) {
                more_pieces = this.requestNextPiece();
                continue;
            }
            if (!more_pieces) continue;
            int pieceLength = this.metainfo.getPieceLength(this.lastRequest.piece);
            boolean bl2 = isLastChunk = this.lastRequest.off + this.lastRequest.len == pieceLength;
            if (isLastChunk) {
                more_pieces = this.requestNextPiece();
                continue;
            }
            int nextPiece = this.lastRequest.piece;
            int nextBegin = this.lastRequest.off + 16384;
            byte[] bs = this.lastRequest.bs;
            int maxLength = pieceLength - nextBegin;
            int nextLength = maxLength > 16384 ? 16384 : maxLength;
            Request req = new Request(nextPiece, bs, nextBegin, nextLength);
            this.outstandingRequests.add(req);
            if (!this.choked) {
                this.out.sendRequest(req);
            }
            this.lastRequest = req;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug(this.peer + " requests " + this.outstandingRequests);
        }
    }

    private boolean requestNextPiece() {
        if (this.bitfield != null) {
            Request r = this.listener.getPeerPartial(this.bitfield);
            if (r != null) {
                int[] arr = this.getRequestedPieces();
                boolean found = false;
                int i = 0;
                while (arr[i] >= 0) {
                    if (arr[i] == r.piece) {
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (!found) {
                    this.outstandingRequests.add(r);
                    if (!this.choked) {
                        this.out.sendRequest(r);
                    }
                    this.lastRequest = r;
                    return true;
                }
            }
            int nextPiece = this.listener.wantPiece(this.peer, this.bitfield);
            if (this._log.shouldLog(10)) {
                this._log.debug(this.peer + " want piece " + nextPiece);
            }
            if (nextPiece != -1 && (this.lastRequest == null || this.lastRequest.piece != nextPiece)) {
                byte[] bs;
                int piece_length = this.metainfo.getPieceLength(nextPiece);
                try {
                    bs = new byte[piece_length];
                }
                catch (OutOfMemoryError oom) {
                    this._log.warn("Out of memory, can't request piece " + nextPiece, oom);
                    return false;
                }
                int length = Math.min(piece_length, 16384);
                Request req = new Request(nextPiece, bs, 0, length);
                this.outstandingRequests.add(req);
                if (!this.choked) {
                    this.out.sendRequest(req);
                }
                this.lastRequest = req;
                return true;
            }
        }
        return false;
    }

    synchronized void setInteresting(boolean interest) {
        if (this._log.shouldLog(10)) {
            this._log.debug(this.peer + " setInteresting(" + interest + ")");
        }
        if (interest != this.interesting) {
            this.interesting = interest;
            this.out.sendInterest(interest);
            if (this.interesting && !this.choked) {
                this.request();
            }
        }
    }

    synchronized void setChoking(boolean choke) {
        if (this._log.shouldLog(10)) {
            this._log.debug(this.peer + " setChoking(" + choke + ")");
        }
        if (this.choking != choke) {
            this.choking = choke;
            this.out.sendChoke(choke);
        }
    }

    void keepAlive() {
        this.out.sendAlive();
    }

    synchronized void retransmitRequests() {
        if (this.interesting && !this.choked) {
            this.out.retransmitRequests(this.outstandingRequests);
        }
    }
}

