/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Map;
import net.i2p.data.Base64;
import net.i2p.data.Destination;
import org.klomp.snark.I2PSnarkUtil;
import org.klomp.snark.bencode.BDecoder;
import org.klomp.snark.bencode.BEValue;
import org.klomp.snark.bencode.InvalidBEncodingException;

public class PeerID
implements Comparable {
    private final byte[] id;
    private final Destination address;
    private final int port;
    private final int hash;

    public PeerID(byte[] id, Destination address) {
        this.id = id;
        this.address = address;
        this.port = 6881;
        this.hash = this.calculateHash();
    }

    public PeerID(BDecoder be) throws IOException {
        this(be.bdecodeMap().getMap());
    }

    public PeerID(Map m) throws InvalidBEncodingException, UnknownHostException {
        BEValue bevalue = (BEValue)m.get("peer id");
        if (bevalue == null) {
            throw new InvalidBEncodingException("peer id missing");
        }
        this.id = bevalue.getBytes();
        bevalue = (BEValue)m.get("ip");
        if (bevalue == null) {
            throw new InvalidBEncodingException("ip missing");
        }
        this.address = I2PSnarkUtil.getDestinationFromBase64(bevalue.getString());
        if (this.address == null) {
            throw new InvalidBEncodingException("Invalid destination [" + bevalue.getString() + "]");
        }
        this.port = 6881;
        this.hash = this.calculateHash();
    }

    public byte[] getID() {
        return this.id;
    }

    public Destination getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    private int calculateHash() {
        int b = 0;
        for (int i = 0; i < this.id.length; ++i) {
            b ^= this.id[i];
        }
        return b ^ this.address.hashCode() ^ this.port;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean sameID(PeerID pid) {
        boolean equal = true;
        for (int i = 0; equal && i < this.id.length; ++i) {
            equal = this.id[i] == pid.id[i];
        }
        return equal;
    }

    public boolean equals(Object o) {
        if (o instanceof PeerID) {
            PeerID pid = (PeerID)o;
            return this.port == pid.port && this.address.equals(pid.address) && this.sameID(pid);
        }
        return false;
    }

    public int compareTo(Object o) {
        PeerID pid = (PeerID)o;
        int result = this.port - pid.port;
        if (result != 0) {
            return result;
        }
        result = this.address.hashCode() - pid.address.hashCode();
        if (result != 0) {
            return result;
        }
        for (int i = 0; i < this.id.length; ++i) {
            result = this.id[i] - pid.id[i];
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public String toString() {
        int nonZero = 0;
        for (int i = 0; i < this.id.length; ++i) {
            if (this.id[i] == 0) continue;
            nonZero = i;
            break;
        }
        return Base64.encode(this.id, nonZero, this.id.length - nonZero).substring(0, 4) + "@" + this.address.toBase64().substring(0, 6);
    }

    public static String idencode(byte[] bs) {
        boolean leading_zeros = true;
        StringBuilder sb = new StringBuilder(bs.length * 2);
        for (int i = 0; i < bs.length; ++i) {
            int c = bs[i] & 0xFF;
            if (leading_zeros && c == 0) continue;
            leading_zeros = false;
            if (c < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(c));
        }
        return sb.toString();
    }
}

