/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.i2p.crypto.SHA1;
import net.i2p.data.Base64;
import net.i2p.util.Log;
import org.klomp.snark.bencode.BDecoder;
import org.klomp.snark.bencode.BEValue;
import org.klomp.snark.bencode.BEncoder;
import org.klomp.snark.bencode.InvalidBEncodingException;

public class MetaInfo {
    private static final Log _log = new Log(MetaInfo.class);
    private final String announce;
    private final byte[] info_hash;
    private final String name;
    private final String name_utf8;
    private final List files;
    private final List files_utf8;
    private final List lengths;
    private final int piece_length;
    private final byte[] piece_hashes;
    private final long length;
    private final Map infoMap;
    private byte[] torrentdata;

    MetaInfo(String announce, String name, String name_utf8, List files, List lengths, int piece_length, byte[] piece_hashes, long length) {
        this.announce = announce;
        this.name = name;
        this.name_utf8 = name_utf8;
        this.files = files;
        this.files_utf8 = null;
        this.lengths = lengths;
        this.piece_length = piece_length;
        this.piece_hashes = piece_hashes;
        this.length = length;
        this.info_hash = this.calculateInfoHash();
        this.infoMap = null;
    }

    public MetaInfo(InputStream in) throws IOException {
        this(new BDecoder(in));
    }

    public MetaInfo(BDecoder be) throws IOException {
        this(be.bdecodeMap().getMap());
    }

    public MetaInfo(Map m) throws InvalidBEncodingException {
        Map info;
        _log.debug("Creating a metaInfo: " + m, new Exception("source"));
        BEValue val = (BEValue)m.get("announce");
        if (val == null) {
            throw new InvalidBEncodingException("Missing announce string");
        }
        this.announce = val.getString();
        val = (BEValue)m.get("info");
        if (val == null) {
            throw new InvalidBEncodingException("Missing info map");
        }
        this.infoMap = info = val.getMap();
        val = (BEValue)info.get("name");
        if (val == null) {
            throw new InvalidBEncodingException("Missing name string");
        }
        this.name = val.getString();
        val = (BEValue)info.get("name.utf-8");
        this.name_utf8 = val != null ? val.getString() : null;
        val = (BEValue)info.get("piece length");
        if (val == null) {
            throw new InvalidBEncodingException("Missing piece length number");
        }
        this.piece_length = val.getInt();
        val = (BEValue)info.get("pieces");
        if (val == null) {
            throw new InvalidBEncodingException("Missing piece bytes");
        }
        this.piece_hashes = val.getBytes();
        val = (BEValue)info.get("length");
        if (val != null) {
            this.length = val.getLong();
            this.files = null;
            this.files_utf8 = null;
            this.lengths = null;
        } else {
            val = (BEValue)info.get("files");
            if (val == null) {
                throw new InvalidBEncodingException("Missing length number and/or files list");
            }
            List list = val.getList();
            int size = list.size();
            if (size == 0) {
                throw new InvalidBEncodingException("zero size files list");
            }
            this.files = new ArrayList(size);
            this.files_utf8 = new ArrayList(size);
            this.lengths = new ArrayList(size);
            long l = 0L;
            for (int i = 0; i < list.size(); ++i) {
                Map desc = ((BEValue)list.get(i)).getMap();
                val = (BEValue)desc.get("length");
                if (val == null) {
                    throw new InvalidBEncodingException("Missing length number");
                }
                long len = val.getLong();
                this.lengths.add(new Long(len));
                l += len;
                val = (BEValue)desc.get("path");
                if (val == null) {
                    throw new InvalidBEncodingException("Missing path list");
                }
                List path_list = val.getList();
                int path_length = path_list.size();
                if (path_length == 0) {
                    throw new InvalidBEncodingException("zero size file path list");
                }
                ArrayList<String> file = new ArrayList<String>(path_length);
                Iterator it = path_list.iterator();
                while (it.hasNext()) {
                    file.add(((BEValue)it.next()).getString());
                }
                this.files.add(file);
                val = (BEValue)desc.get("path.utf-8");
                if (val == null || (path_length = (path_list = val.getList()).size()) <= 0) continue;
                file = new ArrayList(path_length);
                it = path_list.iterator();
                while (it.hasNext()) {
                    file.add(((BEValue)it.next()).getString());
                }
                this.files_utf8.add(file);
            }
            this.length = l;
        }
        this.info_hash = this.calculateInfoHash();
    }

    public String getAnnounce() {
        return this.announce;
    }

    public byte[] getInfoHash() {
        return this.info_hash;
    }

    byte[] getPieceHashes() {
        return this.piece_hashes;
    }

    public String getName() {
        return this.name;
    }

    public List getFiles() {
        return this.files;
    }

    public List getLengths() {
        return this.lengths;
    }

    public int getPieces() {
        return this.piece_hashes.length / 20;
    }

    public int getPieceLength(int piece) {
        int pieces = this.getPieces();
        if (piece >= 0 && piece < pieces - 1) {
            return this.piece_length;
        }
        if (piece == pieces - 1) {
            return (int)(this.length - (long)(piece * this.piece_length));
        }
        throw new IndexOutOfBoundsException("no piece: " + piece);
    }

    public boolean checkPiece(int piece, byte[] bs, int off, int length) {
        return this.fast_checkPiece(piece, bs, off, length);
    }

    private boolean orig_checkPiece(int piece, byte[] bs, int off, int length) {
        MessageDigest sha1;
        try {
            sha1 = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new InternalError("No SHA digest available: " + nsae);
        }
        sha1.update(bs, off, length);
        byte[] hash = sha1.digest();
        for (int i = 0; i < 20; ++i) {
            if (hash[i] == this.piece_hashes[20 * piece + i]) continue;
            return false;
        }
        return true;
    }

    private boolean fast_checkPiece(int piece, byte[] bs, int off, int length) {
        SHA1 sha1 = new SHA1();
        sha1.update(bs, off, length);
        byte[] hash = sha1.digest();
        for (int i = 0; i < 20; ++i) {
            if (hash[i] == this.piece_hashes[20 * piece + i]) continue;
            return false;
        }
        return true;
    }

    public long getTotalLength() {
        return this.length;
    }

    public String toString() {
        return "MetaInfo[info_hash='" + MetaInfo.hexencode(this.info_hash) + "', announce='" + this.announce + "', name='" + this.name + "', files=" + this.files + ", #pieces='" + this.piece_hashes.length / 20 + "', piece_length='" + this.piece_length + "', length='" + this.length + "']";
    }

    private static String hexencode(byte[] bs) {
        StringBuilder sb = new StringBuilder(bs.length * 2);
        for (int i = 0; i < bs.length; ++i) {
            int c = bs[i] & 0xFF;
            if (c < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(c));
        }
        return sb.toString();
    }

    public MetaInfo reannounce(String announce) {
        return new MetaInfo(announce, this.name, this.name_utf8, this.files, this.lengths, this.piece_length, this.piece_hashes, this.length);
    }

    public byte[] getTorrentData() {
        if (this.torrentdata == null) {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("announce", this.announce);
            Map info = this.createInfoMap();
            m.put("info", info);
            this.torrentdata = BEncoder.bencode(m);
        }
        return this.torrentdata;
    }

    private Map createInfoMap() {
        HashMap<String, Object> info = new HashMap<String, Object>();
        if (this.infoMap != null) {
            info.putAll(this.infoMap);
            return info;
        }
        info.put("name", this.name);
        if (this.name_utf8 != null) {
            info.put("name.utf-8", this.name_utf8);
        }
        info.put("piece length", this.piece_length);
        info.put("pieces", this.piece_hashes);
        if (this.files == null) {
            info.put("length", new Long(this.length));
        } else {
            ArrayList l = new ArrayList();
            for (int i = 0; i < this.files.size(); ++i) {
                HashMap file = new HashMap();
                file.put("path", this.files.get(i));
                if (this.files_utf8 != null && this.files_utf8.size() > i) {
                    file.put("path.utf-8", this.files_utf8.get(i));
                }
                file.put("length", this.lengths.get(i));
                l.add(file);
            }
            info.put("files", l);
        }
        return info;
    }

    private byte[] calculateInfoHash() {
        Map info = this.createInfoMap();
        StringBuilder buf = new StringBuilder(128);
        buf.append("info: ");
        for (Map.Entry entry : info.entrySet()) {
            String key = (String)entry.getKey();
            Object val = entry.getValue();
            buf.append(key).append('=');
            if (val instanceof byte[]) {
                buf.append(Base64.encode((byte[])val, true));
                continue;
            }
            buf.append(val.toString());
        }
        _log.debug(buf.toString());
        byte[] infoBytes = BEncoder.bencode(info);
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA");
            byte[] hash = digest.digest(infoBytes);
            _log.debug("info hash: [" + Base64.encode(hash) + "]");
            return hash;
        }
        catch (NoSuchAlgorithmException nsa) {
            throw new InternalError(nsa.toString());
        }
    }
}

