/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.SecureRandom;
import net.i2p.I2PAppContext;
import net.i2p.crypto.EntropyHarvester;
import net.i2p.data.Base64;
import net.i2p.util.Log;

public class RandomSource
extends SecureRandom
implements EntropyHarvester {
    private Log _log;
    private EntropyHarvester _entropyHarvester;
    protected I2PAppContext _context;
    private static final String SEEDFILE = "prngseed.rnd";
    static /* synthetic */ Class class$net$i2p$util$RandomSource;

    public RandomSource(I2PAppContext context) {
        this._context = context;
        this._log = context.logManager().getLog(class$net$i2p$util$RandomSource == null ? (class$net$i2p$util$RandomSource = RandomSource.class$("net.i2p.util.RandomSource")) : class$net$i2p$util$RandomSource);
        this._entropyHarvester = this;
    }

    public static RandomSource getInstance() {
        return I2PAppContext.getGlobalContext().random();
    }

    public int nextInt(int n) {
        if (n == 0) {
            return 0;
        }
        int val = super.nextInt(n);
        if (val < 0) {
            val = 0 - val;
        }
        if (val >= n) {
            val %= n;
        }
        return val;
    }

    public long nextLong(long n) {
        long v = super.nextLong();
        if (v < 0L) {
            v = 0L - v;
        }
        if (v >= n) {
            v %= n;
        }
        return v;
    }

    public boolean nextBoolean() {
        return super.nextBoolean();
    }

    public void nextBytes(byte[] buf) {
        super.nextBytes(buf);
    }

    public double nextDouble() {
        return super.nextDouble();
    }

    public float nextFloat() {
        return super.nextFloat();
    }

    public double nextGaussian() {
        return super.nextGaussian();
    }

    public int nextInt() {
        return super.nextInt();
    }

    public long nextLong() {
        return super.nextLong();
    }

    public EntropyHarvester harvester() {
        return this._entropyHarvester;
    }

    public void feedEntropy(String source, long data, int bitoffset, int bits) {
        if (bitoffset == 0) {
            this.setSeed(data);
        }
    }

    public void feedEntropy(String source, byte[] data, int offset, int len) {
        if (offset == 0 && len == data.length) {
            this.setSeed(data);
        } else {
            this.setSeed(this._context.sha().calculateHash(data, offset, len).getData());
        }
    }

    public void loadSeed() {
        byte[] buf = new byte[1024];
        if (this.initSeed(buf)) {
            this.setSeed(buf);
        }
    }

    public void saveSeed() {
        byte[] buf = new byte[1024];
        this.nextBytes(buf);
        RandomSource.writeSeed(buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void writeSeed(byte[] buf) {
        File f = new File(SEEDFILE);
        FileOutputStream fos = null;
        fos = new FileOutputStream(f);
        fos.write(buf);
        Object var5_3 = null;
        if (fos == null) return;
        try {
            fos.close();
            return;
        }
        catch (IOException ioe) {}
        return;
        {
            catch (IOException iOException) {
                Object var5_4 = null;
                if (fos == null) return;
                try {
                    fos.close();
                    return;
                }
                catch (IOException ioe) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (fos == null) throw throwable;
            try {
                fos.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public final boolean initSeed(byte[] buf) {
        boolean ok = RandomSource.seedFromFile("/dev/urandom", buf);
        ok = RandomSource.seedFromFile(SEEDFILE, buf) || ok;
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean seedFromFile(String filename, byte[] buf) {
        int read;
        int curRead;
        File f = new File(filename);
        if (!f.exists()) return false;
        FileInputStream fis = null;
        fis = new FileInputStream(f);
        byte[] tbuf = new byte[buf.length];
        for (read = 0; read < buf.length && (curRead = fis.read(tbuf, read, tbuf.length - read)) >= 0; read += curRead) {
        }
        for (int i = 0; i < read; ++i) {
            int n = i;
            buf[n] = (byte)(buf[n] ^ tbuf[i]);
        }
        boolean bl = true;
        Object var8_8 = null;
        if (fis == null) return bl;
        try {
            fis.close();
            return bl;
        }
        catch (IOException ioe2) {
            // empty catch block
        }
        return bl;
        catch (IOException ioe) {
            try {
                Object var8_9 = null;
                if (fis == null) return false;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (fis == null) throw throwable;
                try {
                    fis.close();
                    throw throwable;
                }
                catch (IOException ioe2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                fis.close();
                return false;
            }
            catch (IOException ioe2) {}
            return false;
        }
    }

    public static void main(String[] args) {
        for (int j = 0; j < 2; ++j) {
            RandomSource rs = new RandomSource(I2PAppContext.getGlobalContext());
            byte[] buf = new byte[1024];
            boolean seeded = rs.initSeed(buf);
            System.out.println("PRNG class hierarchy: ");
            for (Class<?> c = rs.getClass(); c != null; c = c.getSuperclass()) {
                System.out.println("\t" + c.getName());
            }
            System.out.println("Provider: \n" + rs.getProvider());
            if (seeded) {
                System.out.println("Initialized seed: " + Base64.encode(buf));
                rs.setSeed(buf);
            }
            for (int i = 0; i < 64; ++i) {
                rs.nextBytes(buf);
            }
            rs.saveSeed();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class DummyEntropyHarvester
    implements EntropyHarvester {
        private DummyEntropyHarvester() {
        }

        public void feedEntropy(String source, long data, int bitoffset, int bits) {
        }

        public void feedEntropy(String source, byte[] data, int offset, int len) {
        }
    }
}

