/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.i2p.util.Clock;
import net.i2p.util.LogManager;
import net.i2p.util.LogRecord;
import net.i2p.util.LogRecordFormatter;

class LogWriter
implements Runnable {
    private static final long CONFIG_READ_ITERVAL = 10000L;
    private long _lastReadConfig = 0L;
    private long _numBytesInCurrentFile = 0L;
    private OutputStream _currentOut;
    private int _rotationNum = -1;
    private String _logFilenamePattern;
    private File _currentFile;
    private LogManager _manager;
    private boolean _write;

    private LogWriter() {
    }

    public LogWriter(LogManager manager) {
        this._manager = manager;
    }

    public void stopWriting() {
        this._write = false;
    }

    public void run() {
        this._write = true;
        try {
            this.rotateFile();
            while (this._write) {
                this.flushRecords();
                this.rereadConfig();
            }
            System.err.println("Done writing");
        }
        catch (Exception e) {
            System.err.println("Error writing the logs: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void flushRecords() {
        this.flushRecords(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void flushRecords(boolean shouldWait) {
        block21: {
            block20: {
                try {
                    try {
                        records = this._manager._removeAll();
                        if (records == null) {
                            var6_4 = null;
                            if (shouldWait == false) return;
                            break block20;
                        }
                        for (i = 0; i < records.size(); ++i) {
                            rec = (LogRecord)records.get(i);
                            this.writeRecord(rec);
                        }
                        if (records.size() > 0) {
                            try {
                                this._currentOut.flush();
                            }
                            catch (IOException ioe) {
                                System.err.println("Error flushing the records");
                            }
                        }
                        break block21;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        var6_6 = null;
                        if (shouldWait == false) return;
                        try {
                            var7_12 = this;
                            synchronized (var7_12) {
                                this.wait(10000L);
                                return;
                            }
                        }
                        catch (InterruptedException ie) {
                            return;
                        }
                    }
                }
                catch (Throwable var5_19) {
                    var6_7 = null;
                    if (shouldWait == false) throw var5_19;
                    ** try [egrp 3[TRYBLOCK] [9 : 111->140)] { 
lbl38:
                    // 1 sources

                    var7_14 = this;
                    synchronized (var7_14) {
                        this.wait(10000L);
                        throw var5_19;
                    }
lbl42:
                    // 1 sources

                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    throw var5_19;
                }
            }
            ** try [egrp 3[TRYBLOCK] [9 : 111->140)] { 
lbl47:
            // 1 sources

            var7_8 = this;
            synchronized (var7_8) {
                this.wait(10000L);
                return;
            }
lbl51:
            // 1 sources

            catch (InterruptedException ie) {
                // empty catch block
            }
            return;
        }
        var6_5 = null;
        if (shouldWait == false) return;
        try {}
        catch (InterruptedException ie) {}
        var7_10 = this;
        synchronized (var7_10) {
            this.wait(10000L);
            return;
        }
    }

    private void rereadConfig() {
        long now = Clock.getInstance().now();
        if (now - this._lastReadConfig > 10000L) {
            this._manager.rereadConfig();
            this._lastReadConfig = now;
        }
    }

    private void writeRecord(LogRecord rec) {
        String val = LogRecordFormatter.formatRecord(this._manager, rec);
        this.writeRecord(val);
        this._manager.getBuffer().add(val);
        if (rec.getPriority() >= 50) {
            this._manager.getBuffer().addCritical(val);
        }
        if (this._manager.getDisplayOnScreenLevel() <= rec.getPriority() && this._manager.displayOnScreen()) {
            System.out.print(val);
        }
    }

    private void writeRecord(String val) {
        if (val == null) {
            return;
        }
        if (this._currentOut == null) {
            this.rotateFile();
        }
        byte[] b = new byte[val.length()];
        for (int i = 0; i < b.length; ++i) {
            b[i] = (byte)val.charAt(i);
        }
        try {
            this._currentOut.write(b);
            this._numBytesInCurrentFile += (long)b.length;
        }
        catch (Throwable t) {
            System.err.println("Error writing record, disk full?");
            t.printStackTrace();
        }
        if (this._numBytesInCurrentFile >= (long)this._manager.getFileSize()) {
            this.rotateFile();
        }
    }

    private void rotateFile() {
        File f;
        String pattern = this._manager.getBaseLogfilename();
        this._currentFile = f = this.getNextFile(pattern);
        this._numBytesInCurrentFile = 0L;
        File parent = f.getParentFile();
        if (parent != null) {
            boolean ok;
            if (!parent.exists() && !(ok = parent.mkdirs())) {
                System.err.println("Unable to create the parent directy: " + parent.getAbsolutePath());
                System.exit(0);
            }
            if (!parent.isDirectory()) {
                System.err.println("wtf, we cannot put the logs in a subdirectory of a plain file!  we want to stre the log as " + f.getAbsolutePath());
                System.exit(0);
            }
        }
        try {
            this._currentOut = new FileOutputStream(f);
        }
        catch (IOException ioe) {
            System.err.println("Error rotating into [" + f.getAbsolutePath() + "]");
            ioe.printStackTrace();
        }
    }

    private File getNextFile(String pattern) {
        Object f = null;
        if (pattern.indexOf(35) < 0 && pattern.indexOf(64) <= 0) {
            return new File(pattern);
        }
        int max = this._manager.getRotationLimit();
        if (this._rotationNum == -1) {
            return this.getFirstFile(pattern, max);
        }
        ++this._rotationNum;
        if (this._rotationNum > max) {
            this._rotationNum = 0;
        }
        return new File(LogWriter.replace(pattern, this._rotationNum));
    }

    private File getFirstFile(String pattern, int max) {
        for (int i = 0; i < max; ++i) {
            File f = new File(LogWriter.replace(pattern, i));
            if (f.exists()) continue;
            this._rotationNum = i;
            return f;
        }
        File oldest = null;
        for (int i = 0; i < max; ++i) {
            File f = new File(LogWriter.replace(pattern, i));
            if (oldest == null) {
                oldest = f;
                continue;
            }
            if (f.lastModified() >= oldest.lastModified()) continue;
            this._rotationNum = i;
            oldest = f;
        }
        return oldest;
    }

    private static final String replace(String pattern, int num) {
        char[] c = pattern.toCharArray();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] != '#' && c[i] != '@') {
                buf.append(c[i]);
                continue;
            }
            buf.append(num);
        }
        return buf.toString();
    }
}

