/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import net.i2p.I2PAppContext;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.LogConsoleBuffer;
import net.i2p.util.LogLimit;
import net.i2p.util.LogRecord;
import net.i2p.util.LogWriter;

public class LogManager {
    public static final String CONFIG_LOCATION_PROP = "loggerConfigLocation";
    public static final String FILENAME_OVERRIDE_PROP = "loggerFilenameOverride";
    public static final String CONFIG_LOCATION_DEFAULT = "logger.config";
    public static final char DATE = 'd';
    public static final char CLASS = 'c';
    public static final char THREAD = 't';
    public static final char PRIORITY = 'p';
    public static final char MESSAGE = 'm';
    public static final String PROP_FORMAT = "logger.format";
    public static final String PROP_DATEFORMAT = "logger.dateFormat";
    public static final String PROP_FILENAME = "logger.logFileName";
    public static final String PROP_FILESIZE = "logger.logFileSize";
    public static final String PROP_ROTATIONLIMIT = "logger.logRotationLimit";
    public static final String PROP_DISPLAYONSCREEN = "logger.displayOnScreen";
    public static final String PROP_CONSOLEBUFFERSIZE = "logger.consoleBufferSize";
    public static final String PROP_DISPLAYONSCREENLEVEL = "logger.minimumOnScreenLevel";
    public static final String PROP_DEFAULTLEVEL = "logger.defaultLevel";
    public static final String PROP_RECORD_PREFIX = "logger.record.";
    public static final String DEFAULT_FORMAT = "d p [t] c: m";
    public static final String DEFAULT_DATEFORMAT = "HH:mm:ss.SSS";
    public static final String DEFAULT_FILENAME = "logs/log-#.txt";
    public static final String DEFAULT_FILESIZE = "10m";
    public static final boolean DEFAULT_DISPLAYONSCREEN = true;
    public static final int DEFAULT_CONSOLEBUFFERSIZE = 20;
    public static final String DEFAULT_ROTATIONLIMIT = "2";
    public static final String DEFAULT_DEFAULTLEVEL = "ERROR";
    public static final String DEFAULT_ONSCREENLEVEL = "CRIT";
    private I2PAppContext _context;
    private Log _log;
    private long _configLastRead;
    private String _location;
    private List _records;
    private List _limits;
    private Map _logs;
    private LogWriter _writer;
    private int _defaultLimit;
    private char[] _format;
    private SimpleDateFormat _dateFormat;
    private String _dateFormatPattern;
    private String _baseLogfilename;
    private int _fileSize;
    private int _rotationLimit;
    private int _onScreenLimit;
    private boolean _displayOnScreen;
    private int _consoleBufferSize;
    private LogConsoleBuffer _consoleBuffer;
    private boolean _alreadyNoticedMissingConfig;
    private static int __id = 0;
    static /* synthetic */ Class class$net$i2p$util$LogManager;

    public LogManager(I2PAppContext context) {
        this._displayOnScreen = true;
        this._alreadyNoticedMissingConfig = false;
        this._records = new ArrayList();
        this._limits = new ArrayList(128);
        this._logs = new HashMap(128);
        this._defaultLimit = 40;
        this._configLastRead = 0L;
        this._location = context.getProperty(CONFIG_LOCATION_PROP, CONFIG_LOCATION_DEFAULT);
        this._context = context;
        this._log = this.getLog(class$net$i2p$util$LogManager == null ? (class$net$i2p$util$LogManager = LogManager.class$("net.i2p.util.LogManager")) : class$net$i2p$util$LogManager);
        this._consoleBuffer = new LogConsoleBuffer(context);
        this.loadConfig();
        this._writer = new LogWriter(this);
        I2PThread t = new I2PThread(this._writer);
        t.setName("LogWriter");
        t.setDaemon(true);
        t.start();
        try {
            Runtime.getRuntime().addShutdownHook(new ShutdownHook());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private LogManager() {
    }

    public Log getLog(Class cls) {
        return this.getLog(cls, null);
    }

    public Log getLog(String name) {
        return this.getLog(null, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Log getLog(Class cls, String name) {
        Log rv = null;
        String scope = Log.getScope(name, cls);
        boolean isNew = false;
        Map map = this._logs;
        synchronized (map) {
            rv = (Log)this._logs.get(scope);
            if (rv == null) {
                rv = new Log(this, cls, name);
                this._logs.put(scope, rv);
                isNew = true;
            }
        }
        if (isNew) {
            this.updateLimit(rv);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getLogs() {
        ArrayList rv = null;
        Map map = this._logs;
        synchronized (map) {
            rv = new ArrayList(this._logs.values());
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLog(Log log) {
        Map map = this._logs;
        synchronized (map) {
            if (!this._logs.containsKey(log.getScope())) {
                this._logs.put(log.getScope(), log);
            }
        }
        this.updateLimit(log);
    }

    public LogConsoleBuffer getBuffer() {
        return this._consoleBuffer;
    }

    public void setDisplayOnScreen(boolean yes) {
        this._displayOnScreen = yes;
    }

    public boolean displayOnScreen() {
        return this._displayOnScreen;
    }

    public int getDisplayOnScreenLevel() {
        return this._onScreenLimit;
    }

    public void setDisplayOnScreenLevel(int level) {
        this._onScreenLimit = level;
    }

    public int getConsoleBufferSize() {
        return this._consoleBufferSize;
    }

    public void setConsoleBufferSize(int numRecords) {
        this._consoleBufferSize = numRecords;
    }

    public void setConfig(String filename) {
        this._log.debug("Config filename set to " + filename);
        this._location = filename;
        this.loadConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRecord(LogRecord record) {
        int numRecords = 0;
        Object object = this._records;
        synchronized (object) {
            this._records.add(record);
            numRecords = this._records.size();
        }
        if (numRecords > 100) {
            object = this._writer;
            synchronized (object) {
                this._writer.notifyAll();
            }
        }
    }

    void rereadConfig() {
        if (this._log.shouldLog(10)) {
            this._log.debug("Rereading configuration file");
        }
        this.loadConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void loadConfig() {
        block17: {
            cfgFile = new File(this._location);
            if (!cfgFile.exists()) {
                if (!this._alreadyNoticedMissingConfig) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Log file " + this._location + " does not exist");
                    }
                    this._alreadyNoticedMissingConfig = true;
                }
                this.parseConfig(new Properties());
                this.updateLimits();
                return;
            }
            this._alreadyNoticedMissingConfig = false;
            if (this._configLastRead > 0L && this._configLastRead >= cfgFile.lastModified()) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Short circuiting config read (last read: " + (this._context.clock().now() - this._configLastRead) + "ms ago, config file modified " + (this._context.clock().now() - cfgFile.lastModified()) + "ms ago");
                }
                return;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Loading config from " + this._location);
            }
            p = new Properties();
            fis = null;
            try {
                fis = new FileInputStream(cfgFile);
                p.load(fis);
                this._configLastRead = this._context.clock().now();
                var6_4 = null;
                ** if (fis == null) goto lbl-1000
            }
            catch (Throwable var5_11) {
                var6_6 = null;
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                throw var5_11;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    fis.close();
                }
                catch (IOException ioe) {}
            }
lbl-1000:
            // 2 sources

            {
                break block17;
                catch (IOException ioe) {
                    System.err.println("Error loading logger config from " + new File(this._location).getAbsolutePath());
                    var6_5 = null;
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException ioe) {}
                    }
                }
            }
        }
        this.parseConfig(p);
        this.updateLimits();
    }

    private void parseConfig(Properties config) {
        String str;
        String df;
        String fmt = config.getProperty(PROP_FORMAT, DEFAULT_FORMAT);
        this._format = fmt.toCharArray();
        this._dateFormatPattern = df = config.getProperty(PROP_DATEFORMAT, DEFAULT_DATEFORMAT);
        this._dateFormat = new SimpleDateFormat(df);
        String disp = config.getProperty(PROP_DISPLAYONSCREEN);
        this._displayOnScreen = disp == null ? true : ("TRUE".equals(disp.toUpperCase().trim()) ? true : "YES".equals(disp.toUpperCase().trim()));
        String filenameOverride = this._context.getProperty(FILENAME_OVERRIDE_PROP);
        this._baseLogfilename = filenameOverride != null ? filenameOverride : config.getProperty(PROP_FILENAME, DEFAULT_FILENAME);
        this._fileSize = this.getFileSize(config.getProperty(PROP_FILESIZE, DEFAULT_FILESIZE));
        this._rotationLimit = -1;
        try {
            str = config.getProperty(PROP_ROTATIONLIMIT);
            this._rotationLimit = Integer.parseInt(config.getProperty(PROP_ROTATIONLIMIT, DEFAULT_ROTATIONLIMIT));
        }
        catch (NumberFormatException nfe) {
            System.err.println("Invalid rotation limit");
            nfe.printStackTrace();
        }
        this._defaultLimit = Log.getLevel(config.getProperty(PROP_DEFAULTLEVEL, DEFAULT_DEFAULTLEVEL));
        this._onScreenLimit = Log.getLevel(config.getProperty(PROP_DISPLAYONSCREENLEVEL, DEFAULT_ONSCREENLEVEL));
        try {
            str = config.getProperty(PROP_CONSOLEBUFFERSIZE);
            this._consoleBufferSize = str == null ? 20 : Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            System.err.println("Invalid console buffer size");
            nfe.printStackTrace();
            this._consoleBufferSize = 20;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Log set to use the base log file as " + this._baseLogfilename);
        }
        this.parseLimits(config);
    }

    private void parseLimits(Properties config) {
        this.parseLimits(config, PROP_RECORD_PREFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseLimits(Properties config, String recordPrefix) {
        List list = this._limits;
        synchronized (list) {
            this._limits.clear();
        }
        if (config != null) {
            Iterator<Object> iter = config.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String val = config.getProperty(key);
                if (recordPrefix != null) {
                    if (!key.startsWith(recordPrefix)) continue;
                    key = key.substring(recordPrefix.length());
                }
                LogLimit lim = new LogLimit(key, Log.getLevel(val));
                List list2 = this._limits;
                synchronized (list2) {
                    if (!this._limits.contains(lim)) {
                        this._limits.add(lim);
                    }
                }
            }
        }
        this.updateLimits();
    }

    public void setLimits(Properties limits) {
        this.parseLimits(limits, null);
    }

    public boolean setDateFormat(String format) {
        if (format == null) {
            return false;
        }
        try {
            SimpleDateFormat fmt = new SimpleDateFormat(format);
            this._dateFormatPattern = format;
            this._dateFormat = fmt;
            return true;
        }
        catch (IllegalArgumentException iae) {
            this.getLog(class$net$i2p$util$LogManager == null ? (class$net$i2p$util$LogManager = LogManager.class$("net.i2p.util.LogManager")) : class$net$i2p$util$LogManager).error("Date format is invalid [" + format + "]", iae);
            return false;
        }
    }

    public void setFileSize(int numBytes) {
        if (numBytes > 0) {
            this._fileSize = numBytes;
        }
    }

    public String getDefaultLimit() {
        return Log.toLevelString(this._defaultLimit);
    }

    public void setDefaultLimit(String lim) {
        this._defaultLimit = Log.getLevel(lim);
        this.updateLimits();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getLimits() {
        Properties rv = new Properties();
        List list = this._limits;
        synchronized (list) {
            for (int i = 0; i < this._limits.size(); ++i) {
                LogLimit lim = (LogLimit)this._limits.get(i);
                rv.setProperty(lim.getRootName(), Log.toLevelString(lim.getLimit()));
            }
        }
        return rv;
    }

    public int getFileSize(String size) {
        int sz = -1;
        try {
            String v = size;
            char mod = size.toUpperCase().charAt(size.length() - 1);
            if (!Character.isDigit(mod)) {
                v = size.substring(0, size.length() - 1);
            }
            int val = Integer.parseInt(v);
            switch (mod) {
                case 'K': {
                    val *= 1024;
                    break;
                }
                case 'M': {
                    val *= 0x100000;
                    break;
                }
                case 'G': {
                    val *= 0x40000000;
                    break;
                }
            }
            return val;
        }
        catch (Throwable t) {
            System.err.println("Error parsing config for filesize: [" + size + "]");
            t.printStackTrace();
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLimits() {
        HashMap logs = null;
        Map map = this._logs;
        synchronized (map) {
            logs = new HashMap(this._logs);
        }
        Iterator iter = logs.values().iterator();
        while (iter.hasNext()) {
            Log log = (Log)iter.next();
            this.updateLimit(log);
        }
    }

    private void updateLimit(Log log) {
        List limits = this.getLimits(log);
        LogLimit max = null;
        LogLimit notMax = null;
        if (limits != null) {
            for (int i = 0; i < limits.size(); ++i) {
                LogLimit cur = (LogLimit)limits.get(i);
                if (max == null) {
                    max = cur;
                    continue;
                }
                if (cur.getRootName().length() <= max.getRootName().length()) continue;
                notMax = max;
                max = cur;
            }
        }
        if (max != null) {
            log.setMinimumPriority(max.getLimit());
        } else {
            log.setMinimumPriority(this._defaultLimit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getLimits(Log log) {
        ArrayList<LogLimit> limits = null;
        List list = this._limits;
        synchronized (list) {
            for (int i = 0; i < this._limits.size(); ++i) {
                LogLimit limit = (LogLimit)this._limits.get(i);
                if (!limit.matches(log)) continue;
                if (limits == null) {
                    limits = new ArrayList<LogLimit>(4);
                }
                limits.add(limit);
            }
        }
        return limits;
    }

    public String getBaseLogfilename() {
        return this._baseLogfilename;
    }

    public void setBaseLogfilename(String filenamePattern) {
        this._baseLogfilename = filenamePattern;
    }

    public int getFileSize() {
        return this._fileSize;
    }

    public int getRotationLimit() {
        return this._rotationLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean saveConfig() {
        boolean bl;
        String config = this.createConfig();
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(this._location);
                fos.write(config.getBytes());
                bl = true;
                Object var6_5 = null;
                if (fos == null) return bl;
            }
            catch (IOException ioe) {
                this.getLog(class$net$i2p$util$LogManager == null ? (class$net$i2p$util$LogManager = LogManager.class$("net.i2p.util.LogManager")) : class$net$i2p$util$LogManager).error("Error saving the config", ioe);
                boolean bl2 = false;
                Object var6_6 = null;
                if (fos == null) return bl2;
                try {
                    fos.close();
                    return bl2;
                }
                catch (IOException ioe2) {
                    // empty catch block
                }
                return bl2;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (fos == null) throw throwable;
            try {}
            catch (IOException ioe2) {
                throw throwable;
            }
            fos.close();
            throw throwable;
        }
        try {}
        catch (IOException ioe2) {
            // empty catch block
            return bl;
        }
        fos.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createConfig() {
        Object lim;
        StringBuffer buf = new StringBuffer(8192);
        buf.append(PROP_FORMAT).append('=').append(new String(this._format)).append('\n');
        buf.append(PROP_DATEFORMAT).append('=').append(this._dateFormatPattern).append('\n');
        buf.append(PROP_DISPLAYONSCREEN).append('=').append(this._displayOnScreen ? "TRUE" : "FALSE").append('\n');
        String filenameOverride = this._context.getProperty(FILENAME_OVERRIDE_PROP);
        if (filenameOverride == null) {
            buf.append(PROP_FILENAME).append('=').append(this._baseLogfilename).append('\n');
        } else {
            buf.append(PROP_FILENAME).append('=').append(DEFAULT_FILENAME).append('\n');
        }
        if (this._fileSize >= 0x100000) {
            buf.append(PROP_FILESIZE).append('=').append(this._fileSize / 0x100000).append("m\n");
        } else if (this._fileSize >= 1024) {
            buf.append(PROP_FILESIZE).append('=').append(this._fileSize / 1024).append("k\n");
        } else if (this._fileSize > 0) {
            buf.append(PROP_FILESIZE).append('=').append(this._fileSize).append('\n');
        }
        buf.append(PROP_ROTATIONLIMIT).append('=').append(this._rotationLimit).append('\n');
        buf.append(PROP_DEFAULTLEVEL).append('=').append(Log.toLevelString(this._defaultLimit)).append('\n');
        buf.append(PROP_DISPLAYONSCREENLEVEL).append('=').append(Log.toLevelString(this._onScreenLimit)).append('\n');
        buf.append(PROP_CONSOLEBUFFERSIZE).append('=').append(this._consoleBufferSize).append('\n');
        buf.append("# log limit overrides:\n");
        TreeMap<String, String> limits = new TreeMap<String, String>();
        List list = this._limits;
        synchronized (list) {
            for (int i = 0; i < this._limits.size(); ++i) {
                lim = (LogLimit)this._limits.get(i);
                limits.put(((LogLimit)lim).getRootName(), Log.toLevelString(((LogLimit)lim).getLimit()));
            }
        }
        Iterator iter = limits.keySet().iterator();
        while (iter.hasNext()) {
            String path = (String)iter.next();
            lim = (String)limits.get(path);
            buf.append(PROP_RECORD_PREFIX).append(path);
            buf.append('=').append((String)lim).append('\n');
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List _removeAll() {
        ArrayList vals = null;
        List list = this._records;
        synchronized (list) {
            if (this._records.size() <= 0) {
                return null;
            }
            vals = new ArrayList(this._records);
            this._records.clear();
        }
        return vals;
    }

    public char[] getFormat() {
        return this._format;
    }

    public void setFormat(char[] fmt) {
        this._format = fmt;
    }

    public SimpleDateFormat getDateFormat() {
        return this._dateFormat;
    }

    public String getDateFormatPattern() {
        return this._dateFormatPattern;
    }

    public static void main(String[] args) {
        I2PAppContext ctx = new I2PAppContext();
        Log l1 = ctx.logManager().getLog("test.1");
        Log l2 = ctx.logManager().getLog("test.2");
        Log l21 = ctx.logManager().getLog("test.2.1");
        Log l = ctx.logManager().getLog("test");
        l.debug("this should fail");
        l.info("this should pass");
        l1.warn("this should pass");
        l1.info("this should fail");
        l2.error("this should fail");
        l21.debug("this should pass");
        l1.error("test exception", new Exception("test"));
        l1.error("test exception", new Exception("test"));
        try {
            Thread.sleep(2000L);
        }
        catch (Throwable t) {
            // empty catch block
        }
        System.exit(0);
    }

    public void shutdown() {
        this._log.log(30, "Shutting down logger");
        this._writer.flushRecords(false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ int access$004() {
        return ++__id;
    }

    private class ShutdownHook
    extends Thread {
        private int _id = LogManager.access$004();

        public void run() {
            this.setName("Log " + this._id + " shutdown ");
            LogManager.this.shutdown();
        }
    }
}

