/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.time;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.i2p.I2PAppContext;
import net.i2p.time.NtpClient;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

public class Timestamper
implements Runnable {
    private I2PAppContext _context;
    private Log _log;
    private List _servers;
    private List _listeners;
    private int _queryFrequency;
    private int _concurringServers;
    private volatile boolean _disabled;
    private boolean _daemon;
    private boolean _initialized;
    private static final int DEFAULT_QUERY_FREQUENCY = 300000;
    private static final String DEFAULT_SERVER_LIST = "0.pool.ntp.org, 1.pool.ntp.org, 2.pool.ntp.org";
    private static final boolean DEFAULT_DISABLED = true;
    private static final int DEFAULT_CONCURRING_SERVERS = 3;
    public static final String PROP_QUERY_FREQUENCY = "time.queryFrequencyMs";
    public static final String PROP_SERVER_LIST = "time.sntpServerList";
    public static final String PROP_DISABLED = "time.disabled";
    public static final String PROP_CONCURRING_SERVERS = "time.concurringServers";
    private static final int MAX_VARIANCE = 10000;
    static /* synthetic */ Class class$net$i2p$time$Timestamper;

    public Timestamper(I2PAppContext ctx) {
        this(ctx, null, true);
    }

    public Timestamper(I2PAppContext ctx, UpdateListener lsnr) {
        this(ctx, lsnr, true);
    }

    public Timestamper(I2PAppContext ctx, UpdateListener lsnr, boolean daemon) {
        this._context = ctx;
        this._daemon = daemon;
        this._initialized = false;
        this._servers = new ArrayList(1);
        this._listeners = new ArrayList(1);
        if (lsnr != null) {
            this._listeners.add(lsnr);
        }
        this.updateConfig();
        this.startTimestamper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getServerCount() {
        List list = this._servers;
        synchronized (list) {
            return this._servers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getServer(int index) {
        List list = this._servers;
        synchronized (list) {
            return (String)this._servers.get(index);
        }
    }

    public int getQueryFrequencyMs() {
        return this._queryFrequency;
    }

    public boolean getIsDisabled() {
        return this._disabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(UpdateListener lsnr) {
        List list = this._listeners;
        synchronized (list) {
            this._listeners.add(lsnr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(UpdateListener lsnr) {
        List list = this._listeners;
        synchronized (list) {
            this._listeners.remove(lsnr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getListenerCount() {
        List list = this._listeners;
        synchronized (list) {
            return this._listeners.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateListener getListener(int index) {
        List list = this._listeners;
        synchronized (list) {
            return (UpdateListener)this._listeners.get(index);
        }
    }

    private void startTimestamper() {
        I2PThread t = new I2PThread(this, "Timestamper");
        t.setPriority(1);
        t.setDaemon(this._daemon);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForInitialization() {
        try {
            Timestamper timestamper = this;
            synchronized (timestamper) {
                if (!this._initialized) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        this._log = this._context.logManager().getLog(class$net$i2p$time$Timestamper == null ? (class$net$i2p$time$Timestamper = Timestamper.class$("net.i2p.time.Timestamper")) : class$net$i2p$time$Timestamper);
        if (this._log.shouldLog(20)) {
            this._log.info("Starting timestamper");
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Starting up timestamper");
        }
        boolean lastFailed = false;
        block17: while (true) {
            try {
                while (true) {
                    this.updateConfig();
                    if (!this._disabled) {
                        String[] serverList = null;
                        List list = this._servers;
                        synchronized (list) {
                            serverList = new String[this._servers.size()];
                            for (int i = 0; i < serverList.length; ++i) {
                                serverList[i] = (String)this._servers.get(i);
                            }
                        }
                        if (this._log.shouldLog(10)) {
                            this._log.debug("Querying servers " + this._servers);
                        }
                        try {
                            lastFailed = !this.queryTime(serverList);
                        }
                        catch (IllegalArgumentException iae) {
                            if (!lastFailed && this._log.shouldLog(40)) {
                                this._log.error("Unable to reach any of the NTP servers - network disconnected?");
                            }
                            lastFailed = true;
                        }
                    }
                    this._initialized = true;
                    Timestamper serverList = this;
                    synchronized (serverList) {
                        this.notifyAll();
                    }
                    long sleepTime = this._context.random().nextInt(this._queryFrequency) + this._queryFrequency;
                    if (lastFailed) {
                        sleepTime = 30000L;
                    }
                    try {
                        Thread.sleep(sleepTime);
                        continue block17;
                    }
                    catch (InterruptedException ie) {
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable t) {
                this._log.log(50, "Timestamper died!", t);
                Timestamper timestamper = this;
                synchronized (timestamper) {
                    this.notifyAll();
                }
                return;
            }
        }
    }

    private boolean queryTime(String[] serverList) throws IllegalArgumentException {
        long[] found = new long[this._concurringServers];
        long now = -1L;
        long expectedDelta = 0L;
        for (int i = 0; i < this._concurringServers; ++i) {
            long delta;
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            now = NtpClient.currentTime(serverList);
            found[i] = delta = now - this._context.clock().now();
            if (i == 0) {
                if (Math.abs(delta) < 10000L) {
                    if (!this._log.shouldLog(20)) break;
                    this._log.info("a single SNTP query was within the tolerance (" + delta + "ms)");
                    break;
                }
                expectedDelta = delta;
                continue;
            }
            if (Math.abs(delta - expectedDelta) <= 10000L) continue;
            if (this._log.shouldLog(40)) {
                StringBuffer err = new StringBuffer(96);
                err.append("SNTP client variance exceeded at query ").append(i);
                err.append(".  expected = ");
                err.append(expectedDelta);
                err.append(", found = ");
                err.append(delta);
                err.append(" all deltas: ");
                for (int j = 0; j < found.length; ++j) {
                    err.append(found[j]).append(' ');
                }
                this._log.error(err.toString());
            }
            return false;
        }
        this.stampTime(now);
        if (this._log.shouldLog(10)) {
            StringBuffer buf = new StringBuffer(64);
            buf.append("Deltas: ");
            for (int i = 0; i < found.length; ++i) {
                buf.append(found[i]).append(' ');
            }
            this._log.debug(buf.toString());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stampTime(long now) {
        long before = this._context.clock().now();
        List list = this._listeners;
        synchronized (list) {
            for (int i = 0; i < this._listeners.size(); ++i) {
                UpdateListener lsnr = (UpdateListener)this._listeners.get(i);
                lsnr.setNow(now);
            }
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Stamped the time as " + now + " (delta=" + (now - before) + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConfig() {
        String serverList = this._context.getProperty(PROP_SERVER_LIST);
        if (serverList == null || serverList.trim().length() <= 0) {
            serverList = DEFAULT_SERVER_LIST;
        }
        List list = this._servers;
        synchronized (list) {
            this._servers.clear();
            StringTokenizer tok = new StringTokenizer(serverList, ",");
            while (tok.hasMoreTokens()) {
                String val = tok.nextToken();
                if ((val = val.trim()).length() <= 0) continue;
                this._servers.add(val);
            }
        }
        String freq = this._context.getProperty(PROP_QUERY_FREQUENCY);
        if (freq == null || freq.trim().length() <= 0) {
            freq = "300000";
        }
        try {
            int ms = Integer.parseInt(freq);
            if (ms > 60000) {
                this._queryFrequency = ms;
            } else {
                if (this._log != null && this._log.shouldLog(40)) {
                    this._log.error("Query frequency once every " + ms + "ms is too fast!");
                }
                this._queryFrequency = 300000;
            }
        }
        catch (NumberFormatException nfe) {
            if (this._log != null && this._log.shouldLog(30)) {
                this._log.warn("Invalid query frequency [" + freq + "], falling back on " + 300000);
            }
            this._queryFrequency = 300000;
        }
        String disabled = this._context.getProperty(PROP_DISABLED);
        if (disabled == null) {
            disabled = "true";
        }
        this._disabled = Boolean.valueOf(disabled);
        String concurring = this._context.getProperty(PROP_CONCURRING_SERVERS);
        if (concurring == null) {
            this._concurringServers = 3;
        } else {
            try {
                int servers = Integer.parseInt(concurring);
                this._concurringServers = servers > 0 && servers < 5 ? servers : 3;
            }
            catch (NumberFormatException nfe) {
                this._concurringServers = 3;
            }
        }
    }

    public static void main(String[] args) {
        System.setProperty(PROP_DISABLED, "false");
        System.setProperty(PROP_QUERY_FREQUENCY, "30000");
        I2PAppContext ctx = I2PAppContext.getGlobalContext();
        long now = ctx.clock().now();
        for (int i = 0; i < 300000; i += 61000) {
            try {
                Thread.sleep(61000L);
                continue;
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface UpdateListener {
        public void setNow(long var1);
    }
}

