/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.stat;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.i2p.I2PAppContext;
import net.i2p.stat.BufferedStatLog;
import net.i2p.stat.FrequencyStat;
import net.i2p.stat.RateStat;
import net.i2p.stat.StatLog;
import net.i2p.util.Log;

public class StatManager {
    private Log _log;
    private I2PAppContext _context;
    private Map _frequencyStats;
    private Map _rateStats;
    private StatLog _statLog;
    public static final String PROP_STAT_FILTER = "stat.logFilters";
    public static final String PROP_STAT_FILE = "stat.logFile";
    public static final String DEFAULT_STAT_FILE = "stats.log";
    static /* synthetic */ Class class$net$i2p$stat$StatManager;

    public StatManager(I2PAppContext context) {
        this._log = context.logManager().getLog(class$net$i2p$stat$StatManager == null ? (class$net$i2p$stat$StatManager = StatManager.class$("net.i2p.stat.StatManager")) : class$net$i2p$stat$StatManager);
        this._context = context;
        this._frequencyStats = Collections.synchronizedMap(new HashMap(128));
        this._rateStats = new HashMap(128);
        this._statLog = new BufferedStatLog(context);
    }

    public StatLog getStatLog() {
        return this._statLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatLog(StatLog log) {
        this._statLog = log;
        Map map = this._rateStats;
        synchronized (map) {
            Iterator iter = this._rateStats.values().iterator();
            while (iter.hasNext()) {
                RateStat rs = (RateStat)iter.next();
                rs.setStatLog(log);
            }
        }
    }

    public void createFrequencyStat(String name, String description, String group, long[] periods) {
        if (this._frequencyStats.containsKey(name)) {
            return;
        }
        this._frequencyStats.put(name, new FrequencyStat(name, description, group, periods));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRateStat(String name, String description, String group, long[] periods) {
        Map map = this._rateStats;
        synchronized (map) {
            if (this._rateStats.containsKey(name)) {
                return;
            }
            RateStat rs = new RateStat(name, description, group, periods);
            if (this._statLog != null) {
                rs.setStatLog(this._statLog);
            }
            this._rateStats.put(name, rs);
        }
    }

    public void updateFrequency(String name) {
        FrequencyStat freq = (FrequencyStat)this._frequencyStats.get(name);
        if (freq != null) {
            freq.eventOccurred();
        }
    }

    public void addRateData(String name, long data, long eventDuration) {
        RateStat stat = (RateStat)this._rateStats.get(name);
        if (stat != null) {
            stat.addData(data, eventDuration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void coalesceStats() {
        Object stat;
        Iterator iter;
        Map map = this._frequencyStats;
        synchronized (map) {
            iter = this._frequencyStats.values().iterator();
            while (iter.hasNext()) {
                stat = (FrequencyStat)iter.next();
                if (stat == null) continue;
                ((FrequencyStat)stat).coalesceStats();
            }
        }
        map = this._rateStats;
        synchronized (map) {
            iter = this._rateStats.values().iterator();
            while (iter.hasNext()) {
                stat = (RateStat)iter.next();
                if (stat == null) continue;
                ((RateStat)stat).coalesceStats();
            }
        }
    }

    public FrequencyStat getFrequency(String name) {
        return (FrequencyStat)this._frequencyStats.get(name);
    }

    public RateStat getRate(String name) {
        return (RateStat)this._rateStats.get(name);
    }

    public Set getFrequencyNames() {
        return new HashSet(this._frequencyStats.keySet());
    }

    public Set getRateNames() {
        return new HashSet(this._rateStats.keySet());
    }

    public boolean isRate(String statName) {
        return this._rateStats.containsKey(statName);
    }

    public boolean isFrequency(String statName) {
        return this._frequencyStats.containsKey(statName);
    }

    public Map getStatsByGroup() {
        Set names;
        Object stat;
        TreeMap groups = new TreeMap();
        Iterator iter = this._frequencyStats.values().iterator();
        while (iter.hasNext()) {
            stat = (FrequencyStat)iter.next();
            if (!groups.containsKey(((FrequencyStat)stat).getGroupName())) {
                groups.put(((FrequencyStat)stat).getGroupName(), new TreeSet());
            }
            names = (Set)groups.get(((FrequencyStat)stat).getGroupName());
            names.add(((FrequencyStat)stat).getName());
        }
        iter = this._rateStats.values().iterator();
        while (iter.hasNext()) {
            stat = (RateStat)iter.next();
            if (!groups.containsKey(((RateStat)stat).getGroupName())) {
                groups.put(((RateStat)stat).getGroupName(), new TreeSet());
            }
            names = (Set)groups.get(((RateStat)stat).getGroupName());
            names.add(((RateStat)stat).getName());
        }
        return groups;
    }

    public String getStatFilter() {
        return this._context.getProperty(PROP_STAT_FILTER);
    }

    public String getStatFile() {
        return this._context.getProperty(PROP_STAT_FILE, DEFAULT_STAT_FILE);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

