/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2cp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.I2CPMessageImpl;
import net.i2p.data.i2cp.SessionId;
import net.i2p.util.Log;

public class RequestLeaseSetMessage
extends I2CPMessageImpl {
    private static final Log _log = new Log(class$net$i2p$data$i2cp$RequestLeaseSetMessage == null ? (class$net$i2p$data$i2cp$RequestLeaseSetMessage = RequestLeaseSetMessage.class$("net.i2p.data.i2cp.RequestLeaseSetMessage")) : class$net$i2p$data$i2cp$RequestLeaseSetMessage);
    public static final int MESSAGE_TYPE = 21;
    private SessionId _sessionId;
    private List _endpoints;
    private Date _end;
    static /* synthetic */ Class class$net$i2p$data$i2cp$RequestLeaseSetMessage;

    public RequestLeaseSetMessage() {
        this.setSessionId(null);
        this._endpoints = new ArrayList();
        this.setEndDate(null);
    }

    public SessionId getSessionId() {
        return this._sessionId;
    }

    public void setSessionId(SessionId id) {
        this._sessionId = id;
    }

    public int getEndpoints() {
        return this._endpoints.size();
    }

    public Hash getRouter(int endpoint) {
        if (endpoint < 0 || this._endpoints.size() < endpoint) {
            return null;
        }
        return ((TunnelEndpoint)this._endpoints.get(endpoint)).getRouter();
    }

    public TunnelId getTunnelId(int endpoint) {
        if (endpoint < 0 || this._endpoints.size() < endpoint) {
            return null;
        }
        return ((TunnelEndpoint)this._endpoints.get(endpoint)).getTunnelId();
    }

    public void remoteEndpoint(int endpoint) {
        if (endpoint >= 0 && endpoint < this._endpoints.size()) {
            this._endpoints.remove(endpoint);
        }
    }

    public void addEndpoint(Hash router, TunnelId tunnel) {
        if (router == null) {
            throw new IllegalArgumentException("Null router (tunnel=" + tunnel + ")");
        }
        if (tunnel == null) {
            throw new IllegalArgumentException("Null tunnel (router=" + router + ")");
        }
        this._endpoints.add(new TunnelEndpoint(router, tunnel));
    }

    public Date getEndDate() {
        return this._end;
    }

    public void setEndDate(Date end) {
        this._end = end;
    }

    protected void doReadMessage(InputStream in, int size) throws I2CPMessageException, IOException {
        try {
            this._sessionId = new SessionId();
            this._sessionId.readBytes(in);
            int numTunnels = (int)DataHelper.readLong(in, 1);
            this._endpoints.clear();
            for (int i = 0; i < numTunnels; ++i) {
                Hash router = new Hash();
                router.readBytes(in);
                TunnelId tunnel = new TunnelId();
                tunnel.readBytes(in);
                this._endpoints.add(new TunnelEndpoint(router, tunnel));
            }
            this._end = DataHelper.readDate(in);
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Unable to load the message data", dfe);
        }
    }

    protected byte[] doWriteMessage() throws I2CPMessageException, IOException {
        if (this._sessionId == null || this._endpoints == null) {
            throw new I2CPMessageException("Unable to write out the message as there is not enough data");
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream(64);
        try {
            this._sessionId.writeBytes(os);
            DataHelper.writeLong(os, 1, this._endpoints.size());
            for (int i = 0; i < this._endpoints.size(); ++i) {
                Hash router = this.getRouter(i);
                router.writeBytes(os);
                TunnelId tunnel = this.getTunnelId(i);
                tunnel.writeBytes(os);
            }
            DataHelper.writeDate(os, this._end);
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Error writing out the message data", dfe);
        }
        return os.toByteArray();
    }

    public int getType() {
        return 21;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof RequestLeaseSetMessage) {
            RequestLeaseSetMessage msg = (RequestLeaseSetMessage)object;
            if (this.getEndpoints() != msg.getEndpoints()) {
                return false;
            }
            for (int i = 0; i < this.getEndpoints(); ++i) {
                if (DataHelper.eq(this.getRouter(i), msg.getRouter(i)) && DataHelper.eq(this.getTunnelId(i), msg.getTunnelId(i))) continue;
                return false;
            }
            return DataHelper.eq(this.getSessionId(), msg.getSessionId()) && DataHelper.eq(this.getEndDate(), msg.getEndDate());
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[RequestLeaseMessage: ");
        buf.append("\n\tSessionId: ").append(this.getSessionId());
        buf.append("\n\tTunnels:");
        for (int i = 0; i < this.getEndpoints(); ++i) {
            buf.append("\n\t\tRouterIdentity: ").append(this.getRouter(i));
            buf.append("\n\t\tTunnelId: ").append(this.getTunnelId(i));
        }
        buf.append("\n\tEndDate: ").append(this.getEndDate());
        buf.append("]");
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TunnelEndpoint {
        private Hash _router;
        private TunnelId _tunnelId;

        public TunnelEndpoint() {
            this._router = null;
            this._tunnelId = null;
        }

        public TunnelEndpoint(Hash router, TunnelId id) {
            this._router = router;
            this._tunnelId = id;
        }

        public Hash getRouter() {
            return this._router;
        }

        public void setRouter(Hash router) {
            this._router = router;
        }

        public TunnelId getTunnelId() {
            return this._tunnelId;
        }

        public void setTunnelId(TunnelId tunnelId) {
            this._tunnelId = tunnelId;
        }
    }
}

